/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.genetic.mutate;

import java.util.Random;
import org.encog.ml.ea.genome.Genome;
import org.encog.ml.ea.opp.EvolutionaryOperator;
import org.encog.ml.ea.train.EvolutionaryAlgorithm;
import org.encog.ml.genetic.genome.DoubleArrayGenome;

public class MutatePerturb
implements EvolutionaryOperator {
    private final double perturbAmount;

    public MutatePerturb(double thePerturbAmount) {
        this.perturbAmount = thePerturbAmount;
    }

    @Override
    public void performOperation(Random rnd, Genome[] parents, int parentIndex, Genome[] offspring, int offspringIndex) {
        DoubleArrayGenome parent = (DoubleArrayGenome)parents[parentIndex];
        offspring[offspringIndex] = parent.getPopulation().getGenomeFactory().factor();
        DoubleArrayGenome child = (DoubleArrayGenome)offspring[offspringIndex];
        for (int i = 0; i < parent.size(); ++i) {
            double value = parent.getData()[i];
            value += value * (this.perturbAmount - rnd.nextDouble() * this.perturbAmount * 2.0);
            child.getData()[i] = value;
        }
    }

    @Override
    public int offspringProduced() {
        return 1;
    }

    @Override
    public int parentsNeeded() {
        return 1;
    }

    @Override
    public void init(EvolutionaryAlgorithm theOwner) {
    }
}

