/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.hmm;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import org.encog.mathutil.matrices.Matrix;
import org.encog.ml.hmm.HiddenMarkovModel;
import org.encog.ml.hmm.distributions.ContinousDistribution;
import org.encog.ml.hmm.distributions.DiscreteDistribution;
import org.encog.ml.hmm.distributions.StateDistribution;
import org.encog.persist.EncogFileSection;
import org.encog.persist.EncogPersistor;
import org.encog.persist.EncogReadHelper;
import org.encog.persist.EncogWriteHelper;

public class PersistHMM
implements EncogPersistor {
    @Override
    public final int getFileVersion() {
        return 1;
    }

    @Override
    public final String getPersistClassString() {
        return "HiddenMarkovModel";
    }

    @Override
    public final Object read(InputStream is) {
        EncogFileSection section;
        int states = 0;
        double[] pi = null;
        Matrix transitionProbability = null;
        Map<String, String> properties = null;
        ArrayList<StateDistribution> distributions = new ArrayList<StateDistribution>();
        EncogReadHelper in = new EncogReadHelper(is);
        while ((section = in.readNextSection()) != null) {
            Map<String, String> params;
            if (section.getSectionName().equals("HMM") && section.getSubSectionName().equals("PARAMS")) {
                properties = section.parseParams();
            }
            if (section.getSectionName().equals("HMM") && section.getSubSectionName().equals("CONFIG")) {
                params = section.parseParams();
                states = EncogFileSection.parseInt(params, "sates");
                if (params.containsKey("items")) {
                    int[] nArray = EncogFileSection.parseIntArray(params, "items");
                }
                pi = section.parseDoubleArray(params, "pi");
                transitionProbability = EncogFileSection.parseMatrix(params, "transition");
                continue;
            }
            if (!section.getSectionName().equals("HMM") || !section.getSubSectionName().startsWith("DISTRIBUTION-")) continue;
            params = section.parseParams();
            String t = params.get("type");
            if ("ContinousDistribution".equals(t)) {
                double[] mean = section.parseDoubleArray(params, "mean");
                Matrix cova = EncogFileSection.parseMatrix(params, "covariance");
                ContinousDistribution dist = new ContinousDistribution(mean, cova.getData());
                distributions.add(dist);
                continue;
            }
            if (!"DiscreteDistribution".equals(t)) continue;
            Matrix prob = EncogFileSection.parseMatrix(params, "probabilities");
            StateDistribution dist = new DiscreteDistribution(prob.getData());
            distributions.add(dist);
        }
        HiddenMarkovModel result = new HiddenMarkovModel(states);
        result.getProperties().putAll(properties);
        result.setTransitionProbability(transitionProbability.getData());
        result.setPi(pi);
        int index = 0;
        for (StateDistribution dist : distributions) {
            result.setStateDistribution(index++, dist);
        }
        return result;
    }

    @Override
    public final void save(OutputStream os, Object obj) {
        EncogWriteHelper out = new EncogWriteHelper(os);
        HiddenMarkovModel net = (HiddenMarkovModel)obj;
        out.addSection("HMM");
        out.addSubSection("PARAMS");
        out.addProperties(net.getProperties());
        out.addSubSection("CONFIG");
        out.writeProperty("sates", net.getStateCount());
        if (net.getItems() != null) {
            out.writeProperty("items", net.getItems());
        }
        out.writeProperty("pi", net.getPi());
        out.writeProperty("transition", new Matrix(net.getTransitionProbability()));
        for (int i = 0; i < net.getStateCount(); ++i) {
            out.addSubSection("DISTRIBUTION-" + i);
            StateDistribution sd = net.getStateDistribution(i);
            out.writeProperty("type", sd.getClass().getSimpleName());
            if (sd instanceof ContinousDistribution) {
                ContinousDistribution cDist = (ContinousDistribution)sd;
                out.writeProperty("mean", cDist.getMean());
                out.writeProperty("covariance", cDist.getCovariance());
                continue;
            }
            if (!(sd instanceof DiscreteDistribution)) continue;
            DiscreteDistribution dDist = (DiscreteDistribution)sd;
            out.writeProperty("probabilities", new Matrix(dDist.getProbabilities()));
        }
        out.flush();
    }
}

