/*
 * Decompiled with CFR 0.152.
 */
package org.encog.plugin.system;

import org.encog.EncogError;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.ml.MLMethod;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.factory.train.AnnealFactory;
import org.encog.ml.factory.train.BackPropFactory;
import org.encog.ml.factory.train.ClusterSOMFactory;
import org.encog.ml.factory.train.EPLGAFactory;
import org.encog.ml.factory.train.GeneticFactory;
import org.encog.ml.factory.train.LMAFactory;
import org.encog.ml.factory.train.ManhattanFactory;
import org.encog.ml.factory.train.NEATGAFactory;
import org.encog.ml.factory.train.NeighborhoodSOMFactory;
import org.encog.ml.factory.train.NelderMeadFactory;
import org.encog.ml.factory.train.PNNTrainFactory;
import org.encog.ml.factory.train.PSOFactory;
import org.encog.ml.factory.train.QuickPropFactory;
import org.encog.ml.factory.train.RBFSVDFactory;
import org.encog.ml.factory.train.RPROPFactory;
import org.encog.ml.factory.train.SCGFactory;
import org.encog.ml.factory.train.SVMFactory;
import org.encog.ml.factory.train.SVMSearchFactory;
import org.encog.ml.factory.train.TrainBayesianFactory;
import org.encog.ml.train.MLTrain;
import org.encog.plugin.EncogPluginService1;

public class SystemTrainingPlugin
implements EncogPluginService1 {
    private final TrainBayesianFactory bayesianFactory = new TrainBayesianFactory();
    private final BackPropFactory backpropFactory = new BackPropFactory();
    private final LMAFactory lmaFactory = new LMAFactory();
    private final RPROPFactory rpropFactory = new RPROPFactory();
    private final SVMFactory svmFactory = new SVMFactory();
    private final SVMSearchFactory svmSearchFactory = new SVMSearchFactory();
    private final SCGFactory scgFactory = new SCGFactory();
    private final AnnealFactory annealFactory = new AnnealFactory();
    private final NelderMeadFactory nmFactory = new NelderMeadFactory();
    private final NeighborhoodSOMFactory neighborhoodFactory = new NeighborhoodSOMFactory();
    private final ClusterSOMFactory somClusterFactory = new ClusterSOMFactory();
    private final GeneticFactory geneticFactory = new GeneticFactory();
    private final ManhattanFactory manhattanFactory = new ManhattanFactory();
    private final RBFSVDFactory svdFactory = new RBFSVDFactory();
    private final PNNTrainFactory pnnFactory = new PNNTrainFactory();
    private final QuickPropFactory qpropFactory = new QuickPropFactory();
    private final PSOFactory psoFactory = new PSOFactory();
    private final NEATGAFactory neatGAFactory = new NEATGAFactory();
    private final EPLGAFactory eplTrainFctory = new EPLGAFactory();

    @Override
    public final String getPluginDescription() {
        return "This plugin provides the built in training methods for Encog.";
    }

    @Override
    public final String getPluginName() {
        return "HRI-System-Training";
    }

    @Override
    public final int getPluginType() {
        return 1;
    }

    @Override
    public ActivationFunction createActivationFunction(String name) {
        return null;
    }

    @Override
    public MLMethod createMethod(String methodType, String architecture, int input, int output) {
        return null;
    }

    @Override
    public MLTrain createTraining(MLMethod method, MLDataSet training, String type, String args) {
        String args2 = args;
        if (args2 == null) {
            args2 = "";
        }
        if ("rprop".equalsIgnoreCase(type)) {
            return this.rpropFactory.create(method, training, args2);
        }
        if ("backprop".equalsIgnoreCase(type)) {
            return this.backpropFactory.create(method, training, args2);
        }
        if ("scg".equalsIgnoreCase(type)) {
            return this.scgFactory.create(method, training, args2);
        }
        if ("lma".equalsIgnoreCase(type)) {
            return this.lmaFactory.create(method, training, args2);
        }
        if ("svm-train".equalsIgnoreCase(type)) {
            return this.svmFactory.create(method, training, args2);
        }
        if ("svm-search".equalsIgnoreCase(type)) {
            return this.svmSearchFactory.create(method, training, args2);
        }
        if ("som-neighborhood".equalsIgnoreCase(type)) {
            return this.neighborhoodFactory.create(method, training, args2);
        }
        if ("anneal".equalsIgnoreCase(type)) {
            return this.annealFactory.create(method, training, args2);
        }
        if ("genetic".equalsIgnoreCase(type)) {
            return this.geneticFactory.create(method, training, args2);
        }
        if ("som-cluster".equalsIgnoreCase(type)) {
            return this.somClusterFactory.create(method, training, args2);
        }
        if ("manhattan".equalsIgnoreCase(type)) {
            return this.manhattanFactory.create(method, training, args2);
        }
        if ("rbf-svd".equalsIgnoreCase(type)) {
            return this.svdFactory.create(method, training, args2);
        }
        if ("pnn".equalsIgnoreCase(type)) {
            return this.pnnFactory.create(method, training, args2);
        }
        if ("qprop".equalsIgnoreCase(type)) {
            return this.qpropFactory.create(method, training, args2);
        }
        if ("bayesian".equals(type)) {
            return this.bayesianFactory.create(method, training, args2);
        }
        if ("nm".equals(type)) {
            return this.nmFactory.create(method, training, args2);
        }
        if ("pso".equals(type)) {
            return this.psoFactory.create(method, training, args2);
        }
        if ("neat-ga".equals(type)) {
            return this.neatGAFactory.create(method, training, args2);
        }
        if ("epl-ga".equals(type)) {
            return this.eplTrainFctory.create(method, training, args2);
        }
        throw new EncogError("Unknown training type: " + type);
    }

    @Override
    public int getPluginServiceType() {
        return 0;
    }
}

