/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.normalize.output.mapped;

import java.util.ArrayList;
import java.util.List;
import org.encog.util.normalize.input.InputField;
import org.encog.util.normalize.output.BasicOutputField;
import org.encog.util.normalize.output.mapped.MappedRange;

public class OutputFieldEncode
extends BasicOutputField {
    private final InputField sourceField;
    private double catchAll;
    private final List<MappedRange> ranges = new ArrayList<MappedRange>();

    public OutputFieldEncode(InputField sourceField) {
        this.sourceField = sourceField;
    }

    public void addRange(double low, double high, double value) {
        MappedRange range = new MappedRange(low, high, value);
        this.ranges.add(range);
    }

    @Override
    public double calculate(int subfield) {
        for (MappedRange range : this.ranges) {
            if (!range.inRange(this.sourceField.getCurrentValue())) continue;
            return range.getValue();
        }
        return this.catchAll;
    }

    public double getCatchAll() {
        return this.catchAll;
    }

    public InputField getSourceField() {
        return this.sourceField;
    }

    @Override
    public int getSubfieldCount() {
        return 1;
    }

    @Override
    public void rowInit() {
    }

    public void setCatchAll(double catchAll) {
        this.catchAll = catchAll;
    }
}

