/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.text;

import java.io.UnsupportedEncodingException;
import org.encog.EncogError;

public class DoubleString {
    public static final double FRAC_SHIFT = 1.0E8;
    public static final int[] MULT = new int[]{65536, 256, 1};

    public static String convertDoubleToString(double[] target, int index) {
        boolean wholeMode = true;
        int currentIndex = index;
        int multIndex = 0;
        int len = (int)target[currentIndex];
        int encodedLen = (int)((target[currentIndex] - (double)len) * 1.0E8);
        byte[] encoded = new byte[encodedLen];
        int assembled = (int)target[++currentIndex];
        for (int i = 0; i < encoded.length; ++i) {
            encoded[i] = (byte)(assembled / MULT[multIndex]);
            assembled = (int)((double)assembled - target[currentIndex] * (double)MULT[multIndex]);
            if (++multIndex != MULT.length) continue;
            multIndex = 0;
            if (wholeMode) {
                double dec = encoded[currentIndex] - encoded[currentIndex];
                assembled = (int)(dec * 1.0E8);
                wholeMode = false;
                continue;
            }
            wholeMode = true;
            assembled = (int)target[currentIndex++];
        }
        try {
            return new String(encoded, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new EncogError(e);
        }
    }

    public static int convertStringToDouble(String str, double[] target, int targetIndex) {
        try {
            int multIndex = 0;
            int assemble = 0;
            boolean wholeMode = true;
            byte[] encoded = str.getBytes("UTF-8");
            int outputIndex = targetIndex;
            int len = encoded.length / 6;
            if (encoded.length % 6 > 0) {
                ++len;
            }
            target[outputIndex++] = (double)encoded.length / 1.0E8 + (double)len;
            for (int i = 0; i < encoded.length; ++i) {
                assemble += encoded[i] * MULT[multIndex++];
                if (multIndex < 3) continue;
                if (wholeMode) {
                    target[outputIndex] = assemble;
                } else {
                    int n = outputIndex++;
                    target[n] = target[n] + (double)assemble / 1.0E8;
                }
                multIndex = 0;
                wholeMode = !wholeMode;
                assemble = 0;
            }
            if (wholeMode) {
                target[outputIndex] = assemble;
            } else {
                int n = outputIndex++;
                target[n] = target[n] + (double)assemble / 1.0E8;
            }
            return outputIndex - targetIndex + 1;
        }
        catch (UnsupportedEncodingException e) {
            throw new EncogError(e);
        }
    }

    public static void main(String[] args) {
        String str = "This is a test";
        double[] target = new double[1024];
        int len = DoubleString.convertStringToDouble(str, target, 0);
        for (int i = 0; i < len; ++i) {
            System.out.println(target[i]);
        }
        System.out.println(DoubleString.convertDoubleToString(target, 0));
    }
}

