/*
 * Decompiled with CFR 0.152.
 */
package gnu.mail.providers.mbox;

import gnu.inet.util.GetSystemPropertyAction;
import gnu.inet.util.TraceLevel;
import gnu.mail.providers.mbox.MboxFolder;
import gnu.mail.treeutil.StatusEvent;
import gnu.mail.treeutil.StatusListener;
import gnu.mail.treeutil.StatusSource;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;

public final class MboxStore
extends Store
implements StatusSource {
    static final Logger logger = Logger.getLogger("gnu.mail.util.providers.mbox");
    static final Level MBOX_TRACE = new TraceLevel("mbox");
    private static final char separatorChar = '/';
    static boolean attemptFallback = true;
    File root;
    private List statusListeners = new ArrayList();

    public MboxStore(Session session, URLName urlname) {
        super(session, urlname);
        String af = session.getProperty("mail.mbox.attemptfallback");
        if (af != null) {
            attemptFallback = Boolean.valueOf(af);
        }
        if (session.getDebug()) {
            logger.setLevel(MBOX_TRACE);
        }
    }

    protected boolean protocolConnect(String host, int port, String username, String password) throws MessagingException {
        String mailhome;
        String path;
        if (this.url != null && (path = this.url.getFile()) != null && !"".equals(path)) {
            path = MboxStore.decodeUrlPath(path);
            if (File.separatorChar != '/') {
                path = path.replace('/', File.separatorChar);
            }
            this.root = new File(path);
            if (!this.root.exists() && File.separatorChar == '/') {
                this.root = new File("/" + path);
            }
        }
        if (this.root == null && (mailhome = this.session.getProperty("mail.mbox.mailhome")) != null) {
            this.root = new File(mailhome);
        }
        if (this.root == null) {
            GetSystemPropertyAction a = new GetSystemPropertyAction("user.name");
            String userhome = (String)AccessController.doPrivileged(a);
            this.root = new File(userhome, "Mail");
            if (!this.root.exists()) {
                this.root = new File(userhome, "mail");
                if (!this.root.exists()) {
                    this.root = null;
                }
            }
        }
        return true;
    }

    protected void setURLName(URLName url) {
        url = new URLName(url.getProtocol(), null, -1, url.getFile(), null, null);
        super.setURLName(url);
    }

    public Folder getDefaultFolder() throws MessagingException {
        return this.getFolder("");
    }

    public Folder getFolder(String name) throws MessagingException {
        return this.getFolder(name, false);
    }

    public Folder getFolder(URLName urlname) throws MessagingException {
        String path = urlname.getFile();
        if (path != null) {
            path = MboxStore.decodeUrlPath(path);
        }
        return this.getFolder(path, true);
    }

    private Folder getFolder(String name, boolean tryPrepend) throws MessagingException {
        if (File.separatorChar == '\\' && name != null && name.startsWith("\\\\\\")) {
            name = name.substring(3);
        }
        if (name == null || "".equals(name)) {
            return this.root != null ? new MboxFolder(this, this.root, false) : null;
        }
        File file = null;
        if (File.separatorChar != '/') {
            name = name.replace('/', File.separatorChar);
        }
        if (this.root != null && this.root.isDirectory()) {
            file = new File(this.root, name);
        }
        if (!(file != null && file.exists() || (file = new File(name)).exists() || !tryPrepend)) {
            file = new File(File.separator + name);
        }
        if ("INBOX".equalsIgnoreCase(name) && !file.exists()) {
            String inboxname;
            File inbox = file;
            if (this.root != null && this.root.isFile()) {
                inbox = this.root;
            }
            if (!inbox.exists() && (inboxname = this.session.getProperty("mail.mbox.inbox")) != null) {
                inbox = new File(inboxname);
            }
            if (!inbox.exists() && attemptFallback && File.separatorChar == '/') {
                GetSystemPropertyAction a;
                if (File.separatorChar == '/') {
                    a = new GetSystemPropertyAction("user.name");
                    String username = (String)AccessController.doPrivileged(a);
                    inbox = new File("/var/mail/" + username);
                    if (!inbox.exists()) {
                        inbox = new File("/var/spool/mail/" + username);
                    }
                }
                if (!inbox.exists()) {
                    a = new GetSystemPropertyAction("user.home");
                    String userhome = (String)AccessController.doPrivileged(a);
                    inbox = new File(userhome, "Mailbox");
                }
            }
            return new MboxFolder(this, inbox, true);
        }
        return new MboxFolder(this, file, false);
    }

    Session getSession() {
        return this.session;
    }

    void log(String message) {
        logger.log(MBOX_TRACE, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStatusListener(StatusListener l) {
        List list = this.statusListeners;
        synchronized (list) {
            this.statusListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeStatusListener(StatusListener l) {
        List list = this.statusListeners;
        synchronized (list) {
            this.statusListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processStatusEvent(StatusEvent event) {
        StatusListener[] listeners;
        List list = this.statusListeners;
        synchronized (list) {
            listeners = new StatusListener[this.statusListeners.size()];
            this.statusListeners.toArray(listeners);
        }
        switch (event.getType()) {
            case 0: {
                for (int i = 0; i < listeners.length; ++i) {
                    listeners[i].statusOperationStarted(event);
                }
                break;
            }
            case 1: {
                for (int i = 0; i < listeners.length; ++i) {
                    listeners[i].statusProgressUpdate(event);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < listeners.length; ++i) {
                    listeners[i].statusOperationEnded(event);
                }
                break;
            }
        }
    }

    static String decodeUrlPath(String path) {
        boolean hi = false;
        StringBuffer buf = null;
        int len = path.length();
        for (int i = 0; i < len; ++i) {
            char c = path.charAt(i);
            if (c == '%' && i < len - 2) {
                int code;
                if (buf == null) {
                    buf = new StringBuffer(path.substring(0, i));
                }
                if ((code = Integer.parseInt(path.substring(i + 1, i + 3), 16)) > 127) {
                    hi = true;
                }
                buf.append((char)code);
                i += 2;
                continue;
            }
            if (buf == null) continue;
            buf.append(c);
        }
        if (buf != null) {
            if (!hi) {
                return buf.toString();
            }
            len = buf.length();
            byte[] seq = new byte[len];
            for (int i = 0; i < len; ++i) {
                seq[i] = (byte)buf.charAt(i);
            }
            try {
                return new String(seq, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                RuntimeException e2 = new RuntimeException();
                e2.initCause(e);
                throw e2;
            }
        }
        return path;
    }

    static String encodeUrlPath(String path) {
        int len = path.length();
        StringBuffer buf = null;
        for (int i = 0; i < len; ++i) {
            char c = path.charAt(i);
            if (!MboxStore.isUnreservedPathChar(c)) {
                if (buf == null) {
                    buf = new StringBuffer(path.substring(0, i));
                }
                try {
                    byte[] seq = path.substring(i, i + 1).getBytes("UTF-8");
                    for (int j = 0; j < seq.length; ++j) {
                        String code = Integer.toHexString(seq[j]).toUpperCase();
                        buf.append('%');
                        if (code.length() < 2) {
                            buf.append('0');
                        }
                        buf.append(code);
                    }
                    return buf.toString();
                }
                catch (UnsupportedEncodingException e) {
                    RuntimeException e2 = new RuntimeException();
                    e2.initCause(e);
                    throw e2;
                }
            }
            if (buf == null) continue;
            buf.append(c);
        }
        return path;
    }

    static boolean isUnreservedPathChar(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '-' || c == '.' || c == '_' || c == '~' || c == '/';
    }
}

