/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.repository.zipwriter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentItem;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.LibRepositoryBoot;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.libraries.repository.RepositoryUtilities;
import org.pentaho.reporting.libraries.repository.zipwriter.ZipContentLocation;
import org.pentaho.reporting.libraries.repository.zipwriter.ZipEntryOutputStream;
import org.pentaho.reporting.libraries.repository.zipwriter.ZipRepository;

public class ZipContentItem
implements ContentItem {
    private boolean newItem;
    private String name;
    private String contentId;
    private ZipRepository repository;
    private ZipContentLocation parent;
    private String comment;
    private long time;
    private Integer method;
    private int compression;

    public ZipContentItem(String name, ZipRepository repository, ZipContentLocation parent) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (repository == null) {
            throw new NullPointerException();
        }
        if (parent == null) {
            throw new NullPointerException();
        }
        this.time = System.currentTimeMillis();
        this.name = name;
        this.repository = repository;
        this.parent = parent;
        this.contentId = RepositoryUtilities.buildName(this, "/");
        this.newItem = true;
        this.method = LibRepositoryBoot.ZIP_METHOD_DEFLATED;
        this.compression = -1;
    }

    public String getMimeType() throws ContentIOException {
        return this.getRepository().getMimeRegistry().getMimeType(this);
    }

    public OutputStream getOutputStream() throws ContentIOException, IOException {
        if (!this.newItem) {
            throw new ContentIOException("This item is no longer writeable.");
        }
        this.newItem = false;
        return new ZipEntryOutputStream(this);
    }

    public InputStream getInputStream() throws ContentIOException, IOException {
        throw new ContentIOException("This item is not readable.");
    }

    public boolean isReadable() {
        return false;
    }

    public boolean isWriteable() {
        return this.newItem;
    }

    public String getName() {
        return this.name;
    }

    public Object getContentId() {
        return this.contentId;
    }

    public Object getAttribute(String domain, String key) {
        if ("org.jfree.repository".equals(domain)) {
            if ("version".equals(key)) {
                return new Date(this.time);
            }
        } else if ("org.jfree.repository.zip".equals(domain)) {
            if ("comment".equals(key)) {
                return this.comment;
            }
            if ("method".equals(key)) {
                return this.method;
            }
            if ("compression".equals(key)) {
                return new Integer(this.compression);
            }
        }
        return null;
    }

    public boolean setAttribute(String domain, String key, Object value) {
        if ("org.jfree.repository".equals(domain)) {
            if ("version".equals(key)) {
                if (value instanceof Date) {
                    Date n = (Date)value;
                    this.time = n.getTime();
                    return true;
                }
                if (value instanceof Number) {
                    Number n = (Number)value;
                    this.time = n.longValue();
                    return true;
                }
            }
        } else if ("org.jfree.repository.zip".equals(domain)) {
            Integer valueInt;
            int compression;
            if ("comment".equals(key)) {
                if (value != null) {
                    this.comment = String.valueOf(value);
                    return true;
                }
                this.comment = null;
                return true;
            }
            if ("method".equals(key)) {
                if (LibRepositoryBoot.ZIP_METHOD_STORED.equals(value)) {
                    this.method = LibRepositoryBoot.ZIP_METHOD_STORED;
                    return true;
                }
                if (LibRepositoryBoot.ZIP_METHOD_DEFLATED.equals(value)) {
                    this.method = LibRepositoryBoot.ZIP_METHOD_DEFLATED;
                    return true;
                }
            }
            if ("compression".equals(key) && value instanceof Integer && (compression = (valueInt = (Integer)value).intValue()) >= 0 && compression <= 9) {
                this.compression = compression;
                return true;
            }
        }
        return false;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public ContentLocation getParent() {
        return this.parent;
    }

    public boolean delete() {
        return false;
    }
}

