/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.ImageFileNameProvider;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class DPIUtil {
    private static final int DPI_ZOOM_100 = 96;
    private static int deviceZoom = 100;
    private static AutoScaleMethod autoScaleMethodSetting = AutoScaleMethod.AUTO;
    private static AutoScaleMethod autoScaleMethod = AutoScaleMethod.NEAREST;
    private static final String SWT_AUTOSCALE = "swt.autoScale";
    private static final String SWT_AUTOSCALE_METHOD = "swt.autoScale.method";

    public static ImageData autoScaleDown(Device device, ImageData imageData) {
        if (deviceZoom == 100 || imageData == null) {
            return imageData;
        }
        float f = 1.0f / DPIUtil.getScalingFactor();
        return DPIUtil.autoScaleImageData(device, imageData, f);
    }

    public static int[] autoScaleDown(int[] nArray) {
        if (deviceZoom == 100 || nArray == null) {
            return nArray;
        }
        float f = DPIUtil.getScalingFactor();
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = Math.round((float)nArray[i] / f);
        }
        return nArray2;
    }

    public static float[] autoScaleDown(float[] fArray) {
        if (deviceZoom == 100 || fArray == null) {
            return fArray;
        }
        float f = DPIUtil.getScalingFactor();
        float[] fArray2 = new float[fArray.length];
        for (int i = 0; i < fArray2.length; ++i) {
            fArray2[i] = fArray[i] / f;
        }
        return fArray2;
    }

    public static int autoScaleDown(int n) {
        if (deviceZoom == 100 || n == -1) {
            return n;
        }
        float f = DPIUtil.getScalingFactor();
        return Math.round((float)n / f);
    }

    public static float autoScaleDown(float f) {
        if (deviceZoom == 100 || f == -1.0f) {
            return f;
        }
        float f2 = DPIUtil.getScalingFactor();
        return f / f2;
    }

    public static Point autoScaleDown(Point point) {
        if (deviceZoom == 100 || point == null) {
            return point;
        }
        float f = DPIUtil.getScalingFactor();
        Point point2 = new Point(0, 0);
        point2.x = Math.round((float)point.x / f);
        point2.y = Math.round((float)point.y / f);
        return point2;
    }

    public static Rectangle autoScaleDown(Rectangle rectangle) {
        if (deviceZoom == 100 || rectangle == null) {
            return rectangle;
        }
        Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
        Point point = DPIUtil.autoScaleDown(new Point(rectangle.x, rectangle.y));
        Point point2 = DPIUtil.autoScaleDown(new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height));
        rectangle2.x = point.x;
        rectangle2.y = point.y;
        rectangle2.width = point2.x - point.x;
        rectangle2.height = point2.y - point.y;
        return rectangle2;
    }

    public static ImageData autoScaleImageData(Device device, ImageData imageData, int n, int n2) {
        if (deviceZoom == 100 || imageData == null || n == n2) {
            return imageData;
        }
        float f = (float)n / (float)n2;
        return DPIUtil.autoScaleImageData(device, imageData, f);
    }

    private static ImageData autoScaleImageData(Device device, final ImageData imageData, float f) {
        int n = imageData.width;
        int n2 = imageData.height;
        int n3 = Math.round((float)n * f);
        int n4 = Math.round((float)n2 * f);
        switch (autoScaleMethod) {
            case SMOOTH: {
                Image image = new Image(device, new ImageDataProvider(){

                    @Override
                    public ImageData getImageData(int n) {
                        return imageData;
                    }
                });
                final ImageData imageData2 = new ImageData(n3, n4, 24, new PaletteData(255, 65280, 0xFF0000));
                imageData2.alphaData = new byte[n3 * n4];
                Image image2 = new Image(device, new ImageDataProvider(){

                    @Override
                    public ImageData getImageData(int n) {
                        return imageData2;
                    }
                });
                GC gC = new GC(image2);
                gC.setAntialias(1);
                gC.drawImage(image, 0, 0, DPIUtil.autoScaleDown(n), DPIUtil.autoScaleDown(n2), 0, 0, Math.round(DPIUtil.autoScaleDown((float)n * f)), Math.round(DPIUtil.autoScaleDown((float)n2 * f)));
                gC.dispose();
                image.dispose();
                ImageData imageData3 = image2.getImageDataAtCurrentZoom();
                image2.dispose();
                return imageData3;
            }
        }
        return imageData.scaledTo(n3, n4);
    }

    public static Rectangle autoScaleBounds(Rectangle rectangle, int n, int n2) {
        if (deviceZoom == 100 || rectangle == null || n == n2) {
            return rectangle;
        }
        float f = (float)n / (float)n2;
        Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
        rectangle2.x = Math.round((float)rectangle.x * f);
        rectangle2.y = Math.round((float)rectangle.y * f);
        rectangle2.width = Math.round((float)rectangle.width * f);
        rectangle2.height = Math.round((float)rectangle.height * f);
        return rectangle2;
    }

    public static ImageData autoScaleUp(Device device, ImageData imageData) {
        if (deviceZoom == 100 || imageData == null) {
            return imageData;
        }
        float f = DPIUtil.getScalingFactor();
        return DPIUtil.autoScaleImageData(device, imageData, f);
    }

    public static int[] autoScaleUp(int[] nArray) {
        if (deviceZoom == 100 || nArray == null) {
            return nArray;
        }
        float f = DPIUtil.getScalingFactor();
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = Math.round((float)nArray[i] * f);
        }
        return nArray2;
    }

    public static int autoScaleUp(int n) {
        if (deviceZoom == 100 || n == -1) {
            return n;
        }
        float f = DPIUtil.getScalingFactor();
        return Math.round((float)n * f);
    }

    public static float autoScaleUp(float f) {
        if (deviceZoom == 100 || f == -1.0f) {
            return f;
        }
        float f2 = DPIUtil.getScalingFactor();
        return f * f2;
    }

    public static Point autoScaleUp(Point point) {
        if (deviceZoom == 100 || point == null) {
            return point;
        }
        float f = DPIUtil.getScalingFactor();
        Point point2 = new Point(0, 0);
        point2.x = Math.round((float)point.x * f);
        point2.y = Math.round((float)point.y * f);
        return point2;
    }

    public static Rectangle autoScaleUp(Rectangle rectangle) {
        if (deviceZoom == 100 || rectangle == null) {
            return rectangle;
        }
        Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
        Point point = DPIUtil.autoScaleUp(new Point(rectangle.x, rectangle.y));
        Point point2 = DPIUtil.autoScaleUp(new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height));
        rectangle2.x = point.x;
        rectangle2.y = point.y;
        rectangle2.width = point2.x - point.x;
        rectangle2.height = point2.y - point.y;
        return rectangle2;
    }

    private static float getScalingFactor() {
        return (float)deviceZoom / 100.0f;
    }

    public static int mapDPIToZoom(int n) {
        double d = (double)n * 100.0 / 96.0;
        int n2 = (int)Math.round(d);
        return n2;
    }

    public static ImageData validateAndGetImageDataAtZoom(ImageDataProvider imageDataProvider, int n, boolean[] blArray) {
        ImageData imageData;
        if (imageDataProvider == null) {
            SWT.error(4);
        }
        boolean bl = blArray[0] = (imageData = imageDataProvider.getImageData(n)) != null;
        if (n != 100 && !blArray[0]) {
            imageData = imageDataProvider.getImageData(100);
        }
        if (imageData == null) {
            SWT.error(5);
        }
        return imageData;
    }

    public static String validateAndGetImagePathAtZoom(ImageFileNameProvider imageFileNameProvider, int n, boolean[] blArray) {
        String string;
        if (imageFileNameProvider == null) {
            SWT.error(4);
        }
        boolean bl = blArray[0] = (string = imageFileNameProvider.getImagePath(n)) != null;
        if (n != 100 && !blArray[0]) {
            string = imageFileNameProvider.getImagePath(100);
        }
        if (string == null) {
            SWT.error(5);
        }
        return string;
    }

    public static int getDeviceZoom() {
        return deviceZoom;
    }

    public static void setDeviceZoom(int n) {
        int n2 = 0;
        String string = System.getProperty(SWT_AUTOSCALE);
        if (string != null) {
            if ("false".equalsIgnoreCase(string)) {
                n2 = 100;
            } else if ("quarter".equalsIgnoreCase(string)) {
                n2 = Math.round((float)n / 25.0f) * 25;
            } else if ("exact".equalsIgnoreCase(string)) {
                n2 = n;
            } else {
                try {
                    int n3 = Integer.parseInt(string);
                    n2 = Math.max(Math.min(n3, 1600), 25);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (n2 == 0) {
            n2 = Math.max((n + 25) / 100 * 100, 100);
        }
        deviceZoom = n2;
        System.setProperty("org.eclipse.swt.internal.deviceZoom", Integer.toString(n2));
        if (n2 != 100 && autoScaleMethodSetting == AutoScaleMethod.AUTO) {
            autoScaleMethod = n2 / 100 * 100 == n2 || !"gtk".equals(SWT.getPlatform()) ? AutoScaleMethod.NEAREST : AutoScaleMethod.SMOOTH;
        }
    }

    static {
        String string = System.getProperty(SWT_AUTOSCALE_METHOD);
        if (string != null) {
            if (AutoScaleMethod.NEAREST.name().equalsIgnoreCase(string)) {
                autoScaleMethod = autoScaleMethodSetting = AutoScaleMethod.NEAREST;
            } else if (AutoScaleMethod.SMOOTH.name().equalsIgnoreCase(string)) {
                autoScaleMethod = autoScaleMethodSetting = AutoScaleMethod.SMOOTH;
            }
        }
    }

    public static final class AutoScaleImageDataProvider
    implements ImageDataProvider {
        Device device;
        ImageData imageData;
        int currentZoom;

        public AutoScaleImageDataProvider(Device device, ImageData imageData, int n) {
            this.device = device;
            this.imageData = imageData;
            this.currentZoom = n;
        }

        @Override
        public ImageData getImageData(int n) {
            return DPIUtil.autoScaleImageData(this.device, this.imageData, n, this.currentZoom);
        }
    }

    private static enum AutoScaleMethod {
        AUTO,
        NEAREST,
        SMOOTH;

    }
}

