/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.Version;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ComponentResolutionState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ModuleConflictResolver;
import org.gradle.internal.component.model.ComponentResolveMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LatestModuleConflictResolver
implements ModuleConflictResolver {
    private final Comparator<Version> versionComparator;
    private final VersionParser versionParser = new VersionParser();

    LatestModuleConflictResolver(VersionComparator versionComparator) {
        this.versionComparator = versionComparator.asVersionComparator();
    }

    @Override
    public <T extends ComponentResolutionState> T select(Collection<? extends T> candidates) {
        Version baseVersion = null;
        LinkedHashMap<Version, ComponentResolutionState> matches = new LinkedHashMap<Version, ComponentResolutionState>();
        for (ComponentResolutionState candidate : candidates) {
            Version version = this.versionParser.transform(candidate.getVersion());
            if (baseVersion == null || this.versionComparator.compare(version.getBaseVersion(), baseVersion) > 0) {
                matches.clear();
                baseVersion = version.getBaseVersion();
                matches.put(version, candidate);
                continue;
            }
            if (!version.getBaseVersion().equals(baseVersion)) continue;
            matches.put(version, candidate);
        }
        if (matches.size() == 1) {
            return (T)((ComponentResolutionState)matches.values().iterator().next());
        }
        ArrayList sorted = new ArrayList(matches.keySet());
        Collections.sort(sorted, Collections.reverseOrder(this.versionComparator));
        for (Version version : sorted) {
            ComponentResolutionState component = (ComponentResolutionState)matches.get(version);
            if (!version.isQualified()) {
                return (T)component;
            }
            ComponentResolveMetaData metaData = component.getMetaData();
            if (metaData == null || !"release".equals(metaData.getStatus())) continue;
            return (T)component;
        }
        return (T)((ComponentResolutionState)matches.get(sorted.get(0)));
    }
}

