/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.ehi.basics.logging.EhiLogger;
import ch.interlis.ili2c.metamodel.BaseType;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Ili2cSemanticException;
import ch.interlis.ili2c.metamodel.NumericalType;
import ch.interlis.ili2c.metamodel.StructuredUnit;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.Unit;

public class CoordType
extends BaseType {
    protected int nullAxis;
    protected int piHalfAxis;
    protected NumericalType[] dimensions;

    public CoordType(NumericalType[] dimensions, int nullAxis, int piHalfAxis) {
        this.nullAxis = nullAxis;
        this.piHalfAxis = piHalfAxis;
        this.dimensions = dimensions;
        if (dimensions == null) {
            throw new IllegalArgumentException(rsrc.getString("err_nullNotAcceptable"));
        }
        int i = 0;
        while (i < dimensions.length) {
            if (dimensions[i] == null) {
                throw new IllegalArgumentException(rsrc.getString("err_nullNotAcceptable"));
            }
            Unit u = dimensions[i].getUnit();
            if (u instanceof StructuredUnit && !((StructuredUnit)u).isContinuous()) {
                throw new IllegalArgumentException(CoordType.formatMessage("err_coordType_structuredUnitNotContinuous", u.toString()));
            }
            ++i;
        }
        if (nullAxis < 0 || nullAxis > dimensions.length) {
            throw new IllegalArgumentException(CoordType.formatMessage("err_rotationDefInvalid", Integer.toString(nullAxis), Integer.toString(dimensions.length)));
        }
        if (piHalfAxis < 0 || piHalfAxis > dimensions.length) {
            throw new IllegalArgumentException(CoordType.formatMessage("err_rotationDefInvalid", Integer.toString(piHalfAxis), Integer.toString(dimensions.length)));
        }
        if (nullAxis == piHalfAxis && nullAxis != 0) {
            throw new IllegalArgumentException(rsrc.getString("err_rotationDefSame"));
        }
    }

    public CoordType(NumericalType[] dimensions) {
        this(dimensions, 0, 0);
    }

    public NumericalType[] getDimensions() {
        return this.dimensions;
    }

    public int getNullAxis() {
        return this.nullAxis;
    }

    public int getPiHalfAxis() {
        return this.piHalfAxis;
    }

    public boolean isAbstract() {
        int i = 0;
        while (i < this.dimensions.length) {
            if (this.dimensions[i].isAbstract()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void checkTypeExtension(Type wantToExtend) {
        if (wantToExtend == null || (wantToExtend = wantToExtend.resolveAliases()) == null) {
            return;
        }
        if (!(wantToExtend instanceof CoordType)) {
            throw new Ili2cSemanticException(rsrc.getString("err_coordType_ExtOther"));
        }
    }

    public boolean checkStructuralEquivalence(Element with) {
        if (!super.checkStructuralEquivalence(with)) {
            return false;
        }
        boolean fine = true;
        CoordType other = (CoordType)with;
        if (this.getNullAxis() != other.getNullAxis()) {
            EhiLogger.logError(CoordType.formatMessage("err_diff_coordType_nullAxis", this.toString(), other.toString()));
            fine = false;
        }
        if (this.getPiHalfAxis() != other.getPiHalfAxis()) {
            EhiLogger.logError(CoordType.formatMessage("err_diff_coordType_piHalfAxis", this.toString(), other.toString()));
            fine = false;
        }
        NumericalType[] myDims = this.getDimensions();
        NumericalType[] otherDims = other.getDimensions();
        return fine &= this.checkStructuralEquivalenceOfArrays(with, this.getDimensions(), other.getDimensions(), "err_diff_coordType_numDimensions");
    }
}

