/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.identity;

import org.apache.xerces.impl.xpath.XPath;
import org.apache.xerces.impl.xpath.XPathException;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.identity.Field;
import org.apache.xerces.impl.xs.identity.FieldActivator;
import org.apache.xerces.impl.xs.identity.IdentityConstraint;
import org.apache.xerces.impl.xs.identity.XPathMatcher;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XNIException;

public class Selector {
    protected XPath fXPath;
    protected IdentityConstraint fIdentityConstraint;

    public Selector(XPath xPath, IdentityConstraint identityConstraint) {
        this.fXPath = xPath;
        this.fIdentityConstraint = identityConstraint;
    }

    public org.apache.xerces.impl.xpath.XPath getXPath() {
        return this.fXPath;
    }

    public IdentityConstraint getIdentityConstraint() {
        return this.fIdentityConstraint;
    }

    public XPathMatcher createMatcher(FieldActivator fieldActivator) {
        return new Matcher(this.fXPath, fieldActivator);
    }

    public String toString() {
        return this.fXPath.toString();
    }

    protected class Matcher
    extends XPathMatcher {
        protected FieldActivator fFieldActivator;
        protected int fElementDepth;
        protected int fMatchedDepth;

        public Matcher(XPath xPath, FieldActivator fieldActivator) {
            super(xPath, false, Selector.this.fIdentityConstraint);
            this.fFieldActivator = fieldActivator;
        }

        public void startDocumentFragment(SymbolTable symbolTable) throws XNIException {
            super.startDocumentFragment(symbolTable);
            this.fElementDepth = 0;
            this.fMatchedDepth = -1;
        }

        public void startElement(QName qName, XMLAttributes xMLAttributes, XSElementDecl xSElementDecl) throws XNIException {
            super.startElement(qName, xMLAttributes, xSElementDecl);
            ++this.fElementDepth;
            if (this.fMatchedDepth == -1 && this.isMatched()) {
                this.fMatchedDepth = this.fElementDepth;
                this.fFieldActivator.startValueScopeFor(Selector.this.fIdentityConstraint);
                int n = Selector.this.fIdentityConstraint.getFieldCount();
                int n2 = 0;
                while (n2 < n) {
                    Field field = Selector.this.fIdentityConstraint.getFieldAt(n2);
                    XPathMatcher xPathMatcher = this.fFieldActivator.activateField(field);
                    xPathMatcher.startElement(qName, xMLAttributes, xSElementDecl);
                    ++n2;
                }
            }
        }

        public void endElement(QName qName, XSElementDecl xSElementDecl) {
            super.endElement(qName, xSElementDecl);
            if (this.fElementDepth-- == this.fMatchedDepth) {
                this.fMatchedDepth = -1;
                this.fFieldActivator.endValueScopeFor(Selector.this.fIdentityConstraint);
            }
        }
    }

    public static class XPath
    extends org.apache.xerces.impl.xpath.XPath {
        public XPath(String string, SymbolTable symbolTable, NamespaceContext namespaceContext) throws XPathException {
            super(string.trim().startsWith("/") || string.trim().startsWith(".") ? string : "./" + string, symbolTable, namespaceContext);
            int n = 0;
            while (n < this.fLocationPaths.length) {
                XPath.Axis axis = this.fLocationPaths[n].steps[this.fLocationPaths[n].steps.length - 1].axis;
                if (axis.type == 2) {
                    throw new XPathException("selectors cannot select attributes");
                }
                ++n;
            }
        }
    }
}

