/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.coor;

import java.util.Objects;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Projection;

public class CachedLatLon
extends LatLon {
    private static final long serialVersionUID = 1L;
    private EastNorth eastNorth;
    private transient Projection proj;

    public CachedLatLon(double d, double d2) {
        super(d, d2);
    }

    public CachedLatLon(LatLon latLon) {
        super(latLon.lat(), latLon.lon());
        this.proj = null;
    }

    public CachedLatLon(EastNorth eastNorth) {
        super(Main.getProjection().eastNorth2latlon(eastNorth));
        this.proj = Main.getProjection();
        this.eastNorth = eastNorth;
    }

    public final EastNorth getEastNorth() {
        if (!Objects.equals(this.proj, Main.getProjection())) {
            this.proj = Main.getProjection();
            this.eastNorth = this.proj.latlon2eastNorth(this);
        }
        return this.eastNorth;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.x, this.y, this.eastNorth);
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        CachedLatLon cachedLatLon = (CachedLatLon)object;
        return Objects.equals(this.eastNorth, cachedLatLon.eastNorth);
    }

    @Override
    public String toString() {
        return "CachedLatLon[lat=" + this.lat() + ",lon=" + this.lon() + ']';
    }
}

