/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.datatransfer;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.TransferHandler;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.datatransfer.ClipboardUtils;
import org.openstreetmap.josm.gui.datatransfer.importers.AbstractOsmDataPaster;
import org.openstreetmap.josm.gui.datatransfer.importers.FilePaster;
import org.openstreetmap.josm.gui.datatransfer.importers.PrimitiveDataPaster;
import org.openstreetmap.josm.gui.datatransfer.importers.PrimitiveTagTransferPaster;
import org.openstreetmap.josm.gui.datatransfer.importers.TagTransferPaster;
import org.openstreetmap.josm.gui.datatransfer.importers.TextTagPaster;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;

public class OsmTransferHandler
extends TransferHandler {
    private static final Collection<AbstractOsmDataPaster> SUPPORTED = Arrays.asList(new FilePaster(), new PrimitiveDataPaster(), new PrimitiveTagTransferPaster(), new TagTransferPaster(), new TextTagPaster());

    @Override
    public boolean canImport(TransferHandler.TransferSupport transferSupport) {
        for (AbstractOsmDataPaster abstractOsmDataPaster : SUPPORTED) {
            if (!abstractOsmDataPaster.supports(transferSupport)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport transferSupport) {
        return this.importData(transferSupport, Main.getLayerManager().getEditLayer(), null);
    }

    private boolean importData(TransferHandler.TransferSupport transferSupport, OsmDataLayer osmDataLayer, EastNorth eastNorth) {
        for (AbstractOsmDataPaster abstractOsmDataPaster : SUPPORTED) {
            if (!abstractOsmDataPaster.supports(transferSupport)) continue;
            try {
                if (!abstractOsmDataPaster.importData(transferSupport, osmDataLayer, eastNorth)) continue;
                return true;
            }
            catch (UnsupportedFlavorException | IOException exception) {
                Main.warn(exception);
            }
        }
        return super.importData(transferSupport);
    }

    private boolean importTags(TransferHandler.TransferSupport transferSupport, Collection<? extends OsmPrimitive> collection) {
        for (AbstractOsmDataPaster abstractOsmDataPaster : SUPPORTED) {
            if (!abstractOsmDataPaster.supports(transferSupport)) continue;
            try {
                if (!abstractOsmDataPaster.importTagsOn(transferSupport, collection)) continue;
                return true;
            }
            catch (UnsupportedFlavorException | IOException exception) {
                Main.warn(exception);
            }
        }
        return super.importData(transferSupport);
    }

    public void pasteOn(OsmDataLayer osmDataLayer, EastNorth eastNorth) {
        Transferable transferable = ClipboardUtils.getClipboard().getContents(null);
        this.pasteOn(osmDataLayer, eastNorth, transferable);
    }

    public void pasteOn(OsmDataLayer osmDataLayer, EastNorth eastNorth, Transferable transferable) {
        this.importData(new TransferHandler.TransferSupport((Component)Main.panel, transferable), osmDataLayer, eastNorth);
    }

    public void pasteTags(Collection<? extends OsmPrimitive> collection) {
        Transferable transferable = ClipboardUtils.getClipboard().getContents(null);
        this.importTags(new TransferHandler.TransferSupport((Component)Main.panel, transferable), collection);
    }

    public boolean isDataAvailable() {
        try {
            List<DataFlavor> list = Arrays.asList(ClipboardUtils.getClipboard().getAvailableDataFlavors());
            for (AbstractOsmDataPaster abstractOsmDataPaster : SUPPORTED) {
                if (!abstractOsmDataPaster.supports(list)) continue;
                return true;
            }
        }
        catch (IllegalStateException illegalStateException) {
            Main.debug(illegalStateException);
        }
        return false;
    }
}

