/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.protobuf;

import java.util.NoSuchElementException;
import org.jetbrains.kotlin.protobuf.ByteString;
import org.jetbrains.kotlin.protobuf.LiteralByteString;

class BoundedByteString
extends LiteralByteString {
    private final int bytesOffset;
    private final int bytesLength;

    BoundedByteString(byte[] bytes, int offset2, int length) {
        super(bytes);
        if (offset2 < 0) {
            throw new IllegalArgumentException("Offset too small: " + offset2);
        }
        if (length < 0) {
            throw new IllegalArgumentException("Length too small: " + offset2);
        }
        if ((long)offset2 + (long)length > (long)bytes.length) {
            throw new IllegalArgumentException("Offset+Length too large: " + offset2 + "+" + length);
        }
        this.bytesOffset = offset2;
        this.bytesLength = length;
    }

    @Override
    public byte byteAt(int index2) {
        if (index2 < 0) {
            throw new ArrayIndexOutOfBoundsException("Index too small: " + index2);
        }
        if (index2 >= this.size()) {
            throw new ArrayIndexOutOfBoundsException("Index too large: " + index2 + ", " + this.size());
        }
        return this.bytes[this.bytesOffset + index2];
    }

    @Override
    public int size() {
        return this.bytesLength;
    }

    @Override
    protected int getOffsetIntoBytes() {
        return this.bytesOffset;
    }

    @Override
    protected void copyToInternal(byte[] target, int sourceOffset, int targetOffset, int numberToCopy) {
        System.arraycopy(this.bytes, this.getOffsetIntoBytes() + sourceOffset, target, targetOffset, numberToCopy);
    }

    @Override
    public ByteString.ByteIterator iterator() {
        return new BoundedByteIterator();
    }

    private class BoundedByteIterator
    implements ByteString.ByteIterator {
        private int position;
        private final int limit;

        private BoundedByteIterator() {
            this.position = BoundedByteString.this.getOffsetIntoBytes();
            this.limit = this.position + BoundedByteString.this.size();
        }

        @Override
        public boolean hasNext() {
            return this.position < this.limit;
        }

        @Override
        public Byte next() {
            return this.nextByte();
        }

        @Override
        public byte nextByte() {
            if (this.position >= this.limit) {
                throw new NoSuchElementException();
            }
            return BoundedByteString.this.bytes[this.position++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

