/*
 * Decompiled with CFR 0.152.
 */
package gnu.mail.providers.imap;

public final class Rights {
    int rights;

    public Rights() {
    }

    public Rights(Rights rights) {
        this.rights = rights.rights;
    }

    public Rights(String rights) {
        if (rights != null) {
            int len = rights.length();
            for (int i = 0; i < len; ++i) {
                this.rights |= Right.getInstance((char)rights.charAt((int)i)).code;
            }
        }
    }

    public Rights(Right right) {
        this.rights = right.code;
    }

    public void add(Right right) {
        this.rights |= right.code;
    }

    public void add(Rights rights) {
        this.rights |= rights.rights;
    }

    public void remove(Right right) {
        this.rights -= right.code;
    }

    public void remove(Rights rights) {
        this.rights -= rights.rights;
    }

    public boolean contains(Right right) {
        return (this.rights & right.code) > 0;
    }

    public boolean contains(Rights rights) {
        return (this.rights & rights.rights) > 0;
    }

    public boolean equals(Object obj) {
        return obj instanceof Rights && ((Rights)obj).rights == this.rights;
    }

    public int hashCode() {
        return this.rights;
    }

    public static final class Right {
        public static final Right LOOKUP = new Right(1);
        public static final Right READ = new Right(2);
        public static final Right KEEP_SEEN = new Right(4);
        public static final Right WRITE = new Right(8);
        public static final Right INSERT = new Right(16);
        public static final Right POST = new Right(32);
        public static final Right CREATE = new Right(64);
        public static final Right DELETE = new Right(128);
        public static final Right ADMINISTER = new Right(256);
        final int code;

        Right(int code) {
            this.code = code;
        }

        public static Right getInstance(char right) {
            switch (right) {
                case 'l': {
                    return LOOKUP;
                }
                case 'r': {
                    return READ;
                }
                case 's': {
                    return KEEP_SEEN;
                }
                case 'w': {
                    return WRITE;
                }
                case 'i': {
                    return INSERT;
                }
                case 'p': {
                    return POST;
                }
                case 'c': {
                    return CREATE;
                }
                case 'd': {
                    return DELETE;
                }
                case 'a': {
                    return ADMINISTER;
                }
            }
            throw new IllegalArgumentException();
        }

        public String toString() {
            switch (this.code) {
                case 1: {
                    return "l";
                }
                case 2: {
                    return "r";
                }
                case 4: {
                    return "s";
                }
                case 8: {
                    return "w";
                }
                case 16: {
                    return "i";
                }
                case 32: {
                    return "p";
                }
                case 64: {
                    return "c";
                }
                case 128: {
                    return "d";
                }
                case 256: {
                    return "a";
                }
            }
            throw new IllegalStateException();
        }
    }
}

