/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http;

import org.apache.tomcat.util.http.ServerCookie;

public class ServerCookies {
    private ServerCookie[] serverCookies;
    private int cookieCount = 0;

    public ServerCookies(int initialSize) {
        this.serverCookies = new ServerCookie[initialSize];
    }

    public ServerCookie addCookie() {
        ServerCookie c;
        if (this.cookieCount >= this.serverCookies.length) {
            ServerCookie[] scookiesTmp = new ServerCookie[2 * this.cookieCount];
            System.arraycopy(this.serverCookies, 0, scookiesTmp, 0, this.cookieCount);
            this.serverCookies = scookiesTmp;
        }
        if ((c = this.serverCookies[this.cookieCount]) == null) {
            this.serverCookies[this.cookieCount] = c = new ServerCookie();
        }
        ++this.cookieCount;
        return c;
    }

    public ServerCookie getCookie(int idx) {
        return this.serverCookies[idx];
    }

    public int getCookieCount() {
        return this.cookieCount;
    }

    public void recycle() {
        for (int i = 0; i < this.cookieCount; ++i) {
            this.serverCookies[i].recycle();
        }
        this.cookieCount = 0;
    }
}

