/*
 * Copyright (c) 2010-2012 Samsung Electronics Co., Ltd.
 *		http://www.samsung.com
 *
 * EXYNOS - Power management unit definition
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
*/

#ifndef __ASM_ARCH_REGS_PMU_EXYNOS5422_H
#define __ASM_ARCH_REGS_PMU_EXYNOS5422_H __FILE__

#include <mach/map.h>

#define EXYNOS_PMUREG(x)					(S5P_VA_PMU + (x))

#define EXYNOS5422_OM_STAT					EXYNOS_PMUREG(0x0000)

#define EXYNOS5422_LPI_MASK0					EXYNOS_PMUREG(0x0004)
#define EXYNOS5422_ATB_ISP_ARM					BIT(19)
#define EXYNOS5422_DIS						BIT(15)
#define EXYNOS5422_LPI_MASK1					EXYNOS_PMUREG(0x0008)
#define EXYNOS5422_ATB_KFC					BIT(13)
#define EXYNOS5422_LPI_MASK2					EXYNOS_PMUREG(0x000C)

#define EXYNOS5422_RTC_CLKO_SEL					EXYNOS_PMUREG(0x001C)

#define EXYNOS5422_CENTRAL_SEQ_CONFIGURATION			EXYNOS_PMUREG(0x0200)
#define EXYNOS5422_CENTRAL_SEQ_STATUS				EXYNOS_PMUREG(0x0204)
#define EXYNOS5422_CENTRAL_SEQ_OPTION				EXYNOS_PMUREG(0x0208)
#define EXYNOS5422_ARM_USE_STANDBY_WFI				(0xF << 4)
#define EXYNOS5422_KFC_USE_STANDBY_WFI				(0xF << 8)
#define EXYNOS5422_USE_STANDBY_WFI_ALL \
		(EXYNOS5422_ARM_USE_STANDBY_WFI | EXYNOS5422_KFC_USE_STANDBY_WFI)

#define EXYNOS5422_CENTRAL_SEQ_COREBLK_CONFIGURATION		EXYNOS_PMUREG(0x0240)
#define EXYNOS5422_CENTRAL_SEQ_COREBLK_STATUS			EXYNOS_PMUREG(0x0244)
#define EXYNOS5422_CENTRAL_SEQ_COREBLK_OPTION			EXYNOS_PMUREG(0x0248)

#define EXYNOS5422_SWRESET					EXYNOS_PMUREG(0x0400)
#define EXYNOS5422_RST_STAT					EXYNOS_PMUREG(0x0404)
#define EXYNOS5422_AUTOMATIC_WDT_RESET_DISABLE			EXYNOS_PMUREG(0x0408)
#define EXYNOS5422_MASK_WDT_RESET_REQUEST			EXYNOS_PMUREG(0x040C)
#define	EXYNOS5422_SYS_WDTRESET					BIT(0)
#define EXYNOS5422_MASK_WRESET_REQUEST				EXYNOS_PMUREG(0x0410)
#define EXYNOS5422_RESET_SEQUENCER_CONFIGURATION		EXYNOS_PMUREG(0x0500)
#define EXYNOS5422_RESET_SEQUENCER_STATUS			EXYNOS_PMUREG(0x0504)
#define EXYNOS5422_RESET_SEQUENCER_OPTION			EXYNOS_PMUREG(0x0508)
#define EXYNOS5422_WAKEUP_STAT					EXYNOS_PMUREG(0x0600)
#define EXYNOS5422_EINT_WAKEUP_MASK				EXYNOS_PMUREG(0x0604)
#define EXYNOS5422_WAKEUP_MASK					EXYNOS_PMUREG(0x0608)
#define EXYNOS5422_WAKEUP_INTERRUPT				EXYNOS_PMUREG(0x060C)
#define EXYNOS5422_WAKEUP_STAT_COREBLK				EXYNOS_PMUREG(0x0620)
#define EXYNOS5422_EINT_WAKEUP_MASK_COREBLK			EXYNOS_PMUREG(0x0624)
#define EXYNOS5422_WAKEUP_MASK_COREBLK				EXYNOS_PMUREG(0x0628)
#define EXYNOS5422_WAKEUP_INTERRUPT_COREBLK			EXYNOS_PMUREG(0x062C)

#define EXYNOS5422_HDMI_PHY_CONTROL				EXYNOS_PMUREG(0x0700)
#define EXYNOS5422_USBDEV_PHY_CONTROL				EXYNOS_PMUREG(0x0704)
#define EXYNOS5422_USBDEV1_PHY_CONTROL				EXYNOS_PMUREG(0x0708)
#define EXYNOS5422_USBHOST_PHY_CONTROL				EXYNOS_PMUREG(0x070C)
#define EXYNOS5422_MIPI_PHY0_CONTROL				EXYNOS_PMUREG(0x0714)
#define EXYNOS5422_MIPI_PHY1_CONTROL				EXYNOS_PMUREG(0x0718)
#define EXYNOS5422_MIPI_PHY2_CONTROL				EXYNOS_PMUREG(0x071C)
#define EXYNOS5422_ADC_PHY_CONTROL				EXYNOS_PMUREG(0x0720)
#define EXYNOS5422_MTCADC_PHY_CONTROL				EXYNOS_PMUREG(0x0724)
#define EXYNOS5422_DPTX_PHY_CONTROL				EXYNOS_PMUREG(0x0728)
#define EXYNOS5422_INFORM0					EXYNOS_PMUREG(0x0800)
#define EXYNOS5422_INFORM1					EXYNOS_PMUREG(0x0804)
#define EXYNOS5422_INFORM2					EXYNOS_PMUREG(0x0808)
#define EXYNOS5422_INFORM3					EXYNOS_PMUREG(0x080C)
#define EXYNOS5422_SYSIP_DAT0					EXYNOS_PMUREG(0x0810)
#define EXYNOS5422_SYSIP_DAT1					EXYNOS_PMUREG(0x0814)
#define EXYNOS5422_SYSIP_DAT2					EXYNOS_PMUREG(0x0818)
#define EXYNOS5422_SYSIP_DAT3					EXYNOS_PMUREG(0x081C)
#define EXYNOS5422_PMU_SPARE0					EXYNOS_PMUREG(0x0900)
#define EXYNOS5422_PMU_SPARE1					EXYNOS_PMUREG(0x0904)
#define EXYNOS5422_PMU_SPARE2					EXYNOS_PMUREG(0x0908)
#define EXYNOS5422_PMU_SPARE3					EXYNOS_PMUREG(0x090C)
#define EXYNOS5422_SWRESET_KFC_SEL				(0x3 << 0)
#define EXYNOS5422_CG_STATUS0					EXYNOS_PMUREG(0x0914)
#define EXYNOS5422_CG_STATUS1					EXYNOS_PMUREG(0x0918)
#define EXYNOS5422_CG_STATUS2					EXYNOS_PMUREG(0x091C)
#define EXYNOS5422_CG_STATUS3					EXYNOS_PMUREG(0x0920)
#define EXYNOS5422_CG_STATUS4					EXYNOS_PMUREG(0x0924)
#define EXYNOS5422_IROM_DATA_REG0				EXYNOS_PMUREG(0x0980)
#define EXYNOS5422_IROM_DATA_REG1				EXYNOS_PMUREG(0x0984)
#define EXYNOS5422_IROM_DATA_REG2				EXYNOS_PMUREG(0x0988)
#define EXYNOS5422_IROM_DATA_REG3				EXYNOS_PMUREG(0x098C)
#define EXYNOS5422_PMU_DEBUG					EXYNOS_PMUREG(0x0A00)

#define EXYNOS5422_PS_HOLD_CONTROL				EXYNOS_PMUREG(0x330C)
#define EXYNOS5422_VERSION_INFO					EXYNOS_PMUREG(0x4D00)
#define EXYNOS5422_I2S_BYPASS					EXYNOS_PMUREG(0x4D04)
#define EXYNOS5422_KFC_SWRESET_MASK_FROM_EAGLE			EXYNOS_PMUREG(0x4D08)

/* SYS_PWR_CFG */
#define EXYNOS5422_ARM_CORE0_SYS_PWR_REG			EXYNOS_PMUREG(0x1000)
#define EXYNOS5422_DIS_IRQ_ARM_CORE0_LOCAL_SYS_PWR_REG		EXYNOS_PMUREG(0x1004)
#define EXYNOS5422_DIS_IRQ_ARM_CORE0_CENTRAL_SYS_PWR_REG	EXYNOS_PMUREG(0x1008)
#define EXYNOS5422_ARM_CORE1_SYS_PWR_REG			EXYNOS_PMUREG(0x1010)
#define EXYNOS5422_DIS_IRQ_ARM_CORE1_LOCAL_SYS_PWR_REG		EXYNOS_PMUREG(0x1014)
#define EXYNOS5422_DIS_IRQ_ARM_CORE1_CENTRAL_SYS_PWR_REG	EXYNOS_PMUREG(0x1018)
#define EXYNOS5422_ARM_CORE2_SYS_PWR_REG			EXYNOS_PMUREG(0x1020)
#define EXYNOS5422_DIS_IRQ_ARM_CORE2_LOCAL_SYS_PWR_REG		EXYNOS_PMUREG(0x1024)
#define EXYNOS5422_DIS_IRQ_ARM_CORE2_CENTRAL_SYS_PWR_REG	EXYNOS_PMUREG(0x1028)
#define EXYNOS5422_ARM_CORE3_SYS_PWR_REG			EXYNOS_PMUREG(0x1030)
#define EXYNOS5422_DIS_IRQ_ARM_CORE3_LOCAL_SYS_PWR_REG		EXYNOS_PMUREG(0x1034)
#define EXYNOS5422_DIS_IRQ_ARM_CORE3_CENTRAL_SYS_PWR_REG	EXYNOS_PMUREG(0x1038)
#define EXYNOS5422_KFC_CORE0_SYS_PWR_REG			EXYNOS_PMUREG(0x1040)
#define EXYNOS5422_DIS_IRQ_KFC_CORE0_LOCAL_SYS_PWR_REG		EXYNOS_PMUREG(0x1044)
#define EXYNOS5422_DIS_IRQ_KFC_CORE0_CENTRAL_SYS_PWR_REG	EXYNOS_PMUREG(0x1048)
#define EXYNOS5422_KFC_CORE1_SYS_PWR_REG			EXYNOS_PMUREG(0x1050)
#define EXYNOS5422_DIS_IRQ_KFC_CORE1_LOCAL_SYS_PWR_REG		EXYNOS_PMUREG(0x1054)
#define EXYNOS5422_DIS_IRQ_KFC_CORE1_CENTRAL_SYS_PWR_REG	EXYNOS_PMUREG(0x1058)
#define EXYNOS5422_KFC_CORE2_SYS_PWR_REG			EXYNOS_PMUREG(0x1060)
#define EXYNOS5422_DIS_IRQ_KFC_CORE2_LOCAL_SYS_PWR_REG		EXYNOS_PMUREG(0x1064)
#define EXYNOS5422_DIS_IRQ_KFC_CORE2_CENTRAL_SYS_PWR_REG	EXYNOS_PMUREG(0x1068)
#define EXYNOS5422_KFC_CORE3_SYS_PWR_REG			EXYNOS_PMUREG(0x1070)
#define EXYNOS5422_DIS_IRQ_KFC_CORE3_LOCAL_SYS_PWR_REG		EXYNOS_PMUREG(0x1074)
#define EXYNOS5422_DIS_IRQ_KFC_CORE3_CENTRAL_SYS_PWR_REG	EXYNOS_PMUREG(0x1078)
#define EXYNOS5422_ISP_ARM_SYS_PWR_REG				EXYNOS_PMUREG(0x1090)
#define EXYNOS5422_DIS_IRQ_ISP_ARM_LOCAL_SYS_PWR_REG		EXYNOS_PMUREG(0x1094)
#define EXYNOS5422_DIS_IRQ_ISP_ARM_CENTRAL_SYS_PWR_REG		EXYNOS_PMUREG(0x1098)
#define EXYNOS5422_ARM_COMMON_SYS_PWR_REG			EXYNOS_PMUREG(0x10A0)
#define EXYNOS5422_KFC_COMMON_SYS_PWR_REG			EXYNOS_PMUREG(0x10B0)
#define EXYNOS5422_ARM_L2_SYS_PWR_REG				EXYNOS_PMUREG(0x10C0)
#define EXYNOS5422_KFC_L2_SYS_PWR_REG				EXYNOS_PMUREG(0x10D0)
#define EXYNOS5422_CMU_CPU_ACLKSTOP_SYS_PWR_REG			EXYNOS_PMUREG(0x10E0)
#define EXYNOS5422_CMU_CPU_SCLKSTOP_SYS_PWR_REG			EXYNOS_PMUREG(0x10E4)
#define EXYNOS5422_CMU_KFC_ACLKSTOP_SYS_PWR_REG			EXYNOS_PMUREG(0x10F0)
#define EXYNOS5422_CMU_ACLKSTOP_SYS_PWR_REG			EXYNOS_PMUREG(0x1100)
#define EXYNOS5422_CMU_SCLKSTOP_SYS_PWR_REG			EXYNOS_PMUREG(0x1104)
#define EXYNOS5422_CMU_RESET_SYS_PWR_REG			EXYNOS_PMUREG(0x110C)
#define EXYNOS5422_CMU_ACLKSTOP_COREBLK_SYS_PWR_REG		EXYNOS_PMUREG(0x1120)
#define EXYNOS5422_CMU_SCLKSTOP_COREBLK_SYS_PWR_REG		EXYNOS_PMUREG(0x1124)
#define EXYNOS5422_CMU_RESET_COREBLK_SYS_PWR_REG		EXYNOS_PMUREG(0x112C)
#define EXYNOS5422_DRAM_FREQ_DOWN_SYS_PWR_REG			EXYNOS_PMUREG(0x1130)
#define EXYNOS5422_DDRPHY_DLLOFF_SYS_PWR_REG			EXYNOS_PMUREG(0x1134)
#define EXYNOS5422_DDRPHY_DLLLOCK_SYS_PWR_REG			EXYNOS_PMUREG(0x1138)
#define EXYNOS5422_APLL_SYSCLK_SYS_PWR_REG			EXYNOS_PMUREG(0x1140)
#define EXYNOS5422_MPLL_SYSCLK_SYS_PWR_REG			EXYNOS_PMUREG(0x1144)
#define EXYNOS5422_VPLL_SYSCLK_SYS_PWR_REG			EXYNOS_PMUREG(0x1148)
#define EXYNOS5422_EPLL_SYSCLK_SYS_PWR_REG			EXYNOS_PMUREG(0x114C)
#define EXYNOS5422_BPLL_SYSCLK_SYS_PWR_REG			EXYNOS_PMUREG(0x1150)
#define EXYNOS5422_CPLL_SYSCLK_SYS_PWR_REG			EXYNOS_PMUREG(0x1154)
#define EXYNOS5422_DPLL_SYSCLK_SYS_PWR_REG			EXYNOS_PMUREG(0x1158)
#define EXYNOS5422_IPLL_SYSCLK_SYS_PWR_REG			EXYNOS_PMUREG(0x115C)
#define EXYNOS5422_KPLL_SYSCLK_SYS_PWR_REG			EXYNOS_PMUREG(0x1160)
#define EXYNOS5422_MPLLUSER_SYSCLK_SYS_PWR_REG			EXYNOS_PMUREG(0x1164)
#define EXYNOS5422_BPLLUSER_SYSCLK_SYS_PWR_REG			EXYNOS_PMUREG(0x1170)
#define EXYNOS5422_RPLL_SYSCLK_SYS_PWR_REG			EXYNOS_PMUREG(0x1174)
#define EXYNOS5422_SPLL_SYSCLK_SYS_PWR_REG			EXYNOS_PMUREG(0x1178)
#define EXYNOS5422_TOP_BUS_SYS_PWR_REG				EXYNOS_PMUREG(0x1180)
#define EXYNOS5422_TOP_RETENTION_SYS_PWR_REG			EXYNOS_PMUREG(0x1184)
#define EXYNOS5422_TOP_PWR_SYS_PWR_REG				EXYNOS_PMUREG(0x1188)
#define EXYNOS5422_TOP_BUS_COREBLK_SYS_PWR_REG			EXYNOS_PMUREG(0x1190)
#define EXYNOS5422_TOP_RETENTION_COREBLK_SYS_PWR_REG		EXYNOS_PMUREG(0x1194)
#define EXYNOS5422_TOP_PWR_COREBLK_SYS_PWR_REG			EXYNOS_PMUREG(0x1198)
#define EXYNOS5422_LOGIC_RESET_SYS_PWR_REG			EXYNOS_PMUREG(0x11A0)
#define EXYNOS5422_OSCCLK_GATE_SYS_PWR_REG			EXYNOS_PMUREG(0x11A4)
#define EXYNOS5422_LOGIC_RESET_COREBLK_SYS_PWR_REG		EXYNOS_PMUREG(0x11B0)
#define EXYNOS5422_OSCCLK_GATE_COREBLK_SYS_PWR_REG		EXYNOS_PMUREG(0x11B4)
#define EXYNOS5422_INTRAM_MEM_SYS_PWR_REG			EXYNOS_PMUREG(0x11B8)
#define EXYNOS5422_INTROM_MEM_SYS_PWR_REG			EXYNOS_PMUREG(0x11BC)
#define EXYNOS5422_PAD_RETENTION_DRAM_SYS_PWR_REG		EXYNOS_PMUREG(0x1200)
#define EXYNOS5422_PAD_RETENTION_MAU_SYS_PWR_REG		EXYNOS_PMUREG(0x1204)
#define EXYNOS5422_PAD_RETENTION_JTAG_SYS_PWR_REG		EXYNOS_PMUREG(0x1208)
#define EXYNOS5422_PAD_RETENTION_GPIO_SYS_PWR_REG		EXYNOS_PMUREG(0x1210)
#define EXYNOS5422_PAD_RETENTION_UART_SYS_PWR_REG		EXYNOS_PMUREG(0x1214)
#define EXYNOS5422_PAD_RETENTION_MMCA_SYS_PWR_REG		EXYNOS_PMUREG(0x1218)
#define EXYNOS5422_PAD_RETENTION_MMCB_SYS_PWR_REG		EXYNOS_PMUREG(0x121C)
#define EXYNOS5422_PAD_RETENTION_MMCC_SYS_PWR_REG		EXYNOS_PMUREG(0x1220)
#define EXYNOS5422_PAD_RETENTION_HSI_SYS_PWR_REG		EXYNOS_PMUREG(0x1224)
#define EXYNOS5422_PAD_RETENTION_EBIA_SYS_PWR_REG		EXYNOS_PMUREG(0x1228)
#define EXYNOS5422_PAD_RETENTION_EBIB_SYS_PWR_REG		EXYNOS_PMUREG(0x122C)
#define EXYNOS5422_PAD_RETENTION_SPI_SYS_PWR_REG		EXYNOS_PMUREG(0x1230)
#define EXYNOS5422_PAD_RETENTION_DRAM_COREBLK_SYS_PWR_REG	EXYNOS_PMUREG(0x1234)
#define EXYNOS5422_PAD_ISOLATION_SYS_PWR_REG			EXYNOS_PMUREG(0x1240)
#define EXYNOS5422_PAD_ISOLATION_COREBLK_SYS_PWR_REG		EXYNOS_PMUREG(0x1250)
#define EXYNOS5422_PAD_ALV_SEL_SYS_PWR_REG			EXYNOS_PMUREG(0x1260)
#define EXYNOS5422_XUSBXTI_SYS_PWR_REG				EXYNOS_PMUREG(0x1280)
#define EXYNOS5422_XXTI_SYS_PWR_REG				EXYNOS_PMUREG(0x1284)
#define EXYNOS5422_EXT_REGULATOR_SYS_PWR_REG			EXYNOS_PMUREG(0x12C0)
#define EXYNOS5422_GPIO_MODE_SYS_PWR_REG			EXYNOS_PMUREG(0x1300)
#define EXYNOS5422_GPIO_MODE_COREBLK_SYS_PWR_REG		EXYNOS_PMUREG(0x1320)
#define EXYNOS5422_GPIO_MODE_MAU_SYS_PWR_REG			EXYNOS_PMUREG(0x1340)
#define EXYNOS5422_TOP_ASB_RESET_SYS_PWR_REG			EXYNOS_PMUREG(0x1344)
#define EXYNOS5422_TOP_ASB_ISOLATION_SYS_PWR_REG		EXYNOS_PMUREG(0x1348)
#define EXYNOS5422_SCALER_SYS_PWR_REG				EXYNOS_PMUREG(0x1400)
#define EXYNOS5422_ISP_SYS_PWR_REG				EXYNOS_PMUREG(0x1404)
#define EXYNOS5422_MFC_SYS_PWR_REG				EXYNOS_PMUREG(0x1408)
#define EXYNOS5422_G3D_SYS_PWR_REG				EXYNOS_PMUREG(0x140C)
#define EXYNOS5422_DISP1_SYS_PWR_REG				EXYNOS_PMUREG(0x1410)
#define EXYNOS5422_MAU_SYS_PWR_REG				EXYNOS_PMUREG(0x1414)
#define EXYNOS5422_G2D_SYS_PWR_REG				EXYNOS_PMUREG(0x1418)
#define EXYNOS5422_MSC_SYS_PWR_REG				EXYNOS_PMUREG(0x141C)
#define EXYNOS5422_FSYS_SYS_PWR_REG				EXYNOS_PMUREG(0x1420)
#define EXYNOS5422_FSYS2_SYS_PWR_REG				EXYNOS_PMUREG(0x1424)
#define EXYNOS5422_PSGEN_SYS_PWR_REG				EXYNOS_PMUREG(0x1428)
#define EXYNOS5422_PERIC_SYS_PWR_REG				EXYNOS_PMUREG(0x142C)
#define EXYNOS5422_WCORE_SYS_PWR_REG				EXYNOS_PMUREG(0x1430)
#define EXYNOS5422_CMU_CLKSTOP_SCALER_SYS_PWR_REG		EXYNOS_PMUREG(0x1480)
#define EXYNOS5422_CMU_CLKSTOP_ISP_SYS_PWR_REG			EXYNOS_PMUREG(0x1484)
#define EXYNOS5422_CMU_CLKSTOP_MFC_SYS_PWR_REG			EXYNOS_PMUREG(0x1488)
#define EXYNOS5422_CMU_CLKSTOP_G3D_SYS_PWR_REG			EXYNOS_PMUREG(0x148C)
#define EXYNOS5422_CMU_CLKSTOP_DISP1_SYS_PWR_REG		EXYNOS_PMUREG(0x1490)
#define EXYNOS5422_CMU_CLKSTOP_MAU_SYS_PWR_REG			EXYNOS_PMUREG(0x1494)
#define EXYNOS5422_CMU_CLKSTOP_G2D_SYS_PWR_REG			EXYNOS_PMUREG(0x1498)
#define EXYNOS5422_CMU_CLKSTOP_MSC_SYS_PWR_REG			EXYNOS_PMUREG(0x149C)
#define EXYNOS5422_CMU_CLKSTOP_FSYS_SYS_PWR_REG			EXYNOS_PMUREG(0x14A0)
#define EXYNOS5422_CMU_CLKSTOP_FSYS2_SYS_PWR_REG		EXYNOS_PMUREG(0x14A4)
#define EXYNOS5422_CMU_CLKSTOP_PSGEN_SYS_PWR_REG		EXYNOS_PMUREG(0x14A8)
#define EXYNOS5422_CMU_CLKSTOP_PERIC_SYS_PWR_REG		EXYNOS_PMUREG(0x14AC)
#define EXYNOS5422_CMU_CLKSTOP_WCORE_SYS_PWR_REG		EXYNOS_PMUREG(0x14B0)
#define EXYNOS5422_CMU_SYSCLK_TOPPWR_SYS_PWR_REG		EXYNOS_PMUREG(0x14BC)
#define EXYNOS5422_CMU_SYSCLK_SCALER_SYS_PWR_REG		EXYNOS_PMUREG(0x14C0)
#define EXYNOS5422_CMU_SYSCLK_ISP_SYS_PWR_REG			EXYNOS_PMUREG(0x14C4)
#define EXYNOS5422_CMU_SYSCLK_MFC_SYS_PWR_REG			EXYNOS_PMUREG(0x14C8)
#define EXYNOS5422_CMU_SYSCLK_G3D_SYS_PWR_REG			EXYNOS_PMUREG(0x14CC)
#define EXYNOS5422_CMU_SYSCLK_DISP1_SYS_PWR_REG			EXYNOS_PMUREG(0x14D0)
#define EXYNOS5422_CMU_SYSCLK_MAU_SYS_PWR_REG			EXYNOS_PMUREG(0x14D4)
#define EXYNOS5422_CMU_SYSCLK_G2D_SYS_PWR_REG			EXYNOS_PMUREG(0x14D8)
#define EXYNOS5422_CMU_SYSCLK_MSC_SYS_PWR_REG			EXYNOS_PMUREG(0x14DC)
#define EXYNOS5422_CMU_SYSCLK_FSYS_SYS_PWR_REG			EXYNOS_PMUREG(0x14E0)
#define EXYNOS5422_CMU_SYSCLK_FSYS2_SYS_PWR_REG			EXYNOS_PMUREG(0x14E4)
#define EXYNOS5422_CMU_SYSCLK_PSGEN_SYS_PWR_REG			EXYNOS_PMUREG(0x14E8)
#define EXYNOS5422_CMU_SYSCLK_PERIC_SYS_PWR_REG			EXYNOS_PMUREG(0x14EC)
#define EXYNOS5422_CMU_SYSCLK_WCORE_SYS_PWR_REG			EXYNOS_PMUREG(0x14F0)
#define EXYNOS5422_CMU_SYSCLK_COREBLK_TOPPWR_SYS_PWR_REG	EXYNOS_PMUREG(0x14F4)
#define EXYNOS5422_CMU_RESET_FSYS2_SYS_PWR_REG			EXYNOS_PMUREG(0x1570)
#define EXYNOS5422_CMU_RESET_PSGEN_SYS_PWR_REG			EXYNOS_PMUREG(0x1574)
#define EXYNOS5422_CMU_RESET_PERIC_SYS_PWR_REG			EXYNOS_PMUREG(0x1578)
#define EXYNOS5422_CMU_RESET_WCORE_SYS_PWR_REG			EXYNOS_PMUREG(0x157C)
#define EXYNOS5422_CMU_RESET_SCALER_SYS_PWR_REG			EXYNOS_PMUREG(0x1580)
#define EXYNOS5422_CMU_RESET_ISP_SYS_PWR_REG			EXYNOS_PMUREG(0x1584)
#define EXYNOS5422_CMU_RESET_MFC_SYS_PWR_REG			EXYNOS_PMUREG(0x1588)
#define EXYNOS5422_CMU_RESET_G3D_SYS_PWR_REG			EXYNOS_PMUREG(0x158C)
#define EXYNOS5422_CMU_RESET_DISP1_SYS_PWR_REG			EXYNOS_PMUREG(0x1590)
#define EXYNOS5422_CMU_RESET_MAU_SYS_PWR_REG			EXYNOS_PMUREG(0x1594)
#define EXYNOS5422_CMU_RESET_G2D_SYS_PWR_REG			EXYNOS_PMUREG(0x1598)
#define EXYNOS5422_CMU_RESET_MSC_SYS_PWR_REG			EXYNOS_PMUREG(0x159C)
#define EXYNOS5422_CMU_RESET_FSYS_SYS_PWR_REG			EXYNOS_PMUREG(0x15A0)

/* LOCAL_PWR_CFG */
#define EXYNOS5422_ARM_CORE0_CONFIGURATION			EXYNOS_PMUREG(0x2000)
#define EXYNOS5422_ARM_CORE0_STATUS				EXYNOS_PMUREG(0x2004)
#define EXYNOS5422_ARM_CORE0_OPTION				EXYNOS_PMUREG(0x2008)
#define EXYNOS5422_DIS_IRQ_ARM_CORE0_LOCAL_CONFIGURATION	EXYNOS_PMUREG(0x2020)
#define EXYNOS5422_DIS_IRQ_ARM_CORE0_LOCAL_STATUS		EXYNOS_PMUREG(0x2024)
#define EXYNOS5422_DIS_IRQ_ARM_CORE0_LOCAL_OPTION		EXYNOS_PMUREG(0x2028)
#define EXYNOS5422_DIS_IRQ_ARM_CORE0_CENTRAL_CONFIGURATION	EXYNOS_PMUREG(0x2040)
#define EXYNOS5422_DIS_IRQ_ARM_CORE0_CENTRAL_STATUS		EXYNOS_PMUREG(0x2044)
#define EXYNOS5422_DIS_IRQ_ARM_CORE0_CENTRAL_OPTION		EXYNOS_PMUREG(0x2048)
#define EXYNOS5422_ARM_CORE1_CONFIGURATION			EXYNOS_PMUREG(0x2080)
#define EXYNOS5422_ARM_CORE1_STATUS				EXYNOS_PMUREG(0x2084)
#define EXYNOS5422_ARM_CORE1_OPTION				EXYNOS_PMUREG(0x2088)
#define EXYNOS5422_DIS_IRQ_ARM_CORE1_LOCAL_CONFIGURATION	EXYNOS_PMUREG(0x20A0)
#define EXYNOS5422_DIS_IRQ_ARM_CORE1_LOCAL_STATUS		EXYNOS_PMUREG(0x20A4)
#define EXYNOS5422_DIS_IRQ_ARM_CORE1_LOCAL_OPTION		EXYNOS_PMUREG(0x20A8)
#define EXYNOS5422_DIS_IRQ_ARM_CORE1_CENTRAL_CONFIGURATION	EXYNOS_PMUREG(0x20C0)
#define EXYNOS5422_DIS_IRQ_ARM_CORE1_CENTRAL_STATUS		EXYNOS_PMUREG(0x20C4)
#define EXYNOS5422_DIS_IRQ_ARM_CORE1_CENTRAL_OPTION		EXYNOS_PMUREG(0x20C8)
#define EXYNOS5422_ARM_CORE2_CONFIGURATION			EXYNOS_PMUREG(0x2100)
#define EXYNOS5422_ARM_CORE2_STATUS				EXYNOS_PMUREG(0x2104)
#define EXYNOS5422_ARM_CORE2_OPTION				EXYNOS_PMUREG(0x2108)
#define EXYNOS5422_DIS_IRQ_ARM_CORE2_LOCAL_CONFIGURATION	EXYNOS_PMUREG(0x2120)
#define EXYNOS5422_DIS_IRQ_ARM_CORE2_LOCAL_STATUS		EXYNOS_PMUREG(0x2124)
#define EXYNOS5422_DIS_IRQ_ARM_CORE2_LOCAL_OPTION		EXYNOS_PMUREG(0x2128)
#define EXYNOS5422_DIS_IRQ_ARM_CORE2_CENTRAL_CONFIGURATION	EXYNOS_PMUREG(0x2140)
#define EXYNOS5422_DIS_IRQ_ARM_CORE2_CENTRAL_STATUS		EXYNOS_PMUREG(0x2144)
#define EXYNOS5422_DIS_IRQ_ARM_CORE2_CENTRAL_OPTION		EXYNOS_PMUREG(0x2148)
#define EXYNOS5422_ARM_CORE3_CONFIGURATION			EXYNOS_PMUREG(0x2180)
#define EXYNOS5422_ARM_CORE3_STATUS				EXYNOS_PMUREG(0x2184)
#define EXYNOS5422_ARM_CORE3_OPTION				EXYNOS_PMUREG(0x2188)
#define EXYNOS5422_DIS_IRQ_ARM_CORE3_LOCAL_CONFIGURATION	EXYNOS_PMUREG(0x21A0)
#define EXYNOS5422_DIS_IRQ_ARM_CORE3_LOCAL_STATUS		EXYNOS_PMUREG(0x21A4)
#define EXYNOS5422_DIS_IRQ_ARM_CORE3_LOCAL_OPTION		EXYNOS_PMUREG(0x21A8)
#define EXYNOS5422_DIS_IRQ_ARM_CORE3_CENTRAL_CONFIGURATION	EXYNOS_PMUREG(0x21C0)
#define EXYNOS5422_DIS_IRQ_ARM_CORE3_CENTRAL_STATUS		EXYNOS_PMUREG(0x21C4)
#define EXYNOS5422_DIS_IRQ_ARM_CORE3_CENTRAL_OPTION		EXYNOS_PMUREG(0x21C8)
#define EXYNOS5422_KFC_CORE0_CONFIGURATION			EXYNOS_PMUREG(0x2200)
#define EXYNOS5422_KFC_CORE0_STATUS				EXYNOS_PMUREG(0x2204)
#define EXYNOS5422_KFC_CORE0_OPTION				EXYNOS_PMUREG(0x2208)
#define EXYNOS5422_DIS_IRQ_KFC_CORE0_LOCAL_CONFIGURATION	EXYNOS_PMUREG(0x2220)
#define EXYNOS5422_DIS_IRQ_KFC_CORE0_LOCAL_STATUS		EXYNOS_PMUREG(0x2224)
#define EXYNOS5422_DIS_IRQ_KFC_CORE0_LOCAL_OPTION		EXYNOS_PMUREG(0x2228)
#define EXYNOS5422_DIS_IRQ_KFC_CORE0_CENTRAL_CONFIGURATION	EXYNOS_PMUREG(0x2240)
#define EXYNOS5422_DIS_IRQ_KFC_CORE0_CENTRAL_STATUS		EXYNOS_PMUREG(0x2244)
#define EXYNOS5422_DIS_IRQ_KFC_CORE0_CENTRAL_OPTION		EXYNOS_PMUREG(0x2248)
#define EXYNOS5422_KFC_CORE1_CONFIGURATION			EXYNOS_PMUREG(0x2280)
#define EXYNOS5422_KFC_CORE1_STATUS				EXYNOS_PMUREG(0x2284)
#define EXYNOS5422_KFC_CORE1_OPTION				EXYNOS_PMUREG(0x2288)
#define EXYNOS5422_DIS_IRQ_KFC_CORE1_LOCAL_CONFIGURATION	EXYNOS_PMUREG(0x22A0)
#define EXYNOS5422_DIS_IRQ_KFC_CORE1_LOCAL_STATUS		EXYNOS_PMUREG(0x22A4)
#define EXYNOS5422_DIS_IRQ_KFC_CORE1_LOCAL_OPTION		EXYNOS_PMUREG(0x22A8)
#define EXYNOS5422_DIS_IRQ_KFC_CORE1_CENTRAL_CONFIGURATION	EXYNOS_PMUREG(0x22C0)
#define EXYNOS5422_DIS_IRQ_KFC_CORE1_CENTRAL_STATUS		EXYNOS_PMUREG(0x22C4)
#define EXYNOS5422_DIS_IRQ_KFC_CORE1_CENTRAL_OPTION		EXYNOS_PMUREG(0x22C8)
#define EXYNOS5422_KFC_CORE2_CONFIGURATION			EXYNOS_PMUREG(0x2300)
#define EXYNOS5422_KFC_CORE2_STATUS				EXYNOS_PMUREG(0x2304)
#define EXYNOS5422_KFC_CORE2_OPTION				EXYNOS_PMUREG(0x2308)
#define EXYNOS5422_DIS_IRQ_KFC_CORE2_LOCAL_CONFIGURATION	EXYNOS_PMUREG(0x2320)
#define EXYNOS5422_DIS_IRQ_KFC_CORE2_LOCAL_STATUS		EXYNOS_PMUREG(0x2324)
#define EXYNOS5422_DIS_IRQ_KFC_CORE2_LOCAL_OPTION		EXYNOS_PMUREG(0x2328)
#define EXYNOS5422_DIS_IRQ_KFC_CORE2_CENTRAL_CONFIGURATION	EXYNOS_PMUREG(0x2340)
#define EXYNOS5422_DIS_IRQ_KFC_CORE2_CENTRAL_STATUS		EXYNOS_PMUREG(0x2344)
#define EXYNOS5422_DIS_IRQ_KFC_CORE2_CENTRAL_OPTION		EXYNOS_PMUREG(0x2348)
#define EXYNOS5422_KFC_CORE3_CONFIGURATION			EXYNOS_PMUREG(0x2380)
#define EXYNOS5422_KFC_CORE3_STATUS				EXYNOS_PMUREG(0x2384)
#define EXYNOS5422_KFC_CORE3_OPTION				EXYNOS_PMUREG(0x2388)
#define EXYNOS5422_DIS_IRQ_KFC_CORE3_LOCAL_CONFIGURATION	EXYNOS_PMUREG(0x23A0)
#define EXYNOS5422_DIS_IRQ_KFC_CORE3_LOCAL_STATUS		EXYNOS_PMUREG(0x23A4)
#define EXYNOS5422_DIS_IRQ_KFC_CORE3_LOCAL_OPTION		EXYNOS_PMUREG(0x23A8)
#define EXYNOS5422_DIS_IRQ_KFC_CORE3_CENTRAL_CONFIGURATION	EXYNOS_PMUREG(0x23C0)
#define EXYNOS5422_DIS_IRQ_KFC_CORE3_CENTRAL_STATUS		EXYNOS_PMUREG(0x23C4)
#define EXYNOS5422_DIS_IRQ_KFC_CORE3_CENTRAL_OPTION		EXYNOS_PMUREG(0x23C8)
#define EXYNOS5422_ISP_ARM_CONFIGURATION			EXYNOS_PMUREG(0x2480)
#define EXYNOS5422_ISP_ARM_STATUS				EXYNOS_PMUREG(0x2484)
#define EXYNOS5422_ISP_ARM_OPTION				EXYNOS_PMUREG(0x2488)
#define EXYNOS5422_DIS_IRQ_ISP_ARM_LOCAL_CONFIGURATION		EXYNOS_PMUREG(0x24A0)
#define EXYNOS5422_DIS_IRQ_ISP_ARM_LOCAL_STATUS			EXYNOS_PMUREG(0x24A4)
#define EXYNOS5422_DIS_IRQ_ISP_ARM_LOCAL_OPTION			EXYNOS_PMUREG(0x24A8)
#define EXYNOS5422_DIS_IRQ_ISP_ARM_CENTRAL_CONFIGURATION	EXYNOS_PMUREG(0x24C0)
#define EXYNOS5422_DIS_IRQ_ISP_ARM_CENTRAL_STATUS		EXYNOS_PMUREG(0x24C4)
#define EXYNOS5422_DIS_IRQ_ISP_ARM_CENTRAL_OPTION		EXYNOS_PMUREG(0x24C8)
#define EXYNOS5422_ARM_COMMON_CONFIGURATION			EXYNOS_PMUREG(0x2500)
#define EXYNOS5422_ARM_COMMON_STATUS				EXYNOS_PMUREG(0x2504)
#define EXYNOS5422_ARM_COMMON_OPTION				EXYNOS_PMUREG(0x2508)
#define EXYNOS5422_KFC_COMMON_CONFIGURATION			EXYNOS_PMUREG(0x2580)
#define EXYNOS5422_KFC_COMMON_STATUS				EXYNOS_PMUREG(0x2584)
#define EXYNOS5422_KFC_COMMON_OPTION				EXYNOS_PMUREG(0x2588)
#define EXYNOS5422_ARM_L2_CONFIGURATION				EXYNOS_PMUREG(0x2600)
#define EXYNOS5422_ARM_L2_STATUS				EXYNOS_PMUREG(0x2604)
#define EXYNOS5422_ARM_L2_OPTION				EXYNOS_PMUREG(0x2608)
#define EXYNOS5422_KFC_L2_CONFIGURATION				EXYNOS_PMUREG(0x2680)
#define EXYNOS5422_KFC_L2_STATUS				EXYNOS_PMUREG(0x2684)
#define EXYNOS5422_KFC_L2_OPTION				EXYNOS_PMUREG(0x2688)

#define EXYNOS5422_CMU_CPU_ACLKSTOP_CONFIGURATION		EXYNOS_PMUREG(0x2700)
#define EXYNOS5422_CMU_CPU_ACLKSTOP_STATUS			EXYNOS_PMUREG(0x2704)
#define EXYNOS5422_CMU_CPU_ACLKSTOP_OPTION			EXYNOS_PMUREG(0x2708)
#define EXYNOS5422_CMU_CPU_SCLKSTOP_CONFIGURATION		EXYNOS_PMUREG(0x2720)
#define EXYNOS5422_CMU_CPU_SCLKSTOP_STATUS			EXYNOS_PMUREG(0x2724)
#define EXYNOS5422_CMU_CPU_SCLKSTOP_OPTION			EXYNOS_PMUREG(0x2728)
#define EXYNOS5422_CMU_KFC_ACLKSTOP_CONFIGURATION		EXYNOS_PMUREG(0x2730)
#define EXYNOS5422_CMU_KFC_ACLKSTOP_STATUS			EXYNOS_PMUREG(0x2734)
#define EXYNOS5422_CMU_KFC_ACLKSTOP_OPTION			EXYNOS_PMUREG(0x2738)
#define EXYNOS5422_CMU_ACLKSTOP_CONFIGURATION			EXYNOS_PMUREG(0x2800)
#define EXYNOS5422_CMU_ACLKSTOP_STATUS				EXYNOS_PMUREG(0x2804)
#define EXYNOS5422_CMU_ACLKSTOP_OPTION				EXYNOS_PMUREG(0x2808)
#define EXYNOS5422_CMU_SCLKSTOP_CONFIGURATION			EXYNOS_PMUREG(0x2820)
#define EXYNOS5422_CMU_SCLKSTOP_STATUS				EXYNOS_PMUREG(0x2824)
#define EXYNOS5422_CMU_SCLKSTOP_OPTION				EXYNOS_PMUREG(0x2828)
#define EXYNOS5422_CMU_RESET_CONFIGURATION			EXYNOS_PMUREG(0x2860)
#define EXYNOS5422_CMU_RESET_STATUS				EXYNOS_PMUREG(0x2864)
#define EXYNOS5422_CMU_RESET_OPTION				EXYNOS_PMUREG(0x2868)
#define EXYNOS5422_CMU_ACLKSTOP_COREBLK_CONFIGURATION		EXYNOS_PMUREG(0x2900)
#define EXYNOS5422_CMU_ACLKSTOP_COREBLK_STATUS			EXYNOS_PMUREG(0x2904)
#define EXYNOS5422_CMU_ACLKSTOP_COREBLK_OPTION			EXYNOS_PMUREG(0x2908)
#define EXYNOS5422_CMU_SCLKSTOP_COREBLK_CONFIGURATION		EXYNOS_PMUREG(0x2920)
#define EXYNOS5422_CMU_SCLKSTOP_COREBLK_STATUS			EXYNOS_PMUREG(0x2924)
#define EXYNOS5422_CMU_SCLKSTOP_COREBLK_OPTION			EXYNOS_PMUREG(0x2928)
#define EXYNOS5422_CMU_RESET_COREBLK_CONFIGURATION		EXYNOS_PMUREG(0x2960)
#define EXYNOS5422_CMU_RESET_COREBLK_STATUS			EXYNOS_PMUREG(0x2964)
#define EXYNOS5422_CMU_RESET_COREBLK_OPTION			EXYNOS_PMUREG(0x2968)
#define EXYNOS5422_DRAM_FREQ_DOWN_CONFIGURATION			EXYNOS_PMUREG(0x2980)
#define EXYNOS5422_DRAM_FREQ_DOWN_STATUS			EXYNOS_PMUREG(0x2984)
#define EXYNOS5422_DRAM_FREQ_DOWN_OPTION			EXYNOS_PMUREG(0x2988)
#define EXYNOS5422_DDRPHY_DLLOFF_CONFIGURATION			EXYNOS_PMUREG(0x29A0)
#define EXYNOS5422_DDRPHY_DLLOFF_STATUS				EXYNOS_PMUREG(0x29A4)
#define EXYNOS5422_DDRPHY_DLLOFF_OPTION				EXYNOS_PMUREG(0x29A8)
#define EXYNOS5422_DDRPHY_DLLLOCK_CONFIGURATION			EXYNOS_PMUREG(0x29C0)
#define EXYNOS5422_DDRPHY_DLLLOCK_STATUS			EXYNOS_PMUREG(0x29C4)
#define EXYNOS5422_DDRPHY_DLLLOCK_OPTION			EXYNOS_PMUREG(0x29C8)
#define EXYNOS5422_APLL_SYSCLK_CONFIGURATION			EXYNOS_PMUREG(0x2A00)
#define EXYNOS5422_APLL_SYSCLK_STATUS				EXYNOS_PMUREG(0x2A04)
#define EXYNOS5422_APLL_SYSCLK_OPTION				EXYNOS_PMUREG(0x2A08)
#define EXYNOS5422_MPLL_SYSCLK_STATUS				EXYNOS_PMUREG(0x2A24)
#define EXYNOS5422_MPLL_SYSCLK_OPTION				EXYNOS_PMUREG(0x2A28)
#define EXYNOS5422_VPLL_SYSCLK_CONFIGURATION			EXYNOS_PMUREG(0x2A40)
#define EXYNOS5422_VPLL_SYSCLK_STATUS				EXYNOS_PMUREG(0x2A44)
#define EXYNOS5422_VPLL_SYSCLK_OPTION				EXYNOS_PMUREG(0x2A48)
#define EXYNOS5422_EPLL_SYSCLK_CONFIGURATION			EXYNOS_PMUREG(0x2A60)
#define EXYNOS5422_EPLL_SYSCLK_STATUS				EXYNOS_PMUREG(0x2A64)
#define EXYNOS5422_EPLL_SYSCLK_OPTION				EXYNOS_PMUREG(0x2A68)
#define EXYNOS5422_BPLL_SYSCLK_CONFIGURATION			EXYNOS_PMUREG(0x2A80)
#define EXYNOS5422_BPLL_SYSCLK_STATUS				EXYNOS_PMUREG(0x2A84)
#define EXYNOS5422_BPLL_SYSCLK_OPTION				EXYNOS_PMUREG(0x2A88)
#define EXYNOS5422_CPLL_SYSCLK_CONFIGURATION			EXYNOS_PMUREG(0x2AA0)
#define EXYNOS5422_CPLL_SYSCLK_STATUS				EXYNOS_PMUREG(0x2AA4)
#define EXYNOS5422_CPLL_SYSCLK_OPTION				EXYNOS_PMUREG(0x2AA8)
#define EXYNOS5422_DPLL_SYSCLK_CONFIGURATION			EXYNOS_PMUREG(0x2AC0)
#define EXYNOS5422_DPLL_SYSCLK_STATUS				EXYNOS_PMUREG(0x2AC4)
#define EXYNOS5422_DPLL_SYSCLK_OPTION				EXYNOS_PMUREG(0x2AC8)
#define EXYNOS5422_IPLL_SYSCLK_CONFIGURATION			EXYNOS_PMUREG(0x2AE0)
#define EXYNOS5422_IPLL_SYSCLK_STATUS				EXYNOS_PMUREG(0x2AE4)
#define EXYNOS5422_IPLL_SYSCLK_OPTION				EXYNOS_PMUREG(0x2AE8)
#define EXYNOS5422_KPLL_SYSCLK_CONFIGURATION			EXYNOS_PMUREG(0x2B00)
#define EXYNOS5422_KPLL_SYSCLK_STATUS				EXYNOS_PMUREG(0x2B04)
#define EXYNOS5422_KPLL_SYSCLK_OPTION				EXYNOS_PMUREG(0x2B08)
#define EXYNOS5422_MPLLUSER_SYSCLK_CONFIGURATION		EXYNOS_PMUREG(0x2B20)
#define EXYNOS5422_MPLLUSER_SYSCLK_STATUS			EXYNOS_PMUREG(0x2B24)
#define EXYNOS5422_MPLLUSER_SYSCLK_OPTION			EXYNOS_PMUREG(0x2B28)
#define EXYNOS5422_BPLLUSER_SYSCLK_CONFIGURATION		EXYNOS_PMUREG(0x2B80)
#define EXYNOS5422_BPLLUSER_SYSCLK_STATUS			EXYNOS_PMUREG(0x2B84)
#define EXYNOS5422_BPLLUSER_SYSCLK_OPTION			EXYNOS_PMUREG(0x2B88)
#define EXYNOS5422_RPLL_SYSCLK_CONFIGURATION			EXYNOS_PMUREG(0x2BA0)
#define EXYNOS5422_RPLL_SYSCLK_STATUS				EXYNOS_PMUREG(0x2BA4)
#define EXYNOS5422_RPLL_SYSCLK_OPTION				EXYNOS_PMUREG(0x2BA8)
#define EXYNOS5422_SPLL_SYSCLK_CONFIGURATION			EXYNOS_PMUREG(0x2BC0)
#define EXYNOS5422_SPLL_SYSCLK_STATUS				EXYNOS_PMUREG(0x2BC4)
#define EXYNOS5422_SPLL_SYSCLK_OPTION				EXYNOS_PMUREG(0x2BC8)
#define EXYNOS5422_TOP_BUS_CONFIGURATION			EXYNOS_PMUREG(0x2C00)
#define EXYNOS5422_TOP_BUS_STATUS				EXYNOS_PMUREG(0x2C04)
#define EXYNOS5422_TOP_BUS_OPTION				EXYNOS_PMUREG(0x2C08)
#define EXYNOS5422_TOP_RETENTION_CONFIGURATION			EXYNOS_PMUREG(0x2C20)
#define EXYNOS5422_TOP_RETENTION_STATUS				EXYNOS_PMUREG(0x2C24)
#define EXYNOS5422_TOP_RETENTION_OPTION				EXYNOS_PMUREG(0x2C28)
#define EXYNOS5422_TOP_PWR_CONFIGURATION			EXYNOS_PMUREG(0x2C40)
#define EXYNOS5422_TOP_PWR_STATUS				EXYNOS_PMUREG(0x2C44)
#define EXYNOS5422_TOP_PWR_OPTION				EXYNOS_PMUREG(0x2C48)
#define EXYNOS5422_TOP_BUS_COREBLK_CONFIGURATION		EXYNOS_PMUREG(0x2C80)
#define EXYNOS5422_TOP_BUS_COREBLK_STATUS			EXYNOS_PMUREG(0x2C84)
#define EXYNOS5422_TOP_BUS_COREBLK_OPTION			EXYNOS_PMUREG(0x2C88)
#define EXYNOS5422_TOP_RETENTION_COREBLK_CONFIGURATION		EXYNOS_PMUREG(0x2CA0)
#define EXYNOS5422_TOP_RETENTION_COREBLK_STATUS			EXYNOS_PMUREG(0x2CA4)
#define EXYNOS5422_TOP_RETENTION_COREBLK_OPTION			EXYNOS_PMUREG(0x2CA8)
#define EXYNOS5422_TOP_PWR_COREBLK_CONFIGURATION		EXYNOS_PMUREG(0x2CC0)
#define EXYNOS5422_TOP_PWR_COREBLK_STATUS			EXYNOS_PMUREG(0x2CC4)
#define EXYNOS5422_TOP_PWR_COREBLK_OPTION			EXYNOS_PMUREG(0x2CC8)
#define EXYNOS5422_LOGIC_RESET_CONFIGURATION			EXYNOS_PMUREG(0x2D00)
#define EXYNOS5422_LOGIC_RESET_STATUS				EXYNOS_PMUREG(0x2D04)
#define EXYNOS5422_LOGIC_RESET_OPTION				EXYNOS_PMUREG(0x2D08)
#define EXYNOS5422_OSCCLK_GATE_CONFIGURATION			EXYNOS_PMUREG(0x2D20)
#define EXYNOS5422_OSCCLK_GATE_STATUS				EXYNOS_PMUREG(0x2D24)
#define EXYNOS5422_OSCCLK_GATE_OPTION				EXYNOS_PMUREG(0x2D28)
#define EXYNOS5422_LOGIC_RESET_COREBLK_CONFIGURATION		EXYNOS_PMUREG(0x2D80)
#define EXYNOS5422_LOGIC_RESET_COREBLK_STATUS			EXYNOS_PMUREG(0x2D84)
#define EXYNOS5422_LOGIC_RESET_COREBLK_OPTION			EXYNOS_PMUREG(0x2D88)
#define EXYNOS5422_OSCCLK_GATE_COREBLK_CONFIGURATION		EXYNOS_PMUREG(0x2DA0)
#define EXYNOS5422_OSCCLK_GATE_COREBLK_STATUS			EXYNOS_PMUREG(0x2DA4)
#define EXYNOS5422_OSCCLK_GATE_COREBLK_OPTION			EXYNOS_PMUREG(0x2DA8)
#define EXYNOS5422_INTRAM_MEM_CONFIGURATION			EXYNOS_PMUREG(0x2F20)
#define EXYNOS5422_INTRAM_MEM_STATUS				EXYNOS_PMUREG(0x2F24)
#define EXYNOS5422_INTRAM_MEM_OPTION				EXYNOS_PMUREG(0x2F28)
#define EXYNOS5422_INTROM_MEM_CONFIGURATION			EXYNOS_PMUREG(0x2F40)
#define EXYNOS5422_INTROM_MEM_STATUS				EXYNOS_PMUREG(0x2F44)
#define EXYNOS5422_INTROM_MEM_OPTION				EXYNOS_PMUREG(0x2F48)
#define EXYNOS5422_PAD_RETENTION_DRAM_CONFIGURATION		EXYNOS_PMUREG(0x3000)
#define EXYNOS5422_PAD_RETENTION_DRAM_STATUS			EXYNOS_PMUREG(0x3004)
#define EXYNOS5422_PAD_RETENTION_DRAM_OPTION			EXYNOS_PMUREG(0x3008)
#define EXYNOS5422_PAD_RETENTION_MAU_CONFIGURATION		EXYNOS_PMUREG(0x3020)
#define EXYNOS5422_PAD_RETENTION_MAU_STATUS			EXYNOS_PMUREG(0x3024)
#define EXYNOS5422_PAD_RETENTION_MAU_OPTION			EXYNOS_PMUREG(0x3028)
#define EXYNOS5422_PAD_RETENTION_JTAG_CONFIGURATION		EXYNOS_PMUREG(0x3040)
#define EXYNOS5422_PAD_RETENTION_JTAG_STATUS			EXYNOS_PMUREG(0x3044)
#define EXYNOS5422_PAD_RETENTION_JTAG_OPTION			EXYNOS_PMUREG(0x3048)
#define EXYNOS5422_PAD_RETENTION_GPIO_CONFIGURATION		EXYNOS_PMUREG(0x30C0)
#define EXYNOS5422_PAD_RETENTION_GPIO_STATUS			EXYNOS_PMUREG(0x30C4)
#define EXYNOS5422_PAD_RETENTION_GPIO_OPTION			EXYNOS_PMUREG(0x30C8)
#define EXYNOS5422_PAD_RETENTION_UART_CONFIGURATION		EXYNOS_PMUREG(0x30E0)
#define EXYNOS5422_PAD_RETENTION_UART_STATUS			EXYNOS_PMUREG(0x30E4)
#define EXYNOS5422_PAD_RETENTION_UART_OPTION			EXYNOS_PMUREG(0x30E8)
#define EXYNOS5422_PAD_RETENTION_MMCA_CONFIGURATION		EXYNOS_PMUREG(0x3100)
#define EXYNOS5422_PAD_RETENTION_MMCA_STATUS			EXYNOS_PMUREG(0x3104)
#define EXYNOS5422_PAD_RETENTION_MMCA_OPTION			EXYNOS_PMUREG(0x3108)
#define EXYNOS5422_PAD_RETENTION_MMCB_CONFIGURATION		EXYNOS_PMUREG(0x3120)
#define EXYNOS5422_PAD_RETENTION_MMCB_STATUS			EXYNOS_PMUREG(0x3124)
#define EXYNOS5422_PAD_RETENTION_MMCB_OPTION			EXYNOS_PMUREG(0x3128)
#define EXYNOS5422_PAD_RETENTION_MMCC_CONFIGURATION		EXYNOS_PMUREG(0x3140)
#define EXYNOS5422_PAD_RETENTION_MMCC_STATUS			EXYNOS_PMUREG(0x3144)
#define EXYNOS5422_PAD_RETENTION_MMCC_OPTION			EXYNOS_PMUREG(0x3148)
#define EXYNOS5422_PAD_RETENTION_HSI_CONFIGURATION		EXYNOS_PMUREG(0x3160)
#define EXYNOS5422_PAD_RETENTION_HSI_STATUS			EXYNOS_PMUREG(0x3164)
#define EXYNOS5422_PAD_RETENTION_HSI_OPTION			EXYNOS_PMUREG(0x3168)
#define EXYNOS5422_PAD_RETENTION_EBIA_CONFIGURATION		EXYNOS_PMUREG(0x3180)
#define EXYNOS5422_PAD_RETENTION_EBIA_STATUS			EXYNOS_PMUREG(0x3184)
#define EXYNOS5422_PAD_RETENTION_EBIA_OPTION			EXYNOS_PMUREG(0x3188)
#define EXYNOS5422_PAD_RETENTION_EBIB_CONFIGURATION		EXYNOS_PMUREG(0x31A0)
#define EXYNOS5422_PAD_RETENTION_EBIB_STATUS			EXYNOS_PMUREG(0x31A4)
#define EXYNOS5422_PAD_RETENTION_EBIB_OPTION			EXYNOS_PMUREG(0x31A8)
#define EXYNOS5422_PAD_RETENTION_SPI_CONFIGURATION		EXYNOS_PMUREG(0x31C0)
#define EXYNOS5422_PAD_RETENTION_SPI_STATUS			EXYNOS_PMUREG(0x31C4)
#define EXYNOS5422_PAD_RETENTION_SPI_OPTION			EXYNOS_PMUREG(0x31C8)
#define EXYNOS5422_PAD_RETENTION_DRAM_COREBLK_CONFIGURATION	EXYNOS_PMUREG(0x31E0)
#define EXYNOS5422_PAD_RETENTION_DRAM_COREBLK_STATUS		EXYNOS_PMUREG(0x31E4)
#define EXYNOS5422_PAD_RETENTION_DRAM_COREBLK_OPTION		EXYNOS_PMUREG(0x31E8)
#define EXYNOS5422_PAD_ISOLATION_CONFIGURATION			EXYNOS_PMUREG(0x3200)
#define EXYNOS5422_PAD_ISOLATION_STATUS				EXYNOS_PMUREG(0x3204)
#define EXYNOS5422_PAD_ISOLATION_OPTION				EXYNOS_PMUREG(0x3208)
#define EXYNOS5422_PAD_ISOLATION_COREBLK_CONFIGURATION		EXYNOS_PMUREG(0x3280)
#define EXYNOS5422_PAD_ISOLATION_COREBLK_STATUS			EXYNOS_PMUREG(0x3284)
#define EXYNOS5422_PAD_ISOLATION_COREBLK_OPTION			EXYNOS_PMUREG(0x3288)
#define EXYNOS5422_PAD_ALV_SEL_CONFIGURATION			EXYNOS_PMUREG(0x3300)
#define EXYNOS5422_PAD_ALV_SEL_STATUS				EXYNOS_PMUREG(0x3304)
#define EXYNOS5422_PAD_ALV_SEL_OPTION				EXYNOS_PMUREG(0x3308)
#define EXYNOS5422_XUSBXTI_CONFIGURATION			EXYNOS_PMUREG(0x3400)
#define EXYNOS5422_XUSBXTI_STATUS				EXYNOS_PMUREG(0x3404)
#define EXYNOS5422_XUSBXTI_OPTION				EXYNOS_PMUREG(0x3408)
#define EXYNOS5422_XUSBXTI_DURATION3				EXYNOS_PMUREG(0x341C)
#define EXYNOS5422_XXTI_CONFIGURATION				EXYNOS_PMUREG(0x3420)
#define EXYNOS5422_XXTI_STATUS					EXYNOS_PMUREG(0x3424)
#define EXYNOS5422_XXTI_OPTION					EXYNOS_PMUREG(0x3428)
#define EXYNOS5422_XXTI_DURATION3				EXYNOS_PMUREG(0x343C)
#define EXYNOS5422_EXT_REGULATOR_CONFIGURATION			EXYNOS_PMUREG(0x3600)
#define EXYNOS5422_EXT_REGULATOR_STATUS				EXYNOS_PMUREG(0x3604)
#define EXYNOS5422_EXT_REGULATOR_OPTION				EXYNOS_PMUREG(0x3608)
#define EXYNOS5422_EXT_REGULATOR_DURATION3			EXYNOS_PMUREG(0x361C)
#define EXYNOS5422_GPIO_MODE_CONFIGURATION			EXYNOS_PMUREG(0x3800)
#define EXYNOS5422_GPIO_MODE_STATUS				EXYNOS_PMUREG(0x3804)
#define EXYNOS5422_GPIO_MODE_OPTION				EXYNOS_PMUREG(0x3808)
#define EXYNOS5422_GPIO_MODE_COREBLK_CONFIGURATION		EXYNOS_PMUREG(0x3900)
#define EXYNOS5422_GPIO_MODE_COREBLK_STATUS			EXYNOS_PMUREG(0x3904)
#define EXYNOS5422_GPIO_MODE_COREBLK_OPTION			EXYNOS_PMUREG(0x3908)
#define EXYNOS5422_GPIO_MODE_MAU_CONFIGURATION			EXYNOS_PMUREG(0x39E0)
#define EXYNOS5422_GPIO_MODE_MAU_STATUS				EXYNOS_PMUREG(0x39E4)
#define EXYNOS5422_GPIO_MODE_MAU_OPTION				EXYNOS_PMUREG(0x39E8)
#define EXYNOS5422_TOP_ASB_RESET_CONFIGURATION			EXYNOS_PMUREG(0x3A00)
#define EXYNOS5422_TOP_ASB_RESET_STATUS				EXYNOS_PMUREG(0x3A04)
#define EXYNOS5422_TOP_ASB_RESET_OPTION				EXYNOS_PMUREG(0x3A08)
#define EXYNOS5422_TOP_ASB_ISOLATION_CONFIGURATION		EXYNOS_PMUREG(0x3A20)
#define EXYNOS5422_TOP_ASB_ISOLATION_STATUS			EXYNOS_PMUREG(0x3A24)
#define EXYNOS5422_TOP_ASB_ISOLATION_OPTION			EXYNOS_PMUREG(0x3A28)
#define EXYNOS5422_SCALER_CONFIGURATION				EXYNOS_PMUREG(0x4000)
#define EXYNOS5422_SCALER_STATUS				EXYNOS_PMUREG(0x4004)
#define EXYNOS5422_SCALER_OPTION				EXYNOS_PMUREG(0x4008)
#define EXYNOS5422_ISP_CONFIGURATION				EXYNOS_PMUREG(0x4020)
#define EXYNOS5422_ISP_STATUS					EXYNOS_PMUREG(0x4024)
#define EXYNOS5422_ISP_OPTION					EXYNOS_PMUREG(0x4028)
#define EXYNOS5422_MFC_CONFIGURATION				EXYNOS_PMUREG(0x4060)
#define EXYNOS5422_MFC_STATUS					EXYNOS_PMUREG(0x4064)
#define EXYNOS5422_MFC_OPTION					EXYNOS_PMUREG(0x4068)
#define EXYNOS5422_G3D_CONFIGURATION				EXYNOS_PMUREG(0x4080)
#define EXYNOS5422_G3D_STATUS					EXYNOS_PMUREG(0x4084)
#define EXYNOS5422_G3D_OPTION					EXYNOS_PMUREG(0x4088)
#define EXYNOS5422_DISP1_CONFIGURATION				EXYNOS_PMUREG(0x40C0)
#define EXYNOS5422_DISP1_STATUS					EXYNOS_PMUREG(0x40C4)
#define EXYNOS5422_DISP1_OPTION					EXYNOS_PMUREG(0x40C8)
#define EXYNOS5422_MAU_CONFIGURATION				EXYNOS_PMUREG(0x40E0)
#define EXYNOS5422_MAU_STATUS					EXYNOS_PMUREG(0x40E4)
#define EXYNOS5422_MAU_OPTION					EXYNOS_PMUREG(0x40E8)
#define EXYNOS5422_G2D_CONFIGURATION				EXYNOS_PMUREG(0x4100)
#define EXYNOS5422_G2D_STATUS					EXYNOS_PMUREG(0x4104)
#define EXYNOS5422_G2D_OPTION					EXYNOS_PMUREG(0x4108)
#define EXYNOS5422_MSC_CONFIGURATION				EXYNOS_PMUREG(0x4120)
#define EXYNOS5422_MSC_STATUS					EXYNOS_PMUREG(0x4124)
#define EXYNOS5422_MSC_OPTION					EXYNOS_PMUREG(0x4128)
#define EXYNOS5422_FSYS_CONFIGURATION				EXYNOS_PMUREG(0x4140)
#define EXYNOS5422_FSYS_STATUS					EXYNOS_PMUREG(0x4144)
#define EXYNOS5422_FSYS_OPTION					EXYNOS_PMUREG(0x4148)
#define EXYNOS5422_FSYS2_CONFIGURATION				EXYNOS_PMUREG(0x4160)
#define EXYNOS5422_FSYS2_STATUS					EXYNOS_PMUREG(0x4164)
#define EXYNOS5422_FSYS2_OPTION					EXYNOS_PMUREG(0x4168)
#define EXYNOS5422_PSGEN_CONFIGURATION				EXYNOS_PMUREG(0x4180)
#define EXYNOS5422_PSGEN_STATUS					EXYNOS_PMUREG(0x4184)
#define EXYNOS5422_PSGEN_OPTION					EXYNOS_PMUREG(0x4188)
/* FSYS2_OPTION(0x4168) and PSGEN_OPTION(0x4188) */
#define EXYNOS5422_EMULATION					BIT(31)
#define EXYNOS5422_PERIC_CONFIGURATION				EXYNOS_PMUREG(0x41A0)
#define EXYNOS5422_PERIC_STATUS					EXYNOS_PMUREG(0x41A4)
#define EXYNOS5422_PERIC_OPTION					EXYNOS_PMUREG(0x41A8)
#define EXYNOS5422_WCORE_CONFIGURATION				EXYNOS_PMUREG(0x41C0)
#define EXYNOS5422_WCORE_STATUS					EXYNOS_PMUREG(0x41C4)
#define EXYNOS5422_WCORE_OPTION					EXYNOS_PMUREG(0x41C8)

#define EXYNOS5422_CMU_CLKSTOP_SCALER_CONFIGURATION		EXYNOS_PMUREG(0x4400)
#define EXYNOS5422_CMU_CLKSTOP_SCALER_STATUS			EXYNOS_PMUREG(0x4404)
#define EXYNOS5422_CMU_CLKSTOP_SCALER_OPTION			EXYNOS_PMUREG(0x4408)
#define EXYNOS5422_CMU_CLKSTOP_ISP_CONFIGURATION		EXYNOS_PMUREG(0x4420)
#define EXYNOS5422_CMU_CLKSTOP_ISP_STATUS			EXYNOS_PMUREG(0x4424)
#define EXYNOS5422_CMU_CLKSTOP_ISP_OPTION			EXYNOS_PMUREG(0x4428)
#define EXYNOS5422_CMU_CLKSTOP_MFC_CONFIGURATION		EXYNOS_PMUREG(0x4460)
#define EXYNOS5422_CMU_CLKSTOP_MFC_STATUS			EXYNOS_PMUREG(0x4464)
#define EXYNOS5422_CMU_CLKSTOP_MFC_OPTION			EXYNOS_PMUREG(0x4468)
#define EXYNOS5422_CMU_CLKSTOP_G3D_CONFIGURATION		EXYNOS_PMUREG(0x4480)
#define EXYNOS5422_CMU_CLKSTOP_G3D_STATUS			EXYNOS_PMUREG(0x4484)
#define EXYNOS5422_CMU_CLKSTOP_G3D_OPTION			EXYNOS_PMUREG(0x4488)
#define EXYNOS5422_CMU_CLKSTOP_DISP1_CONFIGURATION		EXYNOS_PMUREG(0x44C0)
#define EXYNOS5422_CMU_CLKSTOP_DISP1_STATUS			EXYNOS_PMUREG(0x44C4)
#define EXYNOS5422_CMU_CLKSTOP_DISP1_OPTION			EXYNOS_PMUREG(0x44C8)
#define EXYNOS5422_CMU_CLKSTOP_MAU_CONFIGURATION		EXYNOS_PMUREG(0x44E0)
#define EXYNOS5422_CMU_CLKSTOP_MAU_STATUS			EXYNOS_PMUREG(0x44E4)
#define EXYNOS5422_CMU_CLKSTOP_MAU_OPTION			EXYNOS_PMUREG(0x44E8)
#define EXYNOS5422_CMU_CLKSTOP_G2D_CONFIGURATION		EXYNOS_PMUREG(0x4500)
#define EXYNOS5422_CMU_CLKSTOP_G2D_STATUS			EXYNOS_PMUREG(0x4504)
#define EXYNOS5422_CMU_CLKSTOP_G2D_OPTION			EXYNOS_PMUREG(0x4508)
#define EXYNOS5422_CMU_CLKSTOP_MSC_CONFIGURATION		EXYNOS_PMUREG(0x4520)
#define EXYNOS5422_CMU_CLKSTOP_MSC_STATUS			EXYNOS_PMUREG(0x4524)
#define EXYNOS5422_CMU_CLKSTOP_MSC_OPTION			EXYNOS_PMUREG(0x4528)
#define EXYNOS5422_CMU_CLKSTOP_FSYS_CONFIGURATION		EXYNOS_PMUREG(0x4540)
#define EXYNOS5422_CMU_CLKSTOP_FSYS_STATUS			EXYNOS_PMUREG(0x4544)
#define EXYNOS5422_CMU_CLKSTOP_FSYS_OPTION			EXYNOS_PMUREG(0x4548)
#define EXYNOS5422_CMU_CLKSTOP_FSYS2_CONFIGURATION		EXYNOS_PMUREG(0x4560)
#define EXYNOS5422_CMU_CLKSTOP_FSYS2_STATUS			EXYNOS_PMUREG(0x4564)
#define EXYNOS5422_CMU_CLKSTOP_FSYS2_OPTION			EXYNOS_PMUREG(0x4568)
#define EXYNOS5422_CMU_CLKSTOP_PSGEN_CONFIGURATION		EXYNOS_PMUREG(0x4580)
#define EXYNOS5422_CMU_CLKSTOP_PSGEN_STATUS			EXYNOS_PMUREG(0x4584)
#define EXYNOS5422_CMU_CLKSTOP_PSGEN_OPTION			EXYNOS_PMUREG(0x4588)
#define EXYNOS5422_CMU_CLKSTOP_PERIC_CONFIGURATION		EXYNOS_PMUREG(0x45A0)
#define EXYNOS5422_CMU_CLKSTOP_PERIC_STATUS			EXYNOS_PMUREG(0x45A4)
#define EXYNOS5422_CMU_CLKSTOP_PERIC_OPTION			EXYNOS_PMUREG(0x45A8)
#define EXYNOS5422_CMU_CLKSTOP_WCORE_CONFIGURATION		EXYNOS_PMUREG(0x45C0)
#define EXYNOS5422_CMU_CLKSTOP_WCORE_STATUS			EXYNOS_PMUREG(0x45C4)
#define EXYNOS5422_CMU_CLKSTOP_WCORE_OPTION			EXYNOS_PMUREG(0x45C8)
#define EXYNOS5422_CMU_SYSCLK_TOPPWR_CONFIGURATION		EXYNOS_PMUREG(0x45E0)
#define EXYNOS5422_CMU_SYSCLK_TOPPWR_STATUS			EXYNOS_PMUREG(0x45E4)
#define EXYNOS5422_CMU_SYSCLK_TOPPWR_OPTION			EXYNOS_PMUREG(0x45E8)
#define EXYNOS5422_CMU_SYSCLK_SCALER_STATUS			EXYNOS_PMUREG(0x4604)
#define EXYNOS5422_CMU_SYSCLK_SCALER_OPTION			EXYNOS_PMUREG(0x4608)
#define EXYNOS5422_CMU_SYSCLK_ISP_STATUS			EXYNOS_PMUREG(0x4624)
#define EXYNOS5422_CMU_SYSCLK_ISP_OPTION			EXYNOS_PMUREG(0x4628)
#define EXYNOS5422_CMU_SYSCLK_MFC_STATUS			EXYNOS_PMUREG(0x4664)
#define EXYNOS5422_CMU_SYSCLK_MFC_OPTION			EXYNOS_PMUREG(0x4668)
#define EXYNOS5422_CMU_SYSCLK_G3D_STATUS			EXYNOS_PMUREG(0x4684)
#define EXYNOS5422_CMU_SYSCLK_G3D_OPTION			EXYNOS_PMUREG(0x4688)
#define EXYNOS5422_CMU_SYSCLK_DISP1_STATUS			EXYNOS_PMUREG(0x46C4)
#define EXYNOS5422_CMU_SYSCLK_DISP1_OPTION			EXYNOS_PMUREG(0x46C8)
#define EXYNOS5422_CMU_SYSCLK_MAU_STATUS			EXYNOS_PMUREG(0x46E4)
#define EXYNOS5422_CMU_SYSCLK_MAU_OPTION			EXYNOS_PMUREG(0x46E8)
#define EXYNOS5422_CMU_SYSCLK_G2D_STATUS			EXYNOS_PMUREG(0x4704)
#define EXYNOS5422_CMU_SYSCLK_G2D_OPTION			EXYNOS_PMUREG(0x4708)
#define EXYNOS5422_CMU_SYSCLK_MSC_STATUS			EXYNOS_PMUREG(0x4724)
#define EXYNOS5422_CMU_SYSCLK_MSC_OPTION			EXYNOS_PMUREG(0x4728)
#define EXYNOS5422_CMU_SYSCLK_FSYS_STATUS			EXYNOS_PMUREG(0x4744)
#define EXYNOS5422_CMU_SYSCLK_FSYS_OPTION			EXYNOS_PMUREG(0x4748)
#define EXYNOS5422_CMU_SYSCLK_FSYS2_STATUS			EXYNOS_PMUREG(0x4764)
#define EXYNOS5422_CMU_SYSCLK_FSYS2_OPTION			EXYNOS_PMUREG(0x4768)
#define EXYNOS5422_CMU_SYSCLK_PSGEN_STATUS			EXYNOS_PMUREG(0x4784)
#define EXYNOS5422_CMU_SYSCLK_PSGEN_OPTION			EXYNOS_PMUREG(0x4788)
#define EXYNOS5422_CMU_SYSCLK_PERIC_STATUS			EXYNOS_PMUREG(0x47A4)
#define EXYNOS5422_CMU_SYSCLK_PERIC_OPTION			EXYNOS_PMUREG(0x47A8)
#define EXYNOS5422_CMU_SYSCLK_WCORE_STATUS			EXYNOS_PMUREG(0x47C4)
#define EXYNOS5422_CMU_SYSCLK_WCORE_OPTION			EXYNOS_PMUREG(0x47C8)
#define EXYNOS5422_CMU_SYSCLK_COREBLK_TOPPWR_STATUS		EXYNOS_PMUREG(0x47E4)
#define EXYNOS5422_CMU_SYSCLK_COREBLK_TOPPWR_OPTION		EXYNOS_PMUREG(0x47E8)
#define EXYNOS5422_CMU_RESET_SCALER_CONFIGURATION		EXYNOS_PMUREG(0x4C00)
#define EXYNOS5422_CMU_RESET_SCALER_STATUS			EXYNOS_PMUREG(0x4C04)
#define EXYNOS5422_CMU_RESET_SCALER_OPTION			EXYNOS_PMUREG(0x4C08)
#define EXYNOS5422_CMU_RESET_ISP_CONFIGURATION			EXYNOS_PMUREG(0x4C20)
#define EXYNOS5422_CMU_RESET_ISP_STATUS				EXYNOS_PMUREG(0x4C24)
#define EXYNOS5422_CMU_RESET_ISP_OPTION				EXYNOS_PMUREG(0x4C28)
#define EXYNOS5422_CMU_RESET_MFC_CONFIGURATION			EXYNOS_PMUREG(0x4C60)
#define EXYNOS5422_CMU_RESET_MFC_STATUS				EXYNOS_PMUREG(0x4C64)
#define EXYNOS5422_CMU_RESET_MFC_OPTION				EXYNOS_PMUREG(0x4C68)
#define EXYNOS5422_CMU_RESET_G3D_CONFIGURATION			EXYNOS_PMUREG(0x4C80)
#define EXYNOS5422_CMU_RESET_G3D_STATUS				EXYNOS_PMUREG(0x4C84)
#define EXYNOS5422_CMU_RESET_G3D_OPTION				EXYNOS_PMUREG(0x4C88)
#define EXYNOS5422_CMU_RESET_DISP1_CONFIGURATION		EXYNOS_PMUREG(0x4CC0)
#define EXYNOS5422_CMU_RESET_DISP1_STATUS			EXYNOS_PMUREG(0x4CC4)
#define EXYNOS5422_CMU_RESET_DISP1_OPTION			EXYNOS_PMUREG(0x4CC8)
#define EXYNOS5422_CMU_RESET_MAU_CONFIGURATION			EXYNOS_PMUREG(0x4CE0)
#define EXYNOS5422_CMU_RESET_MAU_STATUS				EXYNOS_PMUREG(0x4CE4)
#define EXYNOS5422_CMU_RESET_MAU_OPTION				EXYNOS_PMUREG(0x4CE8)
#define EXYNOS5422_CMU_RESET_G2D_CONFIGURATION			EXYNOS_PMUREG(0x4E00)
#define EXYNOS5422_CMU_RESET_G2D_STATUS				EXYNOS_PMUREG(0x4E04)
#define EXYNOS5422_CMU_RESET_G2D_OPTION				EXYNOS_PMUREG(0x4E08)
#define EXYNOS5422_CMU_RESET_MSC_CONFIGURATION			EXYNOS_PMUREG(0x4E20)
#define EXYNOS5422_CMU_RESET_MSC_STATUS				EXYNOS_PMUREG(0x4E24)
#define EXYNOS5422_CMU_RESET_MSC_OPTION				EXYNOS_PMUREG(0x4E28)
#define EXYNOS5422_CMU_RESET_FSYS_CONFIGURATION			EXYNOS_PMUREG(0x4E40)
#define EXYNOS5422_CMU_RESET_FSYS_STATUS			EXYNOS_PMUREG(0x4E44)
#define EXYNOS5422_CMU_RESET_FSYS_OPTION			EXYNOS_PMUREG(0x4E48)
#define EXYNOS5422_CMU_RESET_FSYS2_CONFIGURATION		EXYNOS_PMUREG(0x4E60)
#define EXYNOS5422_CMU_RESET_FSYS2_STATUS			EXYNOS_PMUREG(0x4E64)
#define EXYNOS5422_CMU_RESET_FSYS2_OPTION			EXYNOS_PMUREG(0x4E68)
#define EXYNOS5422_CMU_RESET_PSGEN_CONFIGURATION		EXYNOS_PMUREG(0x4E80)
#define EXYNOS5422_CMU_RESET_PSGEN_STATUS			EXYNOS_PMUREG(0x4E84)
#define EXYNOS5422_CMU_RESET_PSGEN_OPTION			EXYNOS_PMUREG(0x4E88)
#define EXYNOS5422_CMU_RESET_PERIC_CONFIGURATION		EXYNOS_PMUREG(0x4EA0)
#define EXYNOS5422_CMU_RESET_PERIC_STATUS			EXYNOS_PMUREG(0x4EA4)
#define EXYNOS5422_CMU_RESET_PERIC_OPTION			EXYNOS_PMUREG(0x4EA8)
#define EXYNOS5422_CMU_RESET_WCORE_CONFIGURATION		EXYNOS_PMUREG(0x4EC0)
#define EXYNOS5422_CMU_RESET_WCORE_STATUS			EXYNOS_PMUREG(0x4EC4)
#define EXYNOS5422_CMU_RESET_WCORE_OPTION			EXYNOS_PMUREG(0x4EC8)

/* Newly Added (CAM block) */
#define EXYNOS5422_CAM_SYS_PWR_REG				EXYNOS_PMUREG(0x5000)
#define EXYNOS5422_CMU_CLKSTOP_CAM_SYS_PWR_REG			EXYNOS_PMUREG(0x5010)
#define EXYNOS5422_CMU_SYSCLK_CAM_SYS_PWR_REG			EXYNOS_PMUREG(0x5020)
#define EXYNOS5422_CMU_RESET_CAM_SYS_PWR_REG			EXYNOS_PMUREG(0x5030)
#define EXYNOS5422_CAM_CONFIGURATION				EXYNOS_PMUREG(0x5100)
#define EXYNOS5422_CAM_STATUS					EXYNOS_PMUREG(0x5104)
#define EXYNOS5422_CAM_OPTION					EXYNOS_PMUREG(0x5108)
#define EXYNOS5422_CMU_CLKSTOP_CAM_CONFIGURATION		EXYNOS_PMUREG(0x5200)
#define EXYNOS5422_CMU_CLKSTOP_CAM_STATUS			EXYNOS_PMUREG(0x5204)
#define EXYNOS5422_CMU_CLKSTOP_CAM_OPTION			EXYNOS_PMUREG(0x5208)
#define EXYNOS5422_CMU_SYSCLK_CAM_CONFIGURATION			EXYNOS_PMUREG(0x5300)
#define EXYNOS5422_CMU_SYSCLK_CAM_STATUS			EXYNOS_PMUREG(0x5304)
#define EXYNOS5422_CMU_SYSCLK_CAM_OPTION			EXYNOS_PMUREG(0x5308)
#define EXYNOS5422_CMU_RESET_CAM_CONFIGURATION			EXYNOS_PMUREG(0x5400)
#define EXYNOS5422_CMU_RESET_CAM_STATUS				EXYNOS_PMUREG(0x5404)
#define EXYNOS5422_CMU_RESET_CAM_OPTION				EXYNOS_PMUREG(0x5408)

/* Hidden */

#define EXYNOS5422_ARM_INTR_SPREAD_ENABLE			EXYNOS_PMUREG(0x0100)
#define EXYNOS5422_ARM_INTR_SPREAD_USE_STANDBYWFI		EXYNOS_PMUREG(0x0104)
#define EXYNOS5422_UP_SCHEDULER					EXYNOS_PMUREG(0x0120)

/* ASV */
#define EXYNOS5422_BIAS_CON_ARM					EXYNOS_PMUREG(0x0780)
#define EXYNOS5422_BIAS_CON_INT					EXYNOS_PMUREG(0x0784)
#define EXYNOS5422_BIAS_CON_MIF					EXYNOS_PMUREG(0x0788)
#define EXYNOS5422_BIAS_CON_KFC					EXYNOS_PMUREG(0x078C)
#define EXYNOS5422_BIAS_CON_G3D					EXYNOS_PMUREG(0x0790)

/* FIMC_IS */
#define EXYNOS5422_LPI_BUS_MASK0				EXYNOS_PMUREG(0x15A4)
#define EXYNOS5422_ISP0						BIT(13)
#define EXYNOS5422_ISP1						BIT(14)
#define EXYNOS5422_RSTOP_ISP					BIT(15)
#define EXYNOS5422_PRSTOP_ISP					BIT(16)

/* SFR_AXI_CGDIS1 */
#define EXYNOS5422_SFR_AXI_CGDIS1				EXYNOS_PMUREG(0x15E4)
#define EXYNOS5422_UFS						BIT(8)
#define EXYNOS5422_ACE_KFC					BIT(14)
#define EXYNOS5422_ACE_EAGLE					BIT(15)

#define EXYNOS5422_LOGIC_RESET_DURATION3			EXYNOS_PMUREG(0x2D1C)

/* compatibility */
#define EXYNOS54XX_PAD_RETENTION_DRAM_SYSMEM_SYS_PWR_REG \
		EXYNOS5422_PAD_RETENTION_DRAM_COREBLK_SYS_PWR_REG
#define EXYNOS5422_SFR_AXI_CGDIS1_REG \
		EXYNOS5422_SFR_AXI_CGDIS1
#define EXYNOS5422_FSYS2_OPTION_REG \
		EXYNOS5422_FSYS2_OPTION
#define EXYNOS5422_PSGEN_OPTION_REG \
		EXYNOS5422_PSGEN_OPTION

#endif /* __ASM_ARCH_REGS_PMU_EXYNOS5422_H */
