/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.interpreter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRScope;
import org.jruby.ir.dataflow.DataFlowProblem;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ReceiveSelfInstr;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.interpreter.SimpleMethodInterpreterEngine;
import org.jruby.ir.passes.CompilerPass;
import org.jruby.ir.representations.BasicBlock;
import org.jruby.ir.representations.CFG;
import org.jruby.ir.representations.CFGLinearizer;

public class FullInterpreterContext
extends InterpreterContext {
    private CFG cfg;
    private BasicBlock[] linearizedBBList = null;
    private Map<String, DataFlowProblem> dataFlowProblems;
    private List<CompilerPass> executedPasses = new ArrayList<CompilerPass>();

    public FullInterpreterContext(IRScope scope, Instr[] instructions) {
        super(scope, (List<Instr>)null);
        this.cfg = this.buildCFG(instructions);
    }

    @Override
    public boolean buildComplete() {
        return this.linearizedBBList != null;
    }

    public BasicBlock[] linearizeBasicBlocks() {
        this.linearizedBBList = CFGLinearizer.linearize(this.cfg);
        return this.linearizedBBList;
    }

    private CFG buildCFG(Instr[] instructions) {
        CFG newCFG = new CFG(this.getScope());
        newCFG.build(instructions);
        return newCFG;
    }

    @Override
    public boolean hasExplicitCallProtocol() {
        return this.getScope().getFlags().contains((Object)IRFlags.HAS_EXPLICIT_CALL_PROTOCOL);
    }

    @Override
    public boolean pushNewDynScope() {
        return !this.getScope().getFlags().contains((Object)IRFlags.DYNSCOPE_ELIMINATED) && !this.reuseParentDynScope();
    }

    @Override
    public boolean popDynScope() {
        return this.pushNewDynScope() || this.reuseParentDynScope();
    }

    @Override
    public boolean reuseParentDynScope() {
        return this.getScope().getFlags().contains((Object)IRFlags.REUSE_PARENT_DYNSCOPE);
    }

    public void generateInstructionsForIntepretation() {
        this.linearizeBasicBlocks();
        boolean simple_method = this.getScope() instanceof IRMethod;
        ArrayList<Instr> newInstrs = new ArrayList<Instr>();
        int ipc = 0;
        for (BasicBlock b2 : this.getLinearizedBBList()) {
            b2.getLabel().setTargetPC(ipc);
            List<Instr> bbInstrs = b2.getInstrs();
            int bbInstrsLength = bbInstrs.size();
            for (int i2 = 0; i2 < bbInstrsLength; ++i2) {
                Instr instr = bbInstrs.get(i2);
                if (simple_method && SimpleMethodInterpreterEngine.OPERATIONS.get((Object)instr.getOperation()) == null) {
                    simple_method = false;
                }
                if (instr instanceof ReceiveSelfInstr) continue;
                instr.setIPC(ipc);
                newInstrs.add(instr);
                ++ipc;
            }
        }
        if (simple_method) {
            this.getScope().getFlags().add(IRFlags.SIMPLE_METHOD);
        }
        this.cfg.getExitBB().getLabel().setTargetPC(ipc + 1);
        Instr[] linearizedInstrArray = newInstrs.toArray(new Instr[newInstrs.size()]);
        ipc = 0;
        for (BasicBlock b3 : this.getLinearizedBBList()) {
            BasicBlock rescuerBB = this.cfg.getRescuerBBFor(b3);
            int rescuerPC = rescuerBB == null ? -1 : rescuerBB.getLabel().getTargetPC();
            for (Instr instr : b3.getInstrs()) {
                if (instr instanceof ReceiveSelfInstr) continue;
                linearizedInstrArray[ipc].setRPC(rescuerPC);
                ++ipc;
            }
        }
        this.instructions = linearizedInstrArray;
        this.temporaryVariablecount = this.getScope().getTemporaryVariablesCount();
    }

    @Override
    public CFG getCFG() {
        return this.cfg;
    }

    @Override
    public void computeScopeFlagsFromInstructions() {
        for (BasicBlock b2 : this.cfg.getBasicBlocks()) {
            for (Instr i2 : b2.getInstrs()) {
                i2.computeScopeFlags(this.getScope());
            }
        }
    }

    public Map<String, DataFlowProblem> getDataFlowProblems() {
        if (this.dataFlowProblems == null) {
            this.dataFlowProblems = new HashMap<String, DataFlowProblem>();
        }
        return this.dataFlowProblems;
    }

    public List<CompilerPass> getExecutedPasses() {
        return this.executedPasses;
    }

    public BasicBlock[] getLinearizedBBList() {
        return this.linearizedBBList;
    }

    @Override
    public String toStringInstrs() {
        return "\nCFG:\n" + this.cfg.toStringGraph() + "\nInstructions:\n" + this.cfg.toStringInstrs();
    }
}

