/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Iterator;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.module.ModuleNodes;
import org.jruby.truffle.language.LexicalScope;
import org.jruby.truffle.language.RubyConstant;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;

@NodeChild(value="lexicalParentModule", type=RubyNode.class)
public abstract class DefineModuleNode
extends RubyNode {
    private final String name;
    @Node.Child
    private IndirectCallNode indirectCallNode;
    private final ConditionProfile needToDefineProfile = ConditionProfile.createBinaryProfile();
    private final BranchProfile errorProfile = BranchProfile.create();

    public DefineModuleNode(RubyContext context, SourceSection sourceSection, String name) {
        super(context, sourceSection);
        this.name = name;
        this.indirectCallNode = IndirectCallNode.create();
    }

    @Specialization(guards={"isRubyModule(lexicalParentModule)"})
    public Object defineModule(VirtualFrame frame, DynamicObject lexicalParentModule) {
        DynamicObject definingModule;
        RubyConstant constant = DefineModuleNode.lookupForExistingModule(frame, this.getContext(), this.name, lexicalParentModule, this.indirectCallNode);
        if (this.needToDefineProfile.profile(constant == null)) {
            definingModule = ModuleNodes.createModule(this.getContext(), this.coreLibrary().getModuleClass(), lexicalParentModule, this.name, this);
        } else {
            Object constantValue = constant.getValue();
            if (!RubyGuards.isRubyModule(constantValue) || RubyGuards.isRubyClass(constantValue)) {
                this.errorProfile.enter();
                throw new RaiseException(this.coreExceptions().typeErrorIsNotA(this.name, "module", (Node)this));
            }
            definingModule = (DynamicObject)constantValue;
        }
        return definingModule;
    }

    @Specialization(guards={"!isRubyModule(lexicalParentObject)"})
    public Object defineModuleWrongParent(VirtualFrame frame, Object lexicalParentObject) {
        throw new RaiseException(this.coreExceptions().typeErrorIsNotA(lexicalParentObject, "module", (Node)this));
    }

    public static RubyConstant lookupForExistingModule(VirtualFrame frame, RubyContext context, String name, DynamicObject lexicalParent, IndirectCallNode callNode) {
        CompilerDirectives.transferToInterpreter();
        RubyConstant constant = Layouts.MODULE.getFields(lexicalParent).getConstant(name);
        DynamicObject objectClass = context.getCoreLibrary().getObjectClass();
        if (constant == null && lexicalParent == objectClass) {
            DynamicObject included;
            Iterator<DynamicObject> iterator = Layouts.MODULE.getFields(objectClass).prependedAndIncludedModules().iterator();
            while (iterator.hasNext() && (constant = Layouts.MODULE.getFields(included = iterator.next()).getConstant(name)) == null) {
            }
        }
        if (constant != null && !constant.isVisibleTo(context, LexicalScope.NONE, lexicalParent)) {
            throw new RaiseException(context.getCoreExceptions().nameErrorPrivateConstant(lexicalParent, name, callNode));
        }
        if (constant != null && constant.isAutoload()) {
            Layouts.MODULE.getFields(lexicalParent).removeConstant(context, callNode, name);
            context.getFeatureLoader().require(frame, constant.getValue().toString(), callNode);
            return DefineModuleNode.lookupForExistingModule(frame, context, name, lexicalParent, callNode);
        }
        return constant;
    }
}

