/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.AbstractLeafElement;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.TypeAlias;
import java.beans.PropertyVetoException;
import java.util.HashSet;
import java.util.Set;

public abstract class Type
extends AbstractLeafElement
implements Cloneable {
    protected Type extending = null;
    protected Set<Type> extendedBy = new HashSet<Type>(2);
    protected boolean mandatory = false;

    protected Type() {
    }

    public Type clone() {
        Type cloned = null;
        try {
            cloned = (Type)super.clone();
            cloned.extendedBy = new HashSet<Type>(2);
            if (cloned.extending != null) {
                cloned.extending.extendedBy.add(cloned);
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return cloned;
    }

    public boolean isAbstract() {
        return false;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public boolean isMandatoryConsideringAliases() {
        return this.isMandatory();
    }

    public void setMandatory(boolean mand) throws PropertyVetoException {
        boolean oldValue = this.mandatory;
        boolean newValue = mand;
        this.fireVetoableChange("mandatory", oldValue, newValue);
        this.mandatory = mand;
        this.firePropertyChange("mandatory", oldValue, newValue);
    }

    public Element getExtending() {
        return this.extending;
    }

    public void setExtending(Type extending) throws PropertyVetoException {
        Type oldValue = this.extending;
        Type newValue = extending;
        if (oldValue == newValue) {
            return;
        }
        if (newValue != null && newValue.isExtendingIndirectly(this)) {
            throw new IllegalArgumentException(Type.formatMessage("err_cyclicExtension", this.toString(), newValue.toString()));
        }
        this.checkTypeExtension(newValue);
        this.fireVetoableChange("extending", oldValue, newValue);
        if (oldValue != null) {
            oldValue.extendedBy.remove(this);
        }
        this.extending = newValue;
        if (newValue != null) {
            newValue.extendedBy.add(this);
        }
        this.firePropertyChange("extending", oldValue, newValue);
    }

    boolean isExtendingIndirectly(Type typ) {
        Type parent = this;
        while (parent != null) {
            if (parent == typ) {
                return true;
            }
            parent = parent.extending;
        }
        return false;
    }

    abstract void checkTypeExtension(Type var1);

    public Type resolveAliases() {
        return this;
    }

    public static final Type findReal(Type potentialAlias) {
        if (potentialAlias instanceof TypeAlias) {
            return Type.findReal(potentialAlias.resolveAliases());
        }
        return potentialAlias;
    }
}

