/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jk.common;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URLEncoder;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Request;
import org.apache.coyote.RequestGroupInfo;
import org.apache.coyote.RequestInfo;
import org.apache.jk.common.MsgAjp;
import org.apache.jk.core.JkChannel;
import org.apache.jk.core.JkHandler;
import org.apache.jk.core.Msg;
import org.apache.jk.core.MsgContext;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.threads.ThreadPool;
import org.apache.tomcat.util.threads.ThreadPoolRunnable;

public class ChannelSocket
extends JkHandler
implements NotificationBroadcaster,
JkChannel {
    private static Log log = LogFactory.getLog(ChannelSocket.class);
    private int startPort = 8009;
    private int maxPort = 0;
    private int port = this.startPort;
    private int backlog = 0;
    private InetAddress inet;
    private int serverTimeout;
    private boolean tcpNoDelay = true;
    private int linger = 100;
    private int socketTimeout;
    private int bufferSize = -1;
    private int packetSize = 8192;
    private long requestCount = 0L;
    ThreadPool tp = ThreadPool.createThreadPool(true);
    ServerSocket sSocket;
    final int socketNote = 1;
    final int isNote = 2;
    final int osNote = 3;
    final int notifNote = 4;
    boolean paused = false;
    ObjectName tpOName;
    ObjectName rgOName;
    RequestGroupInfo global = new RequestGroupInfo();
    int JMXRequestNote;
    protected boolean running = true;
    private NotificationBroadcasterSupport nSupport = null;
    MBeanNotificationInfo[] notifInfo = new MBeanNotificationInfo[0];

    public ThreadPool getThreadPool() {
        return this.tp;
    }

    public long getRequestCount() {
        return this.requestCount;
    }

    public void setPort(int port) {
        this.startPort = port;
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setAddress(InetAddress inet) {
        this.inet = inet;
    }

    public void setAddress(String inet) {
        try {
            this.inet = InetAddress.getByName(inet);
        }
        catch (Exception ex) {
            log.error((Object)("Error parsing " + inet), (Throwable)ex);
        }
    }

    public String getAddress() {
        if (this.inet != null) {
            return this.inet.toString();
        }
        return "/0.0.0.0";
    }

    public void setServerTimeout(int timeout) {
        this.serverTimeout = timeout;
    }

    public int getServerTimeout() {
        return this.serverTimeout;
    }

    public void setTcpNoDelay(boolean b) {
        this.tcpNoDelay = b;
    }

    public boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setSoLinger(int i) {
        this.linger = i;
    }

    public int getSoLinger() {
        return this.linger;
    }

    public void setSoTimeout(int i) {
        this.socketTimeout = i;
    }

    public int getSoTimeout() {
        return this.socketTimeout;
    }

    public void setMaxPort(int i) {
        this.maxPort = i;
    }

    public int getMaxPort() {
        return this.maxPort;
    }

    public void setBufferSize(int bs) {
        this.bufferSize = bs;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setPacketSize(int ps) {
        if (ps < 8192) {
            ps = 8192;
        }
        this.packetSize = ps;
    }

    public int getPacketSize() {
        return this.packetSize;
    }

    public int getInstanceId() {
        return this.port - this.startPort;
    }

    public void setDaemon(boolean b) {
        this.tp.setDaemon(b);
    }

    public boolean getDaemon() {
        return this.tp.getDaemon();
    }

    public void setMaxThreads(int i) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting maxThreads " + i));
        }
        this.tp.setMaxThreads(i);
    }

    public void setMinSpareThreads(int i) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting minSpareThreads " + i));
        }
        this.tp.setMinSpareThreads(i);
    }

    public void setMaxSpareThreads(int i) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting maxSpareThreads " + i));
        }
        this.tp.setMaxSpareThreads(i);
    }

    public int getMaxThreads() {
        return this.tp.getMaxThreads();
    }

    public int getMinSpareThreads() {
        return this.tp.getMinSpareThreads();
    }

    public int getMaxSpareThreads() {
        return this.tp.getMaxSpareThreads();
    }

    public void setBacklog(int i) {
        this.backlog = i;
    }

    public int getBacklog() {
        return this.backlog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() throws Exception {
        ChannelSocket channelSocket = this;
        synchronized (channelSocket) {
            this.paused = true;
            this.unLockSocket();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() throws Exception {
        ChannelSocket channelSocket = this;
        synchronized (channelSocket) {
            this.paused = false;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(MsgContext ep) throws IOException {
        if (this.sSocket == null) {
            return;
        }
        ChannelSocket channelSocket = this;
        synchronized (channelSocket) {
            while (this.paused) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {}
            }
        }
        Socket s = this.sSocket.accept();
        ep.setNote(1, s);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Accepted socket " + s));
        }
        try {
            this.setSocketOptions(s);
        }
        catch (SocketException sex) {
            log.debug((Object)"Error initializing Socket Options", (Throwable)sex);
        }
        ++this.requestCount;
        BufferedInputStream is = new BufferedInputStream(s.getInputStream());
        OutputStream os = this.bufferSize > 0 ? new BufferedOutputStream(s.getOutputStream(), this.bufferSize) : s.getOutputStream();
        ep.setNote(2, is);
        ep.setNote(3, os);
        ep.setControl(this.tp);
    }

    private void setSocketOptions(Socket s) throws SocketException {
        if (this.socketTimeout > 0) {
            s.setSoTimeout(this.socketTimeout);
        }
        s.setTcpNoDelay(this.tcpNoDelay);
        if (this.linger > 0) {
            s.setSoLinger(true, this.linger);
        }
    }

    public void resetCounters() {
        this.requestCount = 0L;
    }

    public void reinit() throws IOException {
        this.destroy();
        this.init();
    }

    public void init() throws IOException {
        if (this.startPort < 0) {
            this.port = 0;
            if (log.isInfoEnabled()) {
                log.info((Object)"JK: ajp13 disabling channelSocket");
            }
            this.running = true;
            return;
        }
        if (this.startPort == 0) {
            try {
                this.sSocket = this.inet == null ? new ServerSocket(0, this.backlog) : new ServerSocket(0, this.backlog, this.inet);
            }
            catch (IOException ex) {
                log.error((Object)"Can't find free port", (Throwable)ex);
                this.sSocket = null;
                return;
            }
            this.port = this.sSocket.getLocalPort();
        } else {
            int endPort = this.maxPort;
            if (endPort < this.startPort) {
                endPort = this.startPort;
            }
            for (int i = this.startPort; i <= endPort; ++i) {
                try {
                    this.sSocket = this.inet == null ? new ServerSocket(i, this.backlog) : new ServerSocket(i, this.backlog, this.inet);
                    this.port = i;
                    break;
                }
                catch (IOException ex) {
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)("Port busy " + i + " " + ex.toString()));
                    continue;
                }
            }
            if (this.sSocket == null) {
                log.error((Object)("Can't find free port " + this.startPort + " " + endPort));
                return;
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("JK: ajp13 listening on " + this.getAddress() + ":" + this.port));
        }
        if ("channelSocket".equals(this.name) && this.port != this.startPort && this.wEnv.getLocalId() == 0) {
            this.wEnv.setLocalId(this.port - this.startPort);
        }
        if (this.serverTimeout > 0) {
            this.sSocket.setSoTimeout(this.serverTimeout);
        }
        if (this.next == null && this.wEnv != null) {
            if (this.nextName != null) {
                this.setNext(this.wEnv.getHandler(this.nextName));
            }
            if (this.next == null) {
                this.next = this.wEnv.getHandler("dispatch");
            }
            if (this.next == null) {
                this.next = this.wEnv.getHandler("request");
            }
        }
        this.JMXRequestNote = this.wEnv.getNoteId(0, "requestNote");
        this.running = true;
        if (this.domain != null) {
            try {
                this.tpOName = new ObjectName(this.domain + ":type=ThreadPool,name=" + this.getChannelName());
                Registry.getRegistry(null, null).registerComponent((Object)this.tp, this.tpOName, null);
                this.rgOName = new ObjectName(this.domain + ":type=GlobalRequestProcessor,name=" + this.getChannelName());
                Registry.getRegistry(null, null).registerComponent((Object)this.global, this.rgOName, null);
            }
            catch (Exception e) {
                log.error((Object)"Can't register threadpool");
            }
        }
        this.tp.start();
        SocketAcceptor acceptAjp = new SocketAcceptor(this);
        this.tp.runIt(acceptAjp);
    }

    public void start() throws IOException {
        if (this.sSocket == null) {
            this.init();
        }
    }

    public void stop() throws IOException {
        this.destroy();
    }

    public void registerRequest(Request req, MsgContext ep, int count) {
        if (this.domain != null) {
            try {
                RequestInfo rp = req.getRequestProcessor();
                rp.setGlobalProcessor(this.global);
                ObjectName roname = new ObjectName(this.getDomain() + ":type=RequestProcessor,worker=" + this.getChannelName() + ",name=JkRequest" + count);
                ep.setNote(this.JMXRequestNote, roname);
                Registry.getRegistry(null, null).registerComponent((Object)rp, roname, null);
            }
            catch (Exception ex) {
                log.warn((Object)"Error registering request");
            }
        }
    }

    public void open(MsgContext ep) throws IOException {
    }

    public void close(MsgContext ep) throws IOException {
        Socket s = (Socket)ep.getNote(1);
        s.close();
    }

    private void unLockSocket() throws IOException {
        InetAddress ladr = this.inet;
        if (this.port == 0) {
            return;
        }
        if (ladr == null || "0.0.0.0".equals(ladr.getHostAddress())) {
            ladr = InetAddress.getLocalHost();
        }
        Socket s = new Socket(ladr, this.port);
        s.setSoLinger(true, 0);
        s.close();
    }

    public void destroy() throws IOException {
        block7: {
            this.running = false;
            try {
                if (this.port == 0) {
                    return;
                }
                this.tp.shutdown();
                if (!this.paused) {
                    this.unLockSocket();
                }
                if (this.sSocket != null) {
                    this.sSocket.close();
                }
                if (this.tpOName != null) {
                    Registry.getRegistry(null, null).unregisterComponent(this.tpOName);
                }
                if (this.rgOName != null) {
                    Registry.getRegistry(null, null).unregisterComponent(this.rgOName);
                }
            }
            catch (Exception e) {
                log.info((Object)("Error shutting down the channel " + this.port + " " + e.toString()));
                if (!log.isDebugEnabled()) break block7;
                log.debug((Object)"Trace", (Throwable)e);
            }
        }
    }

    public int send(Msg msg, MsgContext ep) throws IOException {
        msg.end();
        byte[] buf = msg.getBuffer();
        int len = msg.getLen();
        if (log.isTraceEnabled()) {
            log.trace((Object)("send() " + len + " " + buf[4]));
        }
        OutputStream os = (OutputStream)ep.getNote(3);
        os.write(buf, 0, len);
        return len;
    }

    public int flush(Msg msg, MsgContext ep) throws IOException {
        if (this.bufferSize > 0) {
            OutputStream os = (OutputStream)ep.getNote(3);
            os.flush();
        }
        return 0;
    }

    public int receive(Msg msg, MsgContext ep) throws IOException {
        int hlen;
        byte[] buf;
        int rd;
        if (log.isDebugEnabled()) {
            log.debug((Object)"receive() ");
        }
        if ((rd = this.read(ep, buf = msg.getBuffer(), 0, hlen = msg.getHeaderLength())) < 0) {
            return rd;
        }
        msg.processHeader();
        int blen = msg.getLen();
        int total_read = 0;
        total_read = this.read(ep, buf, hlen, blen);
        if (total_read <= 0 && blen > 0) {
            log.warn((Object)("can't read body, waited #" + blen));
            return -1;
        }
        if (total_read != blen) {
            log.warn((Object)("incomplete read, waited #" + blen + " got only " + total_read));
            return -2;
        }
        return total_read;
    }

    public int read(MsgContext ep, byte[] b, int offset, int len) throws IOException {
        int pos;
        int got;
        InputStream is = (InputStream)ep.getNote(2);
        for (pos = 0; pos < len; pos += got) {
            try {
                got = is.read(b, pos + offset, len - pos);
            }
            catch (SocketException sex) {
                if (pos > 0) {
                    log.info((Object)("Error reading data after " + pos + "bytes"), (Throwable)sex);
                } else {
                    log.debug((Object)"Error reading data", (Throwable)sex);
                }
                got = -1;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("read() " + b + " " + (b == null ? 0 : b.length) + " " + offset + " " + len + " = " + got));
            }
            if (got > 0) continue;
            return -3;
        }
        return pos;
    }

    void acceptConnections() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Accepting ajp connections on " + this.port));
        }
        while (this.running) {
            try {
                MsgContext ep = this.createMsgContext(this.packetSize);
                ep.setSource(this);
                ep.setWorkerEnv(this.wEnv);
                this.accept(ep);
                if (!this.running) break;
                SocketConnection ajpConn = new SocketConnection(this, ep);
                this.tp.runIt(ajpConn);
            }
            catch (Exception ex) {
                if (!this.running) continue;
                log.warn((Object)"Exception executing accept", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void processConnection(MsgContext ep) {
        block26: {
            MsgAjp recv = new MsgAjp(this.packetSize);
            while (this.running && !this.paused) {
                int status = this.receive(recv, ep);
                if (status <= 0) {
                    if (status == -3) {
                        log.debug((Object)"server has been restarted or reset this connection");
                        break;
                    }
                    log.warn((Object)("Closing ajp connection " + status));
                    break;
                }
                ep.setLong(0, System.currentTimeMillis());
                ep.setType(0);
                status = this.invoke(recv, ep);
                if (status == 0) continue;
                log.warn((Object)("processCallbacks status " + status));
                ep.action(ActionCode.ACTION_CLOSE, ep.getRequest().getResponse());
                break;
            }
            Object var5_6 = null;
            try {
                this.close(ep);
            }
            catch (Exception e) {
                log.error((Object)"Error, closing connection", (Throwable)e);
            }
            try {
                Request req = ep.getRequest();
                if (req != null) {
                    ObjectName roname = (ObjectName)ep.getNote(this.JMXRequestNote);
                    if (roname != null) {
                        Registry.getRegistry(null, null).unregisterComponent(roname);
                    }
                    req.getRequestProcessor().setGlobalProcessor(null);
                }
                break block26;
            }
            catch (Exception ee) {
                log.error((Object)"Error, releasing connection", (Throwable)ee);
            }
            break block26;
            {
                catch (Exception ex) {
                    String msg = ex.getMessage();
                    if (msg != null && msg.indexOf("Connection reset") >= 0) {
                        log.debug((Object)"Server has been restarted or reset this connection");
                    } else if (msg != null && msg.indexOf("Read timed out") >= 0) {
                        log.debug((Object)"connection timeout reached");
                    } else {
                        log.error((Object)"Error, processing connection", (Throwable)ex);
                    }
                    Object var5_7 = null;
                    try {
                        this.close(ep);
                    }
                    catch (Exception e) {
                        log.error((Object)"Error, closing connection", (Throwable)e);
                    }
                    try {
                        Request req = ep.getRequest();
                        if (req != null) {
                            ObjectName roname = (ObjectName)ep.getNote(this.JMXRequestNote);
                            if (roname != null) {
                                Registry.getRegistry(null, null).unregisterComponent(roname);
                            }
                            req.getRequestProcessor().setGlobalProcessor(null);
                        }
                        break block26;
                    }
                    catch (Exception ee) {
                        log.error((Object)"Error, releasing connection", (Throwable)ee);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                try {
                    this.close(ep);
                }
                catch (Exception e) {
                    log.error((Object)"Error, closing connection", (Throwable)e);
                }
                try {
                    Request req = ep.getRequest();
                    if (req != null) {
                        ObjectName roname = (ObjectName)ep.getNote(this.JMXRequestNote);
                        if (roname != null) {
                            Registry.getRegistry(null, null).unregisterComponent(roname);
                        }
                        req.getRequestProcessor().setGlobalProcessor(null);
                    }
                }
                catch (Exception ee) {
                    log.error((Object)"Error, releasing connection", (Throwable)ee);
                }
                throw throwable;
            }
        }
    }

    public int invoke(Msg msg, MsgContext ep) throws IOException {
        int type = ep.getType();
        switch (type) {
            case 10: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"RECEIVE_PACKET ?? ");
                }
                return this.receive(msg, ep);
            }
            case 11: {
                return this.send(msg, ep);
            }
            case 12: {
                return this.flush(msg, ep);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Call next " + type + " " + this.next));
        }
        if (this.nSupport != null) {
            Notification notif = (Notification)ep.getNote(4);
            if (notif == null) {
                notif = new Notification("channelSocket.message", ep, this.requestCount);
                ep.setNote(4, notif);
            }
            this.nSupport.sendNotification(notif);
        }
        if (this.next != null) {
            return this.next.invoke(msg, ep);
        }
        log.info((Object)"No next ");
        return 0;
    }

    public boolean isSameAddress(MsgContext ep) {
        Socket s = (Socket)ep.getNote(1);
        return ChannelSocket.isSameAddress(s.getLocalAddress(), s.getInetAddress());
    }

    public String getChannelName() {
        String encodedAddr = "";
        if (this.inet != null && !"0.0.0.0".equals(this.inet.getHostAddress())) {
            encodedAddr = this.getAddress();
            if (encodedAddr.startsWith("/")) {
                encodedAddr = encodedAddr.substring(1);
            }
            encodedAddr = URLEncoder.encode(encodedAddr) + "-";
        }
        return "jk-" + encodedAddr + this.port;
    }

    public static boolean isSameAddress(InetAddress server, InetAddress client) {
        int i;
        byte[] clientAddr;
        byte[] serverAddr = server.getAddress();
        if (serverAddr.length != (clientAddr = client.getAddress()).length) {
            return false;
        }
        boolean match = true;
        for (i = 0; i < serverAddr.length; ++i) {
            if (serverAddr[i] == clientAddr[i]) continue;
            match = false;
            break;
        }
        if (match) {
            return true;
        }
        for (i = 0; i < serverAddr.length; ++i) {
            if (serverAddr[i] == clientAddr[serverAddr.length - 1 - i]) continue;
            return false;
        }
        return true;
    }

    public void sendNewMessageNotification(Notification notification) {
        if (this.nSupport != null) {
            this.nSupport.sendNotification(notification);
        }
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        if (this.nSupport == null) {
            this.nSupport = new NotificationBroadcasterSupport();
        }
        this.nSupport.addNotificationListener(listener, filter, handback);
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        if (this.nSupport != null) {
            this.nSupport.removeNotificationListener(listener);
        }
    }

    public void setNotificationInfo(MBeanNotificationInfo[] info) {
        this.notifInfo = info;
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.notifInfo;
    }

    static class SocketConnection
    implements ThreadPoolRunnable {
        ChannelSocket wajp;
        MsgContext ep;

        SocketConnection(ChannelSocket wajp, MsgContext ep) {
            this.wajp = wajp;
            this.ep = ep;
        }

        public Object[] getInitData() {
            return null;
        }

        public void runIt(Object[] perTh) {
            this.wajp.processConnection(this.ep);
            this.ep = null;
        }
    }

    static class SocketAcceptor
    implements ThreadPoolRunnable {
        ChannelSocket wajp;

        SocketAcceptor(ChannelSocket wajp) {
            this.wajp = wajp;
        }

        public Object[] getInitData() {
            return null;
        }

        public void runIt(Object[] thD) {
            this.wajp.acceptConnections();
        }
    }
}

