/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.timeline;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.charts.ChartComponent;
import org.netbeans.lib.profiler.charts.ChartConfigurationListener;
import org.netbeans.lib.profiler.charts.ChartContext;
import org.netbeans.lib.profiler.charts.ChartItem;
import org.netbeans.lib.profiler.charts.ChartSelectionListener;
import org.netbeans.lib.profiler.charts.ChartSelectionModel;
import org.netbeans.lib.profiler.charts.ItemPainter;
import org.netbeans.lib.profiler.charts.ItemSelection;
import org.netbeans.lib.profiler.charts.ItemsModel;
import org.netbeans.lib.profiler.charts.PaintersModel;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.lib.profiler.charts.xy.XYItem;
import org.netbeans.lib.profiler.charts.xy.XYItemSelection;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineIconPainter;

class TimelineSelectionManager
implements ChartSelectionModel {
    private ChartComponent chart;
    private ChartListener chartListener = new ChartListener();
    private MouseListener mouseListener = new MouseListener();
    private int selectionMode;
    private int moveMode;
    private int dragMode;
    private int hoverMode;
    private int hoverDistanceLimit;
    private int mouseX = -1;
    private int mouseY = -1;
    private boolean inChart = false;
    private Rectangle selectionBounds;
    private List<ItemSelection> highlightedSelection;
    private List<ItemSelection> selectedSelection;
    private boolean mousePanningBackup;
    private boolean enabled = true;
    private List<ChartSelectionListener> selectionListeners;
    private int startIndex = -1;
    private int endIndex = -1;

    public TimelineSelectionManager() {
        this.setMoveMode(0);
        this.setDragMode(0);
        this.setSelectionMode(this.moveMode);
        this.setHoverMode(100);
        this.setHoverDistanceLimit(-1);
    }

    void registerChart(ChartComponent chartComponent) {
        this.unregisterListener();
        this.chart = chartComponent;
        this.registerListener();
    }

    void unregisterChart(ChartComponent chartComponent) {
        this.unregisterListener();
        this.chart = null;
    }

    void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public final void setMoveMode(int n) {
        this.moveMode = n;
        if (this.selectionMode != this.moveMode) {
            this.setSelectionMode(this.moveMode);
        }
    }

    public final int getMoveMode() {
        return this.moveMode;
    }

    public final void setDragMode(int n) {
        this.dragMode = n;
    }

    public final int getDragMode() {
        return this.dragMode;
    }

    public final int getSelectionMode() {
        return this.selectionMode;
    }

    public final void setHoverMode(int n) {
        this.hoverMode = n;
        this.updateHighlightedItems();
    }

    public final int getHoverMode() {
        return this.hoverMode;
    }

    public final void setHoverDistanceLimit(int n) {
        this.hoverDistanceLimit = n;
    }

    public final int getHoverDistanceLimit() {
        return this.hoverDistanceLimit;
    }

    public final void setSelectionBounds(int n, int n2, int n3, int n4) {
        this.setSelectionBounds(new Rectangle(n, n2, n3, n4));
    }

    public void selectAll() {
        Rectangle rectangle = this.selectionBounds == null ? null : new Rectangle(this.selectionBounds);
        this.selectionBounds = new Rectangle(new Point(0, 0), this.chart.getSize());
        this.startIndex = 0;
        ChartItem chartItem = this.chart.getItemsModel().getItem(0);
        this.endIndex = ((XYItem)chartItem).getValuesCount() - 1;
        this.fireSelectionBoundsChanged(this.selectionBounds, rectangle);
    }

    public final void setSelectionBounds(Rectangle rectangle) {
        Rectangle rectangle2;
        if (rectangle == null && this.selectionBounds == null) {
            return;
        }
        this.normalizeBounds(rectangle);
        if (this.selectionBounds != null && this.selectionBounds.equals(rectangle) || rectangle != null && rectangle.equals(this.selectionBounds)) {
            return;
        }
        Rectangle rectangle3 = rectangle2 = this.selectionBounds == null ? null : new Rectangle(this.selectionBounds);
        if (rectangle == null) {
            this.selectionBounds = null;
        } else if (this.selectionBounds == null) {
            this.selectionBounds = new Rectangle(rectangle);
        } else {
            this.selectionBounds.setBounds(rectangle);
        }
        this.fireSelectionBoundsChanged(this.selectionBounds, rectangle2);
    }

    public final Rectangle getSelectionBounds() {
        return this.selectionBounds == null ? new Rectangle() : new Rectangle(this.selectionBounds);
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    private void normalizeBounds(Rectangle rectangle) {
        if (rectangle == null) {
            return;
        }
        ItemSelection itemSelection = this.getClosestSelection(rectangle.x, rectangle.y);
        if (!(itemSelection instanceof XYItemSelection)) {
            return;
        }
        ChartContext chartContext = this.chart.getChartContext();
        XYItemSelection xYItemSelection = (XYItemSelection)itemSelection;
        XYItem xYItem = xYItemSelection.getItem();
        this.endIndex = this.startIndex = xYItemSelection.getValueIndex();
        long l = xYItem.getXValue(this.startIndex);
        rectangle.x = Utils.checkedInt((double)chartContext.getViewX((double)l));
        if (rectangle.width == 0) {
            return;
        }
        itemSelection = this.getClosestSelection(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        if (!(itemSelection instanceof XYItemSelection)) {
            return;
        }
        xYItemSelection = (XYItemSelection)itemSelection;
        xYItem = xYItemSelection.getItem();
        this.endIndex = xYItemSelection.getValueIndex();
        l = xYItem.getXValue(this.endIndex);
        rectangle.width = Utils.checkedInt((double)chartContext.getViewX((double)l)) - rectangle.x;
    }

    public final void setHighlightedItems(List<ItemSelection> list) {
        if (this.highlightedSelection == null) {
            if (list.isEmpty()) {
                return;
            }
            this.highlightedSelection = new ArrayList<ItemSelection>(list);
            this.fireHighlightedItemsChanged(list, list, Collections.EMPTY_LIST);
        } else {
            ArrayList<ItemSelection> arrayList = new ArrayList<ItemSelection>();
            ArrayList<ItemSelection> arrayList2 = new ArrayList<ItemSelection>();
            for (ItemSelection itemSelection : list) {
                if (this.highlightedSelection.contains(itemSelection)) continue;
                arrayList.add(itemSelection);
            }
            for (ItemSelection itemSelection : this.highlightedSelection) {
                if (list.contains(itemSelection)) continue;
                arrayList2.add(itemSelection);
            }
            if (arrayList.isEmpty() && arrayList2.isEmpty()) {
                return;
            }
            this.highlightedSelection = new ArrayList<ItemSelection>(list);
            this.fireHighlightedItemsChanged(list, arrayList, arrayList2);
        }
    }

    public final List<ItemSelection> getHighlightedItems() {
        return this.highlightedSelection == null ? Collections.EMPTY_LIST : new ArrayList<ItemSelection>(this.highlightedSelection);
    }

    public final void setSelectedItems(List<ItemSelection> list) {
        if (this.selectedSelection == null) {
            if (list.isEmpty()) {
                return;
            }
            this.selectedSelection = new ArrayList<ItemSelection>(list);
            this.fireSelectedItemsChanged(list, list, Collections.EMPTY_LIST);
        } else {
            ArrayList<ItemSelection> arrayList = new ArrayList<ItemSelection>();
            ArrayList<ItemSelection> arrayList2 = new ArrayList<ItemSelection>();
            for (ItemSelection itemSelection : list) {
                if (this.selectedSelection.contains(itemSelection)) continue;
                arrayList.add(itemSelection);
            }
            for (ItemSelection itemSelection : this.selectedSelection) {
                if (list.contains(itemSelection)) continue;
                arrayList2.add(itemSelection);
            }
            if (arrayList.isEmpty() && arrayList2.isEmpty()) {
                return;
            }
            this.selectedSelection = new ArrayList<ItemSelection>(list);
            this.fireSelectedItemsChanged(list, arrayList, arrayList2);
        }
    }

    public final List<ItemSelection> getSelectedItems() {
        return this.selectedSelection == null ? Collections.EMPTY_LIST : new ArrayList<ItemSelection>(this.selectedSelection);
    }

    public final void addSelectionListener(ChartSelectionListener chartSelectionListener) {
        if (this.selectionListeners == null) {
            this.selectionListeners = new ArrayList<ChartSelectionListener>();
        }
        this.selectionListeners.add(chartSelectionListener);
    }

    public final void removeSelectionListener(ChartSelectionListener chartSelectionListener) {
        if (this.selectionListeners == null) {
            return;
        }
        this.selectionListeners.remove(chartSelectionListener);
    }

    private void setSelectionMode(int n) {
        if (this.selectionMode == n) {
            return;
        }
        int n2 = this.selectionMode;
        this.selectionMode = n;
        this.fireSelectionModeChanged(this.selectionMode, n2);
    }

    private void registerListener() {
        if (this.chart == null) {
            return;
        }
        this.chart.addMouseListener((java.awt.event.MouseListener)this.mouseListener);
        this.chart.addMouseMotionListener((MouseMotionListener)this.mouseListener);
        this.chart.addConfigurationListener((ChartConfigurationListener)this.chartListener);
    }

    private void unregisterListener() {
        if (this.chart == null) {
            return;
        }
        this.chart.removeMouseListener((java.awt.event.MouseListener)this.mouseListener);
        this.chart.removeMouseMotionListener((MouseMotionListener)this.mouseListener);
        this.chart.removeConfigurationListener((ChartConfigurationListener)this.chartListener);
    }

    private void updateHighlightedItems() {
        final int n = this.mouseX;
        final int n2 = this.mouseY;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (TimelineSelectionManager.this.hoverMode == 100 || !TimelineSelectionManager.this.inChart) {
                    TimelineSelectionManager.this.setHighlightedItems(Collections.EMPTY_LIST);
                    return;
                }
                ItemsModel itemsModel = TimelineSelectionManager.this.chart.getItemsModel();
                PaintersModel paintersModel = TimelineSelectionManager.this.chart.getPaintersModel();
                int n3 = itemsModel.getItemsCount();
                ArrayList<ItemSelection> arrayList = new ArrayList<ItemSelection>(n3);
                for (int i = 0; i < n3; ++i) {
                    ChartItem chartItem = itemsModel.getItem(i);
                    ItemPainter itemPainter = paintersModel.getPainter(chartItem);
                    ItemSelection itemSelection = itemPainter.getClosestSelection(chartItem, n, n2, TimelineSelectionManager.this.chart.getChartContext());
                    if (itemSelection == null) continue;
                    int n22 = itemSelection.getDistance();
                    if (TimelineSelectionManager.this.hoverMode == 102 || arrayList.isEmpty()) {
                        if (TimelineSelectionManager.this.hoverDistanceLimit != -1 && n22 > TimelineSelectionManager.this.hoverDistanceLimit) continue;
                        arrayList.add(itemSelection);
                        continue;
                    }
                    if (((ItemSelection)arrayList.get(0)).getDistance() <= n22 || TimelineSelectionManager.this.hoverDistanceLimit != -1 && n22 > TimelineSelectionManager.this.hoverDistanceLimit) continue;
                    arrayList.set(0, itemSelection);
                }
                TimelineSelectionManager.this.setHighlightedItems(arrayList);
            }
        });
    }

    private ItemSelection getClosestSelection(int n, int n2) {
        ItemPainter itemPainter;
        ChartItem chartItem;
        ItemsModel itemsModel = this.chart.getItemsModel();
        int n3 = itemsModel.getItemsCount();
        if (n3 == 0) {
            return null;
        }
        PaintersModel paintersModel = this.chart.getPaintersModel();
        for (int i = 0; i < n3; ++i) {
            chartItem = itemsModel.getItem(i);
            itemPainter = paintersModel.getPainter(chartItem);
            if (itemPainter instanceof TimelineIconPainter) continue;
            return itemPainter.getClosestSelection(chartItem, n, n2, this.chart.getChartContext());
        }
        chartItem = itemsModel.getItem(0);
        itemPainter = paintersModel.getPainter(chartItem);
        return itemPainter.getClosestSelection(chartItem, n, n2, this.chart.getChartContext());
    }

    private void fireSelectionModeChanged(int n, int n2) {
        if (this.selectionListeners == null) {
            return;
        }
        for (ChartSelectionListener chartSelectionListener : this.selectionListeners) {
            chartSelectionListener.selectionModeChanged(n, n2);
        }
    }

    private void fireSelectionBoundsChanged(Rectangle rectangle, Rectangle rectangle2) {
        if (this.selectionListeners == null) {
            return;
        }
        for (ChartSelectionListener chartSelectionListener : this.selectionListeners) {
            chartSelectionListener.selectionBoundsChanged(rectangle, rectangle2);
        }
    }

    private void fireHighlightedItemsChanged(List<ItemSelection> list, List<ItemSelection> list2, List<ItemSelection> list3) {
        if (this.selectionListeners == null) {
            return;
        }
        for (ChartSelectionListener chartSelectionListener : this.selectionListeners) {
            chartSelectionListener.highlightedItemsChanged(list, list2, list3);
        }
    }

    private void fireSelectedItemsChanged(List<ItemSelection> list, List<ItemSelection> list2, List<ItemSelection> list3) {
        if (this.selectionListeners == null) {
            return;
        }
        for (ChartSelectionListener chartSelectionListener : this.selectionListeners) {
            chartSelectionListener.selectedItemsChanged(list, list2, list3);
        }
    }

    private class MouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        private MouseListener() {
        }

        @Override
        public void mousePressed(final MouseEvent mouseEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!TimelineSelectionManager.this.enabled || !SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        return;
                    }
                    TimelineSelectionManager.this.mousePanningBackup = TimelineSelectionManager.this.chart.isMousePanningEnabled();
                    TimelineSelectionManager.this.setSelectionMode(TimelineSelectionManager.this.dragMode);
                    if (TimelineSelectionManager.this.selectionMode != 0) {
                        TimelineSelectionManager.this.chart.disableMousePanning();
                        TimelineSelectionManager.this.setSelectionBounds(null);
                        TimelineSelectionManager.this.setSelectionBounds(mouseEvent.getX(), mouseEvent.getY(), 0, 0);
                    }
                }
            });
        }

        @Override
        public void mouseReleased(final MouseEvent mouseEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!TimelineSelectionManager.this.enabled || !SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        return;
                    }
                    TimelineSelectionManager.this.setSelectionMode(TimelineSelectionManager.this.moveMode);
                    if (TimelineSelectionManager.this.selectionMode == 0) {
                        TimelineSelectionManager.this.chart.setMousePanningEnabled(TimelineSelectionManager.this.mousePanningBackup);
                    }
                }
            });
        }

        @Override
        public void mouseClicked(final MouseEvent mouseEvent) {
            if (!TimelineSelectionManager.this.enabled || !SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (TimelineSelectionManager.this.selectionMode != 0) {
                        TimelineSelectionManager.this.setSelectionBounds(mouseEvent.getX(), mouseEvent.getY(), 0, 0);
                    }
                }
            });
        }

        @Override
        public void mouseEntered(final MouseEvent mouseEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TimelineSelectionManager.this.inChart = true;
                    TimelineSelectionManager.this.mouseX = mouseEvent.getX();
                    TimelineSelectionManager.this.mouseY = mouseEvent.getY();
                }
            });
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TimelineSelectionManager.this.inChart = false;
                    TimelineSelectionManager.this.updateHighlightedItems();
                }
            });
        }

        @Override
        public void mouseDragged(final MouseEvent mouseEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!TimelineSelectionManager.this.enabled || !SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        return;
                    }
                    if (TimelineSelectionManager.this.selectionMode == 4) {
                        TimelineSelectionManager.this.setSelectionBounds(((TimelineSelectionManager)TimelineSelectionManager.this).selectionBounds.x, ((TimelineSelectionManager)TimelineSelectionManager.this).selectionBounds.y, mouseEvent.getX() - ((TimelineSelectionManager)TimelineSelectionManager.this).selectionBounds.x, mouseEvent.getY() - ((TimelineSelectionManager)TimelineSelectionManager.this).selectionBounds.y);
                    }
                }
            });
        }

        @Override
        public void mouseMoved(final MouseEvent mouseEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TimelineSelectionManager.this.mouseX = mouseEvent.getX();
                    TimelineSelectionManager.this.mouseY = mouseEvent.getY();
                    if (TimelineSelectionManager.this.selectionMode == 0) {
                        TimelineSelectionManager.this.setSelectionBounds(null);
                    }
                    TimelineSelectionManager.this.updateHighlightedItems();
                }
            });
        }
    }

    private class ChartListener
    extends ChartConfigurationListener.Adapter {
        private ChartListener() {
        }

        public void contentsWillBeUpdated(long l, long l2, double d, double d2, long l3, long l4, double d3, double d4) {
            TimelineSelectionManager.this.updateHighlightedItems();
        }
    }
}

