/*
 * Decompiled with CFR 0.152.
 */
package gnu.mail.providers.nntp;

import gnu.inet.nntp.ArticleResponse;
import gnu.inet.nntp.GroupResponse;
import gnu.inet.nntp.HeaderEntry;
import gnu.inet.nntp.HeaderIterator;
import gnu.inet.nntp.NNTPConnection;
import gnu.inet.nntp.NNTPException;
import gnu.mail.providers.nntp.NNTPMessage;
import gnu.mail.providers.nntp.NNTPStore;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.FolderNotFoundException;
import javax.mail.IllegalWriteException;
import javax.mail.Message;
import javax.mail.MessageRemovedException;
import javax.mail.MessagingException;
import javax.mail.MethodNotSupportedException;
import javax.mail.Store;

public final class NNTPFolder
extends Folder {
    String name;
    int first = -1;
    int last = -1;
    int count = -1;
    boolean open;
    Map articleCache;

    NNTPFolder(NNTPStore store, String name) {
        super((Store)store);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.name;
    }

    public Folder getParent() throws MessagingException {
        NNTPStore ns = (NNTPStore)this.store;
        return ns.root;
    }

    public int getType() throws MessagingException {
        return 1;
    }

    public boolean isOpen() {
        return this.open;
    }

    public int getMode() {
        return 1;
    }

    public Flags getPermanentFlags() {
        NNTPStore ns = (NNTPStore)this.store;
        return new Flags(ns.permanentFlags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(int mode) throws MessagingException {
        if (this.open) {
            throw new IllegalStateException();
        }
        try {
            NNTPStore ns = (NNTPStore)this.store;
            NNTPConnection nNTPConnection = ns.connection;
            synchronized (nNTPConnection) {
                GroupResponse response = ns.connection.group(this.name);
                this.count = response.count;
                this.first = response.first;
                this.last = response.last;
            }
            this.articleCache = new HashMap(1024);
            this.open = true;
            this.notifyConnectionListeners(1);
        }
        catch (NNTPException e) {
            if (e.getResponse().getStatus() == 411) {
                throw new FolderNotFoundException(e.getMessage(), (Folder)this);
            }
            throw new MessagingException(e.getMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MessagingException(e.getMessage(), (Exception)e);
        }
    }

    public void close(boolean expunge) throws MessagingException {
        if (!this.open) {
            throw new IllegalStateException();
        }
        this.articleCache = null;
        this.open = false;
        this.notifyConnectionListeners(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists() throws MessagingException {
        try {
            NNTPStore ns = (NNTPStore)this.store;
            NNTPConnection nNTPConnection = ns.connection;
            synchronized (nNTPConnection) {
                GroupResponse response = ns.connection.group(this.name);
                this.count = response.count;
                this.first = response.first;
                this.last = response.last;
            }
            return true;
        }
        catch (NNTPException e) {
            if (e.getResponse().getStatus() == 411) {
                return false;
            }
            throw new MessagingException(e.getMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MessagingException(e.getMessage(), (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNewMessages() throws MessagingException {
        try {
            NNTPStore ns = (NNTPStore)this.store;
            boolean hasNew = false;
            NNTPConnection nNTPConnection = ns.connection;
            synchronized (nNTPConnection) {
                GroupResponse response = ns.connection.group(this.name);
                if (response.last > this.last) {
                    hasNew = true;
                }
                this.count = response.count;
                this.first = response.first;
                this.last = response.last;
            }
            return hasNew;
        }
        catch (NNTPException e) {
            if (e.getResponse().getStatus() == 411) {
                throw new FolderNotFoundException(e.getMessage(), (Folder)this);
            }
            throw new MessagingException(e.getMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MessagingException(e.getMessage(), (Exception)e);
        }
    }

    public int getMessageCount() throws MessagingException {
        return this.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message getMessage(int msgnum) throws MessagingException {
        if (!this.open) {
            throw new IllegalStateException();
        }
        Integer key = new Integer(msgnum);
        NNTPMessage m = (NNTPMessage)((Object)this.articleCache.get(key));
        if (m != null) {
            return m;
        }
        try {
            NNTPStore ns = (NNTPStore)this.store;
            NNTPConnection nNTPConnection = ns.connection;
            synchronized (nNTPConnection) {
                GroupResponse gr = ns.connection.group(this.name);
                this.first = gr.first;
                this.last = gr.last;
                this.count = gr.count;
                m = this.getMessageImpl(msgnum - 1 + this.first);
                this.articleCache.put(key, m);
                return m;
            }
        }
        catch (NNTPException e) {
            switch (e.getResponse().getStatus()) {
                case 420: 
                case 423: 
                case 430: {
                    throw new MessageRemovedException(e.getMessage());
                }
            }
            throw new MessagingException(e.getMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MessagingException(e.getMessage(), (Exception)e);
        }
    }

    NNTPMessage getMessageImpl(int msgnum) throws IOException {
        NNTPStore ns = (NNTPStore)this.store;
        ArticleResponse response = ns.connection.stat(msgnum);
        String messageId = response.messageId;
        return new NNTPMessage(this, msgnum, messageId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message[] getMessages() throws MessagingException {
        NNTPStore ns = (NNTPStore)this.store;
        LinkedList<NNTPMessage> acc = new LinkedList<NNTPMessage>();
        NNTPConnection nNTPConnection = ns.connection;
        synchronized (nNTPConnection) {
            try {
                GroupResponse gr = ns.connection.group(this.name);
                this.first = gr.first;
                this.last = gr.last;
                this.count = gr.count;
                StringBuffer rb = new StringBuffer();
                rb.append(Integer.toString(this.first));
                rb.append('-');
                rb.append(Integer.toString(this.last));
                HeaderIterator i = ns.connection.xhdr("Message-ID", rb.toString());
                while (i.hasNext()) {
                    HeaderEntry entry = i.nextHeaderEntry();
                    Integer key = new Integer(entry.getArticleId());
                    NNTPMessage m = (NNTPMessage)((Object)this.articleCache.get(key));
                    if (m == null) {
                        int msgnum = key;
                        String messageId = entry.getHeader();
                        m = new NNTPMessage(this, msgnum, messageId);
                        this.articleCache.put(key, m);
                    }
                    acc.add(m);
                }
            }
            catch (NNTPException e) {
                for (int i = this.first; i <= this.last; ++i) {
                    Integer key = new Integer(i);
                    NNTPMessage m = (NNTPMessage)((Object)this.articleCache.get(key));
                    if (m != null) continue;
                    try {
                        m = this.getMessageImpl(i);
                        this.articleCache.put(key, m);
                        acc.add(m);
                        continue;
                    }
                    catch (NNTPException e2) {
                        switch (e2.getResponse().getStatus()) {
                            case 420: 
                            case 423: 
                            case 430: {
                                break;
                            }
                            default: {
                                throw new MessagingException(e2.getMessage(), (Exception)((Object)e2));
                            }
                        }
                        continue;
                    }
                    catch (IOException ie) {
                        throw new MessagingException(ie.getMessage(), (Exception)ie);
                    }
                }
            }
            catch (IOException e) {
                throw new MessagingException(e.getMessage(), (Exception)e);
            }
        }
        int len = acc.size();
        Message[] messages = new Message[len];
        acc.toArray(messages);
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetch(Message[] msgs, FetchProfile fp) throws MessagingException {
        boolean head = fp.contains(FetchProfile.Item.ENVELOPE);
        head = head || fp.getHeaderNames().length > 0;
        boolean body = fp.contains(FetchProfile.Item.CONTENT_INFO);
        int op = head && body ? 3 : (head ? 2 : (body ? 1 : 0));
        try {
            NNTPStore ns = (NNTPStore)this.store;
            for (int i = 0; i < msgs.length; ++i) {
                Message msg = msgs[i];
                if (msg == null || !(msg instanceof NNTPMessage)) continue;
                NNTPMessage message = (NNTPMessage)msg;
                String messageId = message.getMessageId();
                ArticleResponse response = null;
                NNTPConnection nNTPConnection = ns.connection;
                synchronized (nNTPConnection) {
                    switch (op) {
                        case 3: {
                            response = ns.connection.article(messageId);
                            break;
                        }
                        case 2: {
                            response = ns.connection.head(messageId);
                            break;
                        }
                        case 1: {
                            response = ns.connection.body(messageId);
                        }
                    }
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    byte[] buf = new byte[4096];
                    int len = response.in.read(buf);
                    while (len > -1) {
                        out.write(buf, 0, len);
                        len = response.in.read(buf);
                    }
                    switch (op) {
                        case 3: {
                            ByteArrayInputStream hbin = new ByteArrayInputStream(out.toByteArray());
                            message.updateHeaders(hbin);
                            int len2 = hbin.available();
                            byte[] content = new byte[len2];
                            hbin.read(content);
                            message.updateContent(content);
                            break;
                        }
                        case 2: {
                            ByteArrayInputStream hin = new ByteArrayInputStream(out.toByteArray());
                            message.updateHeaders(hin);
                            break;
                        }
                        case 1: {
                            message.updateContent(out.toByteArray());
                        }
                    }
                    continue;
                }
            }
        }
        catch (NNTPException e) {
            switch (e.getResponse().getStatus()) {
                case 412: {
                    throw new IllegalStateException(e.getMessage());
                }
                case 420: 
                case 423: 
                case 430: {
                    throw new MessageRemovedException(e.getMessage());
                }
            }
            throw new MessagingException(e.getMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MessagingException(e.getMessage(), (Exception)e);
        }
    }

    public boolean isSubscribed() {
        NNTPStore ns = (NNTPStore)this.store;
        return ns.newsrc.isSubscribed(this.name);
    }

    public void setSubscribed(boolean flag) throws MessagingException {
        NNTPStore ns = (NNTPStore)this.store;
        ns.newsrc.setSubscribed(this.name, flag);
    }

    boolean isSeen(int articleNumber) {
        NNTPStore ns = (NNTPStore)this.store;
        return ns.newsrc.isSeen(this.name, articleNumber);
    }

    void setSeen(int articleNumber, boolean flag) {
        NNTPStore ns = (NNTPStore)this.store;
        ns.newsrc.setSeen(this.name, articleNumber, flag);
    }

    public Folder getFolder(String name) throws MessagingException {
        throw new MethodNotSupportedException();
    }

    public Folder[] list(String pattern) throws MessagingException {
        throw new MethodNotSupportedException();
    }

    public Folder[] listSubscribed(String pattern) throws MessagingException {
        return this.list(pattern);
    }

    public char getSeparator() throws MessagingException {
        return '.';
    }

    public boolean create(int type) throws MessagingException {
        throw new MethodNotSupportedException();
    }

    public boolean delete(boolean recurse) throws MessagingException {
        throw new MethodNotSupportedException();
    }

    public boolean renameTo(Folder folder) throws MessagingException {
        throw new MethodNotSupportedException();
    }

    public void appendMessages(Message[] messages) throws MessagingException {
        throw new IllegalWriteException();
    }

    public Message[] expunge() throws MessagingException {
        throw new IllegalWriteException();
    }
}

