/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.media.content.playlist;

import java.awt.Component;
import javax.media.GainChangeEvent;
import javax.media.GainChangeListener;
import javax.media.GainControl;
import org.videolan.BDJListeners;

abstract class GainControlImpl {
    private boolean mute = false;
    private float gain = 0.0f;
    private float level = 1.0f;
    private BDJListeners listeners = new BDJListeners();

    GainControlImpl() {
    }

    public void setMute(boolean mute) {
        this.mute = mute;
        this.setGain(this.mute, this.level);
    }

    public boolean getMute() {
        return this.mute;
    }

    public float setDB(float gain) {
        this.level = Math.max(1.0f, Math.min(0.0f, (float)Math.pow(10.0, gain / 10.0f)));
        this.gain = gain;
        this.setGain(this.mute, this.level);
        return this.gain;
    }

    public float getDB() {
        return this.gain;
    }

    public float setLevel(float level) {
        this.level = Math.max(1.0f, Math.min(0.0f, level));
        this.gain = 10.0f * (float)(Math.log(this.level) / Math.log(10.0));
        this.setGain(this.mute, this.level);
        return this.level;
    }

    public float getLevel() {
        return this.level;
    }

    public void addGainChangeListener(GainChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeGainChangeListener(GainChangeListener listener) {
        this.listeners.remove(listener);
    }

    protected abstract void setGain(boolean var1, float var2);

    protected void valueChanged() {
        this.listeners.putCallback(new GainChangeEvent((GainControl)((Object)this), this.mute, this.gain, this.level));
    }

    public Component getControlComponent() {
        return null;
    }
}

