/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.openstreetmap.gui.jmapviewer.FeatureAdapter;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.OpenFileAction;
import org.openstreetmap.josm.actions.OpenLocationAction;
import org.openstreetmap.josm.actions.downloadtasks.AbstractDownloadTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadGpsTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.downloadtasks.PostDownloadHandler;
import org.openstreetmap.josm.actions.mapmode.DrawAction;
import org.openstreetmap.josm.actions.search.SearchAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.ViewportData;
import org.openstreetmap.josm.data.cache.JCSCacheManager;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionChangeListener;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.gui.GettingStarted;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MainPanel;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapFrameListener;
import org.openstreetmap.josm.gui.io.SaveLayersDialog;
import org.openstreetmap.josm.gui.layer.AbstractModifiableLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.preferences.ToolbarPreferences;
import org.openstreetmap.josm.gui.preferences.imagery.ImageryPreference;
import org.openstreetmap.josm.gui.preferences.map.MapPaintPreference;
import org.openstreetmap.josm.gui.preferences.projection.ProjectionPreference;
import org.openstreetmap.josm.gui.progress.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitorExecutor;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresets;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.RedirectInputMap;
import org.openstreetmap.josm.io.FileWatcher;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmApiInitializationException;
import org.openstreetmap.josm.io.OsmTransferCanceledException;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.OsmUrlToBounds;
import org.openstreetmap.josm.tools.PlatformHook;
import org.openstreetmap.josm.tools.PlatformHookOsx;
import org.openstreetmap.josm.tools.PlatformHookUnixoid;
import org.openstreetmap.josm.tools.PlatformHookWindows;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public abstract class Main {
    private static final String JOSM_WEBSITE = "https://josm.openstreetmap.de";
    private static final String OSM_WEBSITE = "https://www.openstreetmap.org";
    public static Component parent;
    public static volatile Main main;
    protected static final List<String> COMMAND_LINE_ARGS;
    public static final ExecutorService worker;
    public static Preferences pref;
    public static MapFrame map;
    private static final MainLayerManager layerManager;
    public static volatile ToolbarPreferences toolbar;
    public final UndoRedoHandler undoRedo = new UndoRedoHandler();
    public static PleaseWaitProgressMonitor currentProgressMonitor;
    public MainMenu menu;
    public static final FileWatcher fileWatcher;
    @Deprecated
    public final GettingStarted gettingStarted = mainPanel.getGettingStarted();
    protected static final Map<String, Throwable> NETWORK_ERRORS;
    private static final List<String> ERRORS_AND_WARNINGS;
    private static final Set<OnlineResource> OFFLINE_RESOURCES;
    public static int logLevel;
    protected static final MainPanel mainPanel;
    public static volatile PlatformHook platform;
    public static boolean isOpenjdk;
    private static volatile InitStatusListener initListener;
    protected static final JPanel contentPanePrivate;
    public static final JPanel panel;
    private final OsmDataLayer.CommandQueueListener redoUndoListener = (n, n2) -> {
        this.menu.undo.setEnabled(n > 0);
        this.menu.redo.setEnabled(n2 > 0);
    };
    private static volatile Projection proj;
    private static final List<WeakReference<ProjectionChangeListener>> listeners;
    private static final List<WeakReference<WindowSwitchListener>> windowSwitchListeners;

    public static boolean isDisplayingMapView() {
        return map != null && Main.map.mapView != null;
    }

    private static void rememberWarnErrorMsg(String string) {
        int n = string.indexOf(10);
        if (n > 0) {
            ERRORS_AND_WARNINGS.add(string.substring(0, n));
        } else {
            ERRORS_AND_WARNINGS.add(string);
        }
        while (ERRORS_AND_WARNINGS.size() > 10) {
            ERRORS_AND_WARNINGS.remove(0);
        }
    }

    public static final Collection<String> getLastErrorAndWarnings() {
        return Collections.unmodifiableList(ERRORS_AND_WARNINGS);
    }

    public static void clearLastErrorAndWarnings() {
        ERRORS_AND_WARNINGS.clear();
    }

    public static void error(String string) {
        if (logLevel < 1) {
            return;
        }
        if (string != null && !string.isEmpty()) {
            System.err.println(I18n.tr("ERROR: {0}", string));
            Main.rememberWarnErrorMsg("E: " + string);
        }
    }

    public static void warn(String string) {
        if (logLevel < 2) {
            return;
        }
        if (string != null && !string.isEmpty()) {
            System.err.println(I18n.tr("WARNING: {0}", string));
            Main.rememberWarnErrorMsg("W: " + string);
        }
    }

    public static void info(String string) {
        if (logLevel < 3) {
            return;
        }
        if (string != null && !string.isEmpty()) {
            System.out.println(I18n.tr("INFO: {0}", string));
        }
    }

    public static void debug(String string) {
        if (logLevel < 4) {
            return;
        }
        if (string != null && !string.isEmpty()) {
            System.out.println(I18n.tr("DEBUG: {0}", string));
        }
    }

    public static void trace(String string) {
        if (logLevel < 5) {
            return;
        }
        if (string != null && !string.isEmpty()) {
            System.out.print("TRACE: ");
            System.out.println(string);
        }
    }

    public static boolean isDebugEnabled() {
        return logLevel >= 4;
    }

    public static boolean isTraceEnabled() {
        return logLevel >= 5;
    }

    public static void error(String string, Object ... objectArray) {
        Main.error(MessageFormat.format(string, objectArray));
    }

    public static void warn(String string, Object ... objectArray) {
        Main.warn(MessageFormat.format(string, objectArray));
    }

    public static void info(String string, Object ... objectArray) {
        Main.info(MessageFormat.format(string, objectArray));
    }

    public static void debug(String string, Object ... objectArray) {
        Main.debug(MessageFormat.format(string, objectArray));
    }

    public static void trace(String string, Object ... objectArray) {
        Main.trace(MessageFormat.format(string, objectArray));
    }

    public static void error(Throwable throwable) {
        Main.error(throwable, true);
    }

    public static void warn(Throwable throwable) {
        Main.warn(throwable, true);
    }

    public static void debug(Throwable throwable) {
        Main.debug(Main.getErrorMessage(throwable));
    }

    public static void trace(Throwable throwable) {
        Main.trace(Main.getErrorMessage(throwable));
    }

    public static void error(Throwable throwable, boolean bl) {
        Main.error(Main.getErrorMessage(throwable));
        if (bl) {
            throwable.printStackTrace();
        }
    }

    public static void error(Throwable throwable, String string) {
        Main.warn(string + ' ' + Main.getErrorMessage(throwable));
    }

    public static void warn(Throwable throwable, boolean bl) {
        Main.warn(Main.getErrorMessage(throwable));
        if (bl) {
            throwable.printStackTrace();
        }
    }

    public static void warn(Throwable throwable, String string) {
        Main.warn(string + ' ' + Main.getErrorMessage(throwable));
    }

    public static String getErrorMessage(Throwable throwable) {
        Throwable throwable2;
        if (throwable == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(throwable.getClass().getName());
        String string = throwable.getMessage();
        if (string != null) {
            stringBuilder.append(": ").append(string.trim());
        }
        if ((throwable2 = throwable.getCause()) != null && !throwable2.equals(throwable)) {
            stringBuilder.append(". ").append(I18n.tr("Cause: ", new Object[0])).append(Main.getErrorMessage(throwable2));
        }
        return stringBuilder.toString();
    }

    public static void initApplicationPreferences() {
        pref = new Preferences();
    }

    @Deprecated
    public final void setMapFrame(MapFrame mapFrame) {
        Main.warn("setMapFrame call was ignored.");
    }

    @Deprecated
    public final synchronized void removeLayer(Layer layer) {
        if (map != null) {
            Main.getLayerManager().removeLayer(layer);
        }
    }

    public static void setInitStatusListener(InitStatusListener initStatusListener) {
        CheckParameterUtil.ensureParameterNotNull(initStatusListener);
        initListener = initStatusListener;
    }

    public Main() {
        main = this;
        mainPanel.addMapFrameListener((mapFrame, mapFrame2) -> this.redoUndoListener.commandChanged(0, 0));
    }

    public void initialize() {
        isOpenjdk = System.getProperty("java.vm.name").toUpperCase(Locale.ENGLISH).indexOf("OPENJDK") != -1;
        fileWatcher.start();
        new InitializationTask(I18n.tr("Executing platform startup hook", new Object[0])){

            @Override
            public void initialize() {
                platform.startupHook();
            }
        }.call();
        new InitializationTask(I18n.tr("Building main menu", new Object[0])){

            @Override
            public void initialize() {
                Main.this.initializeMainWindow();
            }
        }.call();
        this.undoRedo.addCommandQueueListener(this.redoUndoListener);
        contentPanePrivate.add((Component)Main.toolbar.control, "North");
        Main.registerActionShortcut(this.menu.help, Shortcut.registerShortcut("system:help", I18n.tr("Help", new Object[0]), 112, 5003));
        ArrayList<InitializationTask> arrayList = new ArrayList<InitializationTask>();
        arrayList.add(new InitializationTask(I18n.tr("Initializing OSM API", new Object[0])){

            @Override
            public void initialize() {
                try {
                    OsmApi.getOsmApi().initialize(null, true);
                }
                catch (OsmApiInitializationException | OsmTransferCanceledException osmTransferException) {
                    Main.warn(Main.getErrorMessage(Utils.getRootCause(osmTransferException)));
                }
            }
        });
        arrayList.add(new InitializationTask(I18n.tr("Initializing validator", new Object[0])){

            @Override
            public void initialize() {
                OsmValidator.initialize();
            }
        });
        arrayList.add(new InitializationTask(I18n.tr("Initializing presets", new Object[0])){

            @Override
            public void initialize() {
                TaggingPresets.initialize();
            }
        });
        arrayList.add(new InitializationTask(I18n.tr("Initializing map styles", new Object[0])){

            @Override
            public void initialize() {
                MapPaintPreference.initialize();
            }
        });
        arrayList.add(new InitializationTask(I18n.tr("Loading imagery preferences", new Object[0])){

            @Override
            public void initialize() {
                ImageryPreference.initialize();
            }
        });
        try {
            ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), Utils.newThreadFactory("main-init-%d", 5));
            for (Future future : executorService.invokeAll(arrayList)) {
                future.get();
            }
            executorService.shutdown();
        }
        catch (InterruptedException | ExecutionException exception) {
            throw new RuntimeException(exception);
        }
        FeatureAdapter.registerBrowserAdapter(OpenBrowser::displayUrl);
        FeatureAdapter.registerTranslationAdapter(I18n.getTranslationAdapter());
        FeatureAdapter.registerLoggingAdapter(string -> {
            Logger logger = Logger.getAnonymousLogger();
            logger.setUseParentHandlers(false);
            logger.setLevel(Level.ALL);
            if (logger.getHandlers().length == 0) {
                logger.addHandler(new Handler(){

                    @Override
                    public void publish(LogRecord logRecord) {
                        String string = MessageFormat.format(logRecord.getMessage(), logRecord.getParameters());
                        if (logRecord.getLevel().intValue() >= Level.SEVERE.intValue()) {
                            Main.error(string);
                        } else if (logRecord.getLevel().intValue() >= Level.WARNING.intValue()) {
                            Main.warn(string);
                        } else if (logRecord.getLevel().intValue() >= Level.INFO.intValue()) {
                            Main.info(string);
                        } else if (logRecord.getLevel().intValue() >= Level.FINE.intValue()) {
                            Main.debug(string);
                        } else {
                            Main.trace(string);
                        }
                    }

                    @Override
                    public void flush() {
                    }

                    @Override
                    public void close() {
                    }
                });
            }
            return logger;
        });
        new InitializationTask(I18n.tr("Updating user interface", new Object[0])){

            @Override
            public void initialize() {
                toolbar.refreshToolbarControl();
                Main.toolbar.control.updateUI();
                contentPanePrivate.updateUI();
            }
        }.call();
    }

    protected void initializeMainWindow() {
    }

    public static MainLayerManager getLayerManager() {
        return layerManager;
    }

    @Deprecated
    public final void addLayer(Layer layer) {
        this.addLayer(layer, (ViewportData)null);
    }

    public final void addLayer(Layer layer, ProjectionBounds projectionBounds) {
        this.addLayer(layer, projectionBounds == null ? null : new ViewportData(projectionBounds));
    }

    public final void addLayer(Layer layer, ViewportData viewportData) {
        Main.getLayerManager().addLayer(layer);
        if (viewportData != null && Main.map.mapView != null) {
            Main.map.mapView.scheduleZoomTo(viewportData);
        }
    }

    @Deprecated
    public synchronized void createMapFrame(Layer layer, ViewportData viewportData) {
        GuiHelper.assertCallFromEdt();
        Main.error("createMapFrame() not supported any more.");
    }

    @Deprecated
    public boolean hasEditLayer() {
        return this.getEditLayer() != null;
    }

    @Deprecated
    public OsmDataLayer getEditLayer() {
        return Main.getLayerManager().getEditLayer();
    }

    @Deprecated
    public DataSet getCurrentDataSet() {
        return Main.getLayerManager().getEditDataSet();
    }

    public Collection<OsmPrimitive> getInProgressSelection() {
        if (map != null && Main.map.mapMode instanceof DrawAction) {
            return ((DrawAction)Main.map.mapMode).getInProgressSelection();
        }
        DataSet dataSet = Main.getLayerManager().getEditDataSet();
        if (dataSet == null) {
            return null;
        }
        return dataSet.getSelected();
    }

    @Deprecated
    public Layer getActiveLayer() {
        return Main.getLayerManager().getActiveLayer();
    }

    public static void redirectToMainContentPane(JComponent jComponent) {
        RedirectInputMap.redirect(jComponent, contentPanePrivate);
    }

    public static void registerActionShortcut(JosmAction josmAction) {
        Main.registerActionShortcut(josmAction, josmAction.getShortcut());
    }

    public static void registerActionShortcut(Action action, Shortcut shortcut) {
        KeyStroke keyStroke = shortcut.getKeyStroke();
        if (keyStroke == null) {
            return;
        }
        InputMap inputMap = contentPanePrivate.getInputMap(2);
        Object object = inputMap.get(keyStroke);
        if (object != null && !object.equals(action)) {
            Main.info(String.format("Keystroke %s is already assigned to %s, will be overridden by %s", keyStroke, object, action));
        }
        inputMap.put(keyStroke, action);
        contentPanePrivate.getActionMap().put(action, action);
    }

    public static void unregisterShortcut(Shortcut shortcut) {
        contentPanePrivate.getInputMap(2).remove(shortcut.getKeyStroke());
    }

    public static void unregisterActionShortcut(JosmAction josmAction) {
        Main.unregisterActionShortcut(josmAction, josmAction.getShortcut());
    }

    public static void unregisterActionShortcut(Action action, Shortcut shortcut) {
        Main.unregisterShortcut(shortcut);
        contentPanePrivate.getActionMap().remove(action);
    }

    public static Action getRegisteredActionShortcut(Shortcut shortcut) {
        KeyStroke keyStroke = shortcut.getKeyStroke();
        if (keyStroke == null) {
            return null;
        }
        Object object = contentPanePrivate.getInputMap(2).get(keyStroke);
        if (object instanceof Action) {
            return (Action)object;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static void preConstructorInit(Map<MainApplication.Option, Collection<String>> map) {
        ProjectionPreference.setProjection();
        String string = platform.getDefaultStyle();
        String string2 = pref.get("laf", string);
        try {
            UIManager.setLookAndFeel(string2);
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
            void var4_10;
            Main.trace(throwable);
            Object object = null;
            for (ClassLoader classLoader : PluginHandler.getResourceClassLoaders()) {
                try {
                    Class<?> clazz = classLoader.loadClass(string2);
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Main.trace(classNotFoundException);
                }
            }
            if (var4_10 != null && LookAndFeel.class.isAssignableFrom((Class<?>)var4_10)) {
                try {
                    UIManager.setLookAndFeel((LookAndFeel)var4_10.getConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    Main.warn((Throwable)reflectiveOperationException, "Cannot set Look and Feel: " + string2 + ": " + reflectiveOperationException.getMessage());
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    Main.info("Look and Feel not supported: " + string2);
                    pref.put("laf", string);
                    Main.trace(unsupportedLookAndFeelException);
                }
            } else {
                Main.info("Look and Feel not found: " + string2);
                pref.put("laf", string);
            }
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            Main.info("Look and Feel not supported: " + string2);
            pref.put("laf", string);
            Main.trace(unsupportedLookAndFeelException);
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            Main.error(reflectiveOperationException);
        }
        toolbar = new ToolbarPreferences();
        contentPanePrivate.updateUI();
        panel.updateUI();
        UIManager.put("OptionPane.okIcon", ImageProvider.get("ok"));
        UIManager.put("OptionPane.yesIcon", UIManager.get("OptionPane.okIcon"));
        UIManager.put("OptionPane.cancelIcon", ImageProvider.get("cancel"));
        UIManager.put("OptionPane.noIcon", UIManager.get("OptionPane.cancelIcon"));
        for (String string3 : Arrays.asList("EditorPane", "FormattedTextField", "PasswordField", "TextArea", "TextField", "TextPane")) {
            UIManager.put(string3 + ".caretForeground", UIManager.getColor(string3 + ".foreground"));
        }
        I18n.translateJavaInternalMessages();
        try {
            CoordinateFormat.setCoordinateFormat(CoordinateFormat.valueOf(pref.get("coordinates")));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Main.trace(illegalArgumentException);
            CoordinateFormat.setCoordinateFormat(CoordinateFormat.DECIMAL_DEGREES);
        }
    }

    protected static void postConstructorProcessCmdLine(Map<MainApplication.Option, Collection<String>> map) {
        if (map.containsKey((Object)MainApplication.Option.DOWNLOAD)) {
            Iterator<String> iterator = new ArrayList();
            for (String string : map.get((Object)MainApplication.Option.DOWNLOAD)) {
                DownloadParamType.paramType(string).download(string, (Collection<File>)((Object)iterator));
            }
            if (!iterator.isEmpty()) {
                OpenFileAction.openFiles(iterator, true);
            }
        }
        if (map.containsKey((Object)MainApplication.Option.DOWNLOADGPS)) {
            for (String string : map.get((Object)MainApplication.Option.DOWNLOADGPS)) {
                DownloadParamType.paramType(string).downloadGps(string);
            }
        }
        if (map.containsKey((Object)MainApplication.Option.SELECTION)) {
            for (String string : map.get((Object)MainApplication.Option.SELECTION)) {
                SearchAction.search(string, SearchAction.SearchMode.add);
            }
        }
    }

    public static boolean saveUnsavedModifications() {
        if (!Main.isDisplayingMapView()) {
            return true;
        }
        return Main.saveUnsavedModifications(Main.getLayerManager().getLayersOfType(AbstractModifiableLayer.class), true);
    }

    public static boolean saveUnsavedModifications(Iterable<? extends Layer> iterable, boolean bl) {
        SaveLayersDialog saveLayersDialog = new SaveLayersDialog(parent);
        ArrayList<AbstractModifiableLayer> arrayList = new ArrayList<AbstractModifiableLayer>();
        for (Layer layer : iterable) {
            AbstractModifiableLayer abstractModifiableLayer;
            if (!(layer instanceof AbstractModifiableLayer) || !(abstractModifiableLayer = (AbstractModifiableLayer)layer).isModified() || (abstractModifiableLayer.isSavable() || abstractModifiableLayer.isUploadable()) && !abstractModifiableLayer.requiresSaveToFile() && (!abstractModifiableLayer.requiresUploadToServer() || abstractModifiableLayer.isUploadDiscouraged())) continue;
            arrayList.add(abstractModifiableLayer);
        }
        if (bl) {
            saveLayersDialog.prepareForSavingAndUpdatingLayersBeforeExit();
        } else {
            saveLayersDialog.prepareForSavingAndUpdatingLayersBeforeDelete();
        }
        if (!arrayList.isEmpty()) {
            saveLayersDialog.getModel().populate(arrayList);
            saveLayersDialog.setVisible(true);
            switch (saveLayersDialog.getUserAction()) {
                case PROCEED: {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public static boolean exitJosm(boolean bl, int n) {
        if (Main.saveUnsavedModifications()) {
            if (main != null) {
                main.shutdown();
            }
            if (bl) {
                System.exit(n);
            }
            return true;
        }
        return false;
    }

    protected void shutdown() {
        worker.shutdown();
        ImageProvider.shutdown(false);
        JCSCacheManager.shutdown();
        if (map != null) {
            map.rememberToggleDialogWidth();
        }
        Main.getLayerManager().resetState();
        try {
            pref.saveDefaults();
        }
        catch (IOException iOException) {
            Main.warn((Throwable)iOException, I18n.tr("Failed to save default preferences.", new Object[0]));
        }
        worker.shutdownNow();
        ImageProvider.shutdown(true);
    }

    private static void downloadFromParamBounds(boolean bl, Bounds bounds) {
        AbstractDownloadTask abstractDownloadTask = bl ? new DownloadGpsTask() : new DownloadOsmTask();
        Future<?> future = abstractDownloadTask.download(true, bounds, null);
        worker.execute(new PostDownloadHandler(abstractDownloadTask, future));
    }

    public static void determinePlatformHook() {
        String string = System.getProperty("os.name");
        if (string == null) {
            Main.warn("Your operating system has no name, so I'm guessing its some kind of *nix.");
            platform = new PlatformHookUnixoid();
        } else if (string.toLowerCase(Locale.ENGLISH).startsWith("windows")) {
            platform = new PlatformHookWindows();
        } else if ("Linux".equals(string) || "Solaris".equals(string) || "SunOS".equals(string) || "AIX".equals(string) || "FreeBSD".equals(string) || "NetBSD".equals(string) || "OpenBSD".equals(string)) {
            platform = new PlatformHookUnixoid();
        } else if (string.toLowerCase(Locale.ENGLISH).startsWith("mac os x")) {
            platform = new PlatformHookOsx();
        } else {
            Main.warn("I don't know your operating system '" + string + "', so I'm guessing its some kind of *nix.");
            platform = new PlatformHookUnixoid();
        }
    }

    public static Projection getProjection() {
        return proj;
    }

    public static void setProjection(Projection projection) {
        CheckParameterUtil.ensureParameterNotNull(projection);
        Projection projection2 = proj;
        Bounds bounds = Main.isDisplayingMapView() ? Main.map.mapView.getRealBounds() : null;
        proj = projection;
        Main.fireProjectionChanged(projection2, proj, bounds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void fireProjectionChanged(Projection projection, Projection projection2, Bounds bounds) {
        if (!(projection2 == null ^ projection == null) && (projection2 == null || projection == null || Objects.equals(projection2.toCode(), projection.toCode()))) return;
        if (map != null) {
            Main.map.mapView.fixProjection();
        }
        Class<Main> clazz = Main.class;
        synchronized (Main.class) {
            Iterator<WeakReference<ProjectionChangeListener>> iterator = listeners.iterator();
            while (iterator.hasNext()) {
                WeakReference<ProjectionChangeListener> weakReference = iterator.next();
                ProjectionChangeListener projectionChangeListener = (ProjectionChangeListener)weakReference.get();
                if (projectionChangeListener == null) {
                    iterator.remove();
                    continue;
                }
                projectionChangeListener.projectionChanged(projection, projection2);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (projection2 == null || bounds == null) return;
            Main.map.mapView.zoomTo(bounds);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addProjectionChangeListener(ProjectionChangeListener projectionChangeListener) {
        if (projectionChangeListener == null) {
            return;
        }
        Class<Main> clazz = Main.class;
        synchronized (Main.class) {
            for (WeakReference<ProjectionChangeListener> weakReference : listeners) {
                if (weakReference.get() != projectionChangeListener) continue;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            listeners.add(new WeakReference<ProjectionChangeListener>(projectionChangeListener));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeProjectionChangeListener(ProjectionChangeListener projectionChangeListener) {
        if (projectionChangeListener == null) {
            return;
        }
        Class<Main> clazz = Main.class;
        synchronized (Main.class) {
            Iterator<WeakReference<ProjectionChangeListener>> iterator = listeners.iterator();
            while (iterator.hasNext()) {
                WeakReference<ProjectionChangeListener> weakReference = iterator.next();
                if (weakReference.get() != null && weakReference.get() != projectionChangeListener) continue;
                iterator.remove();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addWindowSwitchListener(WindowSwitchListener windowSwitchListener) {
        if (windowSwitchListener == null) {
            return;
        }
        Class<Main> clazz = Main.class;
        synchronized (Main.class) {
            for (WeakReference<WindowSwitchListener> weakReference : windowSwitchListeners) {
                if (weakReference.get() != windowSwitchListener) continue;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            boolean bl = windowSwitchListeners.isEmpty();
            windowSwitchListeners.add(new WeakReference<WindowSwitchListener>(windowSwitchListener));
            if (bl) {
                MasterWindowListener.setup();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeWindowSwitchListener(WindowSwitchListener windowSwitchListener) {
        if (windowSwitchListener == null) {
            return;
        }
        Class<Main> clazz = Main.class;
        synchronized (Main.class) {
            Iterator<WeakReference<WindowSwitchListener>> iterator = windowSwitchListeners.iterator();
            while (iterator.hasNext()) {
                WeakReference<WindowSwitchListener> weakReference = iterator.next();
                if (weakReference.get() != null && weakReference.get() != windowSwitchListener) continue;
                iterator.remove();
            }
            if (windowSwitchListeners.isEmpty()) {
                MasterWindowListener.teardown();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static boolean addMapFrameListener(MapFrameListener mapFrameListener, boolean bl) {
        if (bl) {
            return mainPanel.addAndFireMapFrameListener(mapFrameListener);
        }
        return mainPanel.addMapFrameListener(mapFrameListener);
    }

    public static boolean addMapFrameListener(MapFrameListener mapFrameListener) {
        return mainPanel.addMapFrameListener(mapFrameListener);
    }

    public static boolean removeMapFrameListener(MapFrameListener mapFrameListener) {
        return mainPanel.removeMapFrameListener(mapFrameListener);
    }

    public static Throwable addNetworkError(URL uRL, Throwable throwable) {
        if (uRL != null && throwable != null) {
            Throwable throwable2 = Main.addNetworkError(uRL.toExternalForm(), throwable);
            if (throwable2 != null) {
                Main.warn("Already here " + throwable2);
            }
            return throwable2;
        }
        return null;
    }

    public static Throwable addNetworkError(String string, Throwable throwable) {
        if (string != null && throwable != null) {
            return NETWORK_ERRORS.put(string, throwable);
        }
        return null;
    }

    public static Map<String, Throwable> getNetworkErrors() {
        return new HashMap<String, Throwable>(NETWORK_ERRORS);
    }

    public static List<String> getCommandLineArgs() {
        return Collections.unmodifiableList(COMMAND_LINE_ARGS);
    }

    public static String getJOSMWebsite() {
        if (pref != null) {
            return pref.get("josm.url", JOSM_WEBSITE);
        }
        return JOSM_WEBSITE;
    }

    public static String getXMLBase() {
        return "http://josm.openstreetmap.de";
    }

    public static String getOSMWebsite() {
        if (pref != null) {
            return pref.get("osm.url", OSM_WEBSITE);
        }
        return OSM_WEBSITE;
    }

    public static String getBaseBrowseUrl() {
        if (pref != null) {
            return pref.get("osm-browse.url", Main.getOSMWebsite());
        }
        return Main.getOSMWebsite();
    }

    public static String getBaseUserUrl() {
        if (pref != null) {
            return pref.get("osm-user.url", Main.getOSMWebsite() + "/user");
        }
        return Main.getOSMWebsite() + "/user";
    }

    public static boolean isPlatformOsx() {
        return platform instanceof PlatformHookOsx;
    }

    public static boolean isPlatformWindows() {
        return platform instanceof PlatformHookWindows;
    }

    public static boolean isOffline(OnlineResource onlineResource) {
        return OFFLINE_RESOURCES.contains((Object)onlineResource) || OFFLINE_RESOURCES.contains((Object)OnlineResource.ALL);
    }

    public static boolean setOffline(OnlineResource onlineResource) {
        return OFFLINE_RESOURCES.add(onlineResource);
    }

    public static boolean setOnline(OnlineResource onlineResource) {
        return OFFLINE_RESOURCES.remove((Object)onlineResource);
    }

    public static Set<OnlineResource> getOfflineResources() {
        return EnumSet.copyOf(OFFLINE_RESOURCES);
    }

    static {
        COMMAND_LINE_ARGS = new ArrayList<String>();
        worker = new ProgressMonitorExecutor("main-worker-%d", 5);
        layerManager = new MainLayerManager();
        fileWatcher = new FileWatcher();
        NETWORK_ERRORS = new HashMap<String, Throwable>();
        ERRORS_AND_WARNINGS = Collections.synchronizedList(new ArrayList());
        OFFLINE_RESOURCES = EnumSet.noneOf(OnlineResource.class);
        logLevel = 3;
        mainPanel = new MainPanel(Main.getLayerManager());
        contentPanePrivate = new JPanel(new BorderLayout());
        panel = mainPanel;
        listeners = new ArrayList<WeakReference<ProjectionChangeListener>>();
        windowSwitchListeners = new ArrayList<WeakReference<WindowSwitchListener>>();
    }

    protected static class MasterWindowListener
    extends WindowAdapter {
        private static MasterWindowListener INSTANCE;

        protected MasterWindowListener() {
        }

        public static synchronized MasterWindowListener getInstance() {
            if (INSTANCE == null) {
                INSTANCE = new MasterWindowListener();
            }
            return INSTANCE;
        }

        public static void setup() {
            if (!windowSwitchListeners.isEmpty()) {
                for (Window window : Window.getWindows()) {
                    if (!window.isShowing() || Arrays.asList(window.getWindowListeners()).contains(MasterWindowListener.getInstance())) continue;
                    window.addWindowListener(MasterWindowListener.getInstance());
                }
            }
        }

        public static void teardown() {
            for (Window window : Window.getWindows()) {
                window.removeWindowListener(MasterWindowListener.getInstance());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void windowActivated(WindowEvent windowEvent) {
            if (windowEvent.getOppositeWindow() != null) return;
            Class<Main> clazz = Main.class;
            synchronized (Main.class) {
                Iterator iterator = windowSwitchListeners.iterator();
                while (iterator.hasNext()) {
                    WeakReference weakReference = (WeakReference)iterator.next();
                    WindowSwitchListener windowSwitchListener = (WindowSwitchListener)weakReference.get();
                    if (windowSwitchListener == null) {
                        iterator.remove();
                        continue;
                    }
                    windowSwitchListener.fromOtherApplication();
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
            for (Window window : Window.getWindows()) {
                if (!window.isShowing()) {
                    window.removeWindowListener(MasterWindowListener.getInstance());
                    continue;
                }
                if (Arrays.asList(window.getWindowListeners()).contains(MasterWindowListener.getInstance())) continue;
                window.addWindowListener(MasterWindowListener.getInstance());
            }
            if (windowEvent.getOppositeWindow() != null) return;
            Class<Main> clazz = Main.class;
            synchronized (Main.class) {
                Iterator iterator = windowSwitchListeners.iterator();
                while (iterator.hasNext()) {
                    WeakReference weakReference = (WeakReference)iterator.next();
                    WindowSwitchListener windowSwitchListener = (WindowSwitchListener)weakReference.get();
                    if (windowSwitchListener == null) {
                        iterator.remove();
                        continue;
                    }
                    windowSwitchListener.toOtherApplication();
                }
                // ** MonitorExit[var2_3] (shouldn't be in output)
                return;
            }
        }
    }

    public static interface WindowSwitchListener {
        public void toOtherApplication();

        public void fromOtherApplication();
    }

    static enum DownloadParamType {
        httpUrl{

            @Override
            void download(String string, Collection<File> collection) {
                new OpenLocationAction().openUrl(false, string);
            }

            @Override
            void downloadGps(String string) {
                Bounds bounds = OsmUrlToBounds.parse(string);
                if (bounds == null) {
                    JOptionPane.showMessageDialog(parent, I18n.tr("Ignoring malformed URL: \"{0}\"", string), I18n.tr("Warning", new Object[0]), 2);
                    return;
                }
                Main.downloadFromParamBounds(true, bounds);
            }
        }
        ,
        fileUrl{

            @Override
            void download(String string, Collection<File> collection) {
                File file = null;
                try {
                    file = new File(new URI(string));
                }
                catch (URISyntaxException uRISyntaxException) {
                    Main.warn(uRISyntaxException);
                    JOptionPane.showMessageDialog(parent, I18n.tr("Ignoring malformed file URL: \"{0}\"", string), I18n.tr("Warning", new Object[0]), 2);
                }
                if (file != null) {
                    collection.add(file);
                }
            }
        }
        ,
        bounds{

            private void downloadFromParamBounds(boolean bl, String string) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                if (stringTokenizer.countTokens() == 4) {
                    Bounds bounds = new Bounds(new LatLon(Double.parseDouble(stringTokenizer.nextToken()), Double.parseDouble(stringTokenizer.nextToken())), new LatLon(Double.parseDouble(stringTokenizer.nextToken()), Double.parseDouble(stringTokenizer.nextToken())));
                    Main.downloadFromParamBounds(bl, bounds);
                }
            }

            @Override
            void download(String string, Collection<File> collection) {
                this.downloadFromParamBounds(false, string);
            }

            @Override
            void downloadGps(String string) {
                this.downloadFromParamBounds(true, string);
            }
        }
        ,
        fileName{

            @Override
            void download(String string, Collection<File> collection) {
                collection.add(new File(string));
            }
        };


        abstract void download(String var1, Collection<File> var2);

        void downloadGps(String string) {
            JOptionPane.showMessageDialog(parent, I18n.tr("Parameter \"downloadgps\" does not accept file names or file URLs", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
        }

        static DownloadParamType paramType(String string) {
            if (string.startsWith("http:") || string.startsWith("https:")) {
                return httpUrl;
            }
            if (string.startsWith("file:")) {
                return fileUrl;
            }
            String string2 = "\\s*[+-]?[0-9]+(\\.[0-9]+)?\\s*";
            if (string.matches(string2 + "(," + string2 + "){3}")) {
                return bounds;
            }
            return fileName;
        }
    }

    private static abstract class InitializationTask
    implements Callable<Void> {
        private final String name;

        protected InitializationTask(String string) {
            this.name = string;
        }

        public abstract void initialize();

        @Override
        public Void call() {
            Object object = null;
            if (initListener != null) {
                object = initListener.updateStatus(this.name);
            }
            this.initialize();
            if (initListener != null) {
                initListener.finish(object);
            }
            return null;
        }
    }

    public static interface InitStatusListener {
        public Object updateStatus(String var1);

        public void finish(Object var1);
    }
}

