/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.cache;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.channels.FileLock;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.apache.commons.jcs.access.CacheAccess;
import org.apache.commons.jcs.auxiliary.AuxiliaryCache;
import org.apache.commons.jcs.auxiliary.AuxiliaryCacheFactory;
import org.apache.commons.jcs.auxiliary.disk.behavior.IDiskCacheAttributes;
import org.apache.commons.jcs.auxiliary.disk.block.BlockDiskCacheAttributes;
import org.apache.commons.jcs.auxiliary.disk.block.BlockDiskCacheFactory;
import org.apache.commons.jcs.auxiliary.disk.indexed.IndexedDiskCacheAttributes;
import org.apache.commons.jcs.auxiliary.disk.indexed.IndexedDiskCacheFactory;
import org.apache.commons.jcs.engine.CompositeCacheAttributes;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheAttributes;
import org.apache.commons.jcs.engine.control.CompositeCache;
import org.apache.commons.jcs.engine.control.CompositeCacheManager;
import org.apache.commons.jcs.utils.serialization.StandardSerializer;
import org.openstreetmap.gui.jmapviewer.FeatureAdapter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.cache.CacheEntryAttributes;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.tools.Utils;

public final class JCSCacheManager {
    private static final Logger LOG = FeatureAdapter.getLogger(JCSCacheManager.class.getCanonicalName());
    private static volatile CompositeCacheManager cacheManager;
    private static long maxObjectTTL;
    private static final String PREFERENCE_PREFIX = "jcs.cache";
    public static final BooleanProperty USE_BLOCK_CACHE;
    private static final AuxiliaryCacheFactory diskCacheFactory;
    private static FileLock cacheDirLock;
    public static final IntegerProperty DEFAULT_MAX_OBJECTS_IN_MEMORY;

    private JCSCacheManager() {
    }

    private static void initialize() throws IOException {
        File file = new File(Main.pref.getCacheDirectory(), "jcs");
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("Cannot access cache directory");
        }
        File file2 = new File(file, ".lock");
        if (!file2.exists() && !file2.createNewFile()) {
            LOG.log(Level.WARNING, "Cannot create cache dir lock file");
        }
        if ((cacheDirLock = new FileOutputStream(file2).getChannel().tryLock()) == null) {
            LOG.log(Level.WARNING, "Cannot lock cache directory. Will not use disk cache");
        }
        Logger logger = Logger.getLogger("org.apache.commons.jcs");
        logger.setLevel(Level.INFO);
        logger.setUseParentHandlers(false);
        logger.addHandler(new Handler(){
            final SimpleFormatter formatter = new SimpleFormatter();

            @Override
            public void publish(LogRecord logRecord) {
                String string = this.formatter.formatMessage(logRecord);
                if (logRecord.getLevel().intValue() >= Level.SEVERE.intValue()) {
                    Main.error(string);
                } else if (logRecord.getLevel().intValue() >= Level.WARNING.intValue()) {
                    Main.warn(string);
                } else if (logRecord.getLevel().intValue() >= Level.INFO.intValue()) {
                    Main.debug(string);
                } else {
                    Main.trace(string);
                }
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }
        });
        Properties properties = new Properties();
        properties.setProperty("jcs.default.cacheattributes", CompositeCacheAttributes.class.getCanonicalName());
        properties.setProperty("jcs.default.cacheattributes.MaxObjects", DEFAULT_MAX_OBJECTS_IN_MEMORY.get().toString());
        properties.setProperty("jcs.default.cacheattributes.UseMemoryShrinker", "true");
        properties.setProperty("jcs.default.cacheattributes.DiskUsagePatternName", "UPDATE");
        properties.setProperty("jcs.default.elementattributes", CacheEntryAttributes.class.getCanonicalName());
        properties.setProperty("jcs.default.elementattributes.IsEternal", "false");
        properties.setProperty("jcs.default.elementattributes.MaxLife", Long.toString(maxObjectTTL));
        properties.setProperty("jcs.default.elementattributes.IdleTime", Long.toString(maxObjectTTL));
        properties.setProperty("jcs.default.elementattributes.IsSpool", "true");
        CompositeCacheManager compositeCacheManager = CompositeCacheManager.getUnconfiguredInstance();
        compositeCacheManager.configure(properties);
        cacheManager = compositeCacheManager;
    }

    public static <K, V> CacheAccess<K, V> getCache(String string) throws IOException {
        return JCSCacheManager.getCache(string, DEFAULT_MAX_OBJECTS_IN_MEMORY.get(), 0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> CacheAccess<K, V> getCache(String string, int n, int n2, String string2) throws IOException {
        if (cacheManager != null) {
            return JCSCacheManager.getCacheInner(string, n, n2, string2);
        }
        Class<JCSCacheManager> clazz = JCSCacheManager.class;
        synchronized (JCSCacheManager.class) {
            if (cacheManager == null) {
                JCSCacheManager.initialize();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return JCSCacheManager.getCacheInner(string, n, n2, string2);
        }
    }

    private static <K, V> CacheAccess<K, V> getCacheInner(String string, int n, int n2, String string2) throws IOException {
        CompositeCache compositeCache = cacheManager.getCache(string, JCSCacheManager.getCacheAttributes(n));
        if (string2 != null && cacheDirLock != null) {
            IDiskCacheAttributes iDiskCacheAttributes = JCSCacheManager.getDiskCacheAttributes(n2, string2, string);
            try {
                if (compositeCache.getAuxCaches().length == 0) {
                    AuxiliaryCache auxiliaryCache = diskCacheFactory.createCache(iDiskCacheAttributes, cacheManager, null, new StandardSerializer());
                    compositeCache.setAuxCaches(new AuxiliaryCache[]{auxiliaryCache});
                }
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new IOException(exception);
            }
        }
        return new CacheAccess(compositeCache);
    }

    public static void shutdown() {
        CompositeCacheManager compositeCacheManager = cacheManager;
        if (compositeCacheManager != null) {
            compositeCacheManager.shutDown();
        }
    }

    private static IDiskCacheAttributes getDiskCacheAttributes(int n, String string, String string2) {
        Serializable serializable;
        Serializable serializable2;
        JCSCacheManager.removeStaleFiles(string + File.separator + string2, USE_BLOCK_CACHE.get() != false ? "_INDEX_v2" : "_BLOCK_v2");
        string2 = string2 + (USE_BLOCK_CACHE.get() != false ? "_BLOCK_v2" : "_INDEX_v2");
        if (USE_BLOCK_CACHE.get().booleanValue()) {
            serializable2 = new BlockDiskCacheAttributes();
            File file = new File(string + File.separator + string2 + ".data");
            if (file.exists()) {
                ((BlockDiskCacheAttributes)serializable2).setMaxKeySize((int)Math.max((long)n, file.length() / 1024L));
            } else {
                ((BlockDiskCacheAttributes)serializable2).setMaxKeySize(n);
            }
            ((BlockDiskCacheAttributes)serializable2).setBlockSizeBytes(4096);
            serializable = serializable2;
        } else {
            serializable2 = new IndexedDiskCacheAttributes();
            ((IndexedDiskCacheAttributes)serializable2).setMaxKeySize(n);
            serializable = serializable2;
        }
        serializable.setDiskLimitType(IDiskCacheAttributes.DiskLimitType.SIZE);
        serializable2 = new File(string);
        if (!((File)serializable2).exists() && !((File)serializable2).mkdirs()) {
            LOG.log(Level.WARNING, "Failed to create cache path: {0}", string);
        } else {
            serializable.setDiskPath(string);
        }
        serializable.setCacheName(string2);
        return serializable;
    }

    private static void removeStaleFiles(String string, String string2) {
        JCSCacheManager.deleteCacheFiles(string);
        JCSCacheManager.deleteCacheFiles(string + "_BLOCK");
        JCSCacheManager.deleteCacheFiles(string + "_INDEX");
        JCSCacheManager.deleteCacheFiles(string + string2);
    }

    private static void deleteCacheFiles(String string) {
        Utils.deleteFileIfExists(new File(string + ".key"));
        Utils.deleteFileIfExists(new File(string + ".data"));
    }

    private static CompositeCacheAttributes getCacheAttributes(int n) {
        CompositeCacheAttributes compositeCacheAttributes = new CompositeCacheAttributes();
        compositeCacheAttributes.setMaxObjects(n);
        compositeCacheAttributes.setDiskUsagePattern(ICompositeCacheAttributes.DiskUsagePattern.UPDATE);
        return compositeCacheAttributes;
    }

    static {
        maxObjectTTL = -1L;
        USE_BLOCK_CACHE = new BooleanProperty("jcs.cache.use_block_cache", true);
        diskCacheFactory = USE_BLOCK_CACHE.get() != false ? new BlockDiskCacheFactory() : new IndexedDiskCacheFactory();
        DEFAULT_MAX_OBJECTS_IN_MEMORY = new IntegerProperty("jcs.cache.max_objects_in_memory", 1000);
    }
}

