/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools.bugreport;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openstreetmap.josm.actions.ShowStatusReportAction;
import org.openstreetmap.josm.tools.bugreport.ReportedException;

public final class BugReport
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean includeStatusReport = true;
    private boolean includeData = true;
    private boolean includeAllStackTraces;
    private final ReportedException exception;
    private final CopyOnWriteArrayList<BugReportListener> listeners = new CopyOnWriteArrayList();

    BugReport(ReportedException reportedException) {
        this.exception = reportedException;
        this.includeAllStackTraces = reportedException.mayHaveConcurrentSource();
    }

    public boolean isIncludeStatusReport() {
        return this.includeStatusReport;
    }

    public void setIncludeStatusReport(boolean bl) {
        this.includeStatusReport = bl;
        this.fireChange();
    }

    public boolean isIncludeData() {
        return this.includeData;
    }

    public void setIncludeData(boolean bl) {
        this.includeData = bl;
        this.fireChange();
    }

    public boolean isIncludeAllStackTraces() {
        return this.includeAllStackTraces;
    }

    public void setIncludeAllStackTraces(boolean bl) {
        this.includeAllStackTraces = bl;
        this.fireChange();
    }

    public String getReportText() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (this.isIncludeStatusReport()) {
            printWriter.println(ShowStatusReportAction.getReportHeader());
        }
        if (this.isIncludeData()) {
            this.exception.printReportDataTo(printWriter);
        }
        this.exception.printReportStackTo(printWriter);
        if (this.isIncludeAllStackTraces()) {
            this.exception.printReportThreadsTo(printWriter);
        }
        return stringWriter.toString().replaceAll("\r", "");
    }

    public void addChangeListener(BugReportListener bugReportListener) {
        this.listeners.add(bugReportListener);
    }

    public void removeChangeListener(BugReportListener bugReportListener) {
        this.listeners.remove(bugReportListener);
    }

    private void fireChange() {
        this.listeners.stream().forEach(bugReportListener -> bugReportListener.bugReportChanged(this));
    }

    public static ReportedException intercept(Throwable throwable) {
        ReportedException reportedException = throwable instanceof ReportedException ? (ReportedException)throwable : new ReportedException(throwable);
        reportedException.startSection(BugReport.getCallingMethod(2));
        return reportedException;
    }

    public static String getCallingMethod(int n) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        String string = BugReport.class.getName();
        for (int i = 0; i < stackTraceElementArray.length - n; ++i) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i];
            if (!string.equals(stackTraceElement.getClassName()) || !"getCallingMethod".equals(stackTraceElement.getMethodName())) continue;
            StackTraceElement stackTraceElement2 = stackTraceElementArray[i + n];
            return stackTraceElement2.getClassName().replaceFirst(".*\\.", "") + '#' + stackTraceElement2.getMethodName();
        }
        return "?";
    }

    @FunctionalInterface
    public static interface BugReportListener {
        public void bugReportChanged(BugReport var1);
    }
}

