/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.tasks.list;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksRequest;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksResponse;
import org.elasticsearch.action.admin.cluster.node.tasks.list.TaskInfo;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.tasks.TransportTasksAction;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.Consumer;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportListTasksAction
extends TransportTasksAction<Task, ListTasksRequest, ListTasksResponse, TaskInfo> {
    private static final TimeValue WAIT_FOR_COMPLETION_POLL = TimeValue.timeValueMillis(100L);
    private static final TimeValue DEFAULT_WAIT_FOR_COMPLETION_TIMEOUT = TimeValue.timeValueSeconds(30L);

    @Inject
    public TransportListTasksAction(Settings settings, ClusterName clusterName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "cluster:monitor/tasks/lists", clusterName, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, new Callable<ListTasksRequest>(){

            @Override
            public ListTasksRequest call() throws Exception {
                return new ListTasksRequest();
            }
        }, "management");
    }

    @Override
    protected ListTasksResponse newResponse(ListTasksRequest request, List<TaskInfo> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        return new ListTasksResponse(tasks, taskOperationFailures, failedNodeExceptions);
    }

    @Override
    protected TaskInfo readTaskResponse(StreamInput in) throws IOException {
        return new TaskInfo(in);
    }

    @Override
    protected TaskInfo taskOperation(ListTasksRequest request, Task task) {
        return task.taskInfo(this.clusterService.localNode(), request.getDetailed());
    }

    @Override
    protected void processTasks(ListTasksRequest request, final Consumer<Task> operation) {
        if (!request.getWaitForCompletion()) {
            super.processTasks(request, operation);
            return;
        }
        TimeValue timeout = request.getTimeout();
        if (timeout == null) {
            timeout = DEFAULT_WAIT_FOR_COMPLETION_TIMEOUT;
        }
        final long timeoutTime = System.nanoTime() + timeout.nanos();
        super.processTasks(request, new Consumer<Task>(){

            @Override
            public void accept(Task t) {
                operation.accept(t);
                while (System.nanoTime() - timeoutTime < 0L) {
                    Task task = TransportListTasksAction.this.taskManager.getTask(t.getId());
                    if (task == null) {
                        return;
                    }
                    if (task.getAction().startsWith("cluster:monitor/tasks/lists")) {
                        return;
                    }
                    try {
                        Thread.sleep(WAIT_FOR_COMPLETION_POLL.millis());
                    }
                    catch (InterruptedException e) {
                        throw new ElasticsearchException("Interrupted waiting for completion of [{}]", (Throwable)e, t);
                    }
                }
                throw new ElasticsearchTimeoutException("Timed out waiting for completion of [{}]", t);
            }
        });
    }

    @Override
    protected boolean accumulateExceptions() {
        return true;
    }
}

