/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.search.AbstractSearchAsyncAction;
import org.elasticsearch.action.search.ReduceSearchPhaseException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.TransportSearchHelper;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.action.SearchServiceTransportAction;
import org.elasticsearch.search.controller.SearchPhaseController;
import org.elasticsearch.search.dfs.AggregatedDfs;
import org.elasticsearch.search.dfs.DfsSearchResult;
import org.elasticsearch.search.fetch.QueryFetchSearchResult;
import org.elasticsearch.search.internal.InternalSearchResponse;
import org.elasticsearch.search.internal.ShardSearchTransportRequest;
import org.elasticsearch.search.query.QuerySearchRequest;
import org.elasticsearch.threadpool.ThreadPool;

class SearchDfsQueryAndFetchAsyncAction
extends AbstractSearchAsyncAction<DfsSearchResult> {
    private final AtomicArray<QueryFetchSearchResult> queryFetchResults;

    SearchDfsQueryAndFetchAsyncAction(ESLogger logger, SearchServiceTransportAction searchService, ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver, SearchPhaseController searchPhaseController, ThreadPool threadPool, SearchRequest request, ActionListener<SearchResponse> listener) {
        super(logger, searchService, clusterService, indexNameExpressionResolver, searchPhaseController, threadPool, request, listener);
        this.queryFetchResults = new AtomicArray(this.firstResults.length());
    }

    @Override
    protected String firstPhaseName() {
        return "dfs";
    }

    @Override
    protected void sendExecuteFirstPhase(DiscoveryNode node, ShardSearchTransportRequest request, ActionListener<DfsSearchResult> listener) {
        this.searchService.sendExecuteDfs(node, request, listener);
    }

    @Override
    protected void moveToSecondPhase() {
        AggregatedDfs dfs = this.searchPhaseController.aggregateDfs(this.firstResults);
        AtomicInteger counter = new AtomicInteger(this.firstResults.asList().size());
        for (AtomicArray.Entry entry : this.firstResults.asList()) {
            DfsSearchResult dfsResult = (DfsSearchResult)entry.value;
            DiscoveryNode node = this.nodes.get(dfsResult.shardTarget().nodeId());
            QuerySearchRequest querySearchRequest = new QuerySearchRequest(this.request, dfsResult.id(), dfs);
            this.executeSecondPhase(entry.index, dfsResult, counter, node, querySearchRequest);
        }
    }

    void executeSecondPhase(final int shardIndex, final DfsSearchResult dfsResult, final AtomicInteger counter, final DiscoveryNode node, final QuerySearchRequest querySearchRequest) {
        this.searchService.sendExecuteFetch(node, querySearchRequest, new ActionListener<QueryFetchSearchResult>(){

            @Override
            public void onResponse(QueryFetchSearchResult result) {
                result.shardTarget(dfsResult.shardTarget());
                SearchDfsQueryAndFetchAsyncAction.this.queryFetchResults.set(shardIndex, result);
                if (counter.decrementAndGet() == 0) {
                    SearchDfsQueryAndFetchAsyncAction.this.finishHim();
                }
            }

            @Override
            public void onFailure(Throwable t) {
                try {
                    SearchDfsQueryAndFetchAsyncAction.this.onSecondPhaseFailure(t, querySearchRequest, shardIndex, dfsResult, counter);
                }
                finally {
                    SearchDfsQueryAndFetchAsyncAction.this.sendReleaseSearchContext(querySearchRequest.id(), node);
                }
            }
        });
    }

    void onSecondPhaseFailure(Throwable t, QuerySearchRequest querySearchRequest, int shardIndex, DfsSearchResult dfsResult, AtomicInteger counter) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("[{}] Failed to execute query phase", t, querySearchRequest.id());
        }
        this.addShardFailure(shardIndex, dfsResult.shardTarget(), t);
        this.successfulOps.decrementAndGet();
        if (counter.decrementAndGet() == 0) {
            this.finishHim();
        }
    }

    private void finishHim() {
        this.threadPool.executor("search").execute(new ActionRunnable<SearchResponse>(this.listener){

            @Override
            public void doRun() throws IOException {
                SearchDfsQueryAndFetchAsyncAction.this.sortedShardList = SearchDfsQueryAndFetchAsyncAction.this.searchPhaseController.sortDocs(true, SearchDfsQueryAndFetchAsyncAction.this.queryFetchResults);
                InternalSearchResponse internalResponse = SearchDfsQueryAndFetchAsyncAction.this.searchPhaseController.merge(SearchDfsQueryAndFetchAsyncAction.this.sortedShardList, SearchDfsQueryAndFetchAsyncAction.this.queryFetchResults, SearchDfsQueryAndFetchAsyncAction.this.queryFetchResults, SearchDfsQueryAndFetchAsyncAction.this.request);
                String scrollId = null;
                if (SearchDfsQueryAndFetchAsyncAction.this.request.scroll() != null) {
                    scrollId = TransportSearchHelper.buildScrollId(SearchDfsQueryAndFetchAsyncAction.this.request.searchType(), (AtomicArray<? extends SearchPhaseResult>)SearchDfsQueryAndFetchAsyncAction.this.firstResults, null);
                }
                this.listener.onResponse(new SearchResponse(internalResponse, scrollId, SearchDfsQueryAndFetchAsyncAction.this.expectedSuccessfulOps, SearchDfsQueryAndFetchAsyncAction.this.successfulOps.get(), SearchDfsQueryAndFetchAsyncAction.this.buildTookInMillis(), SearchDfsQueryAndFetchAsyncAction.this.buildShardFailures()));
            }

            @Override
            public void onFailure(Throwable t) {
                ReduceSearchPhaseException failure = new ReduceSearchPhaseException("query_fetch", "", t, SearchDfsQueryAndFetchAsyncAction.this.buildShardFailures());
                if (SearchDfsQueryAndFetchAsyncAction.this.logger.isDebugEnabled()) {
                    SearchDfsQueryAndFetchAsyncAction.this.logger.debug("failed to reduce search", failure, new Object[0]);
                }
                super.onFailure(t);
            }
        });
    }
}

