/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class StoreStats
implements Streamable,
ToXContent {
    private long sizeInBytes;
    private long throttleTimeInNanos;

    public StoreStats() {
    }

    public StoreStats(long sizeInBytes, long throttleTimeInNanos) {
        this.sizeInBytes = sizeInBytes;
        this.throttleTimeInNanos = throttleTimeInNanos;
    }

    public void add(StoreStats stats) {
        if (stats == null) {
            return;
        }
        this.sizeInBytes += stats.sizeInBytes;
        this.throttleTimeInNanos += stats.throttleTimeInNanos;
    }

    public long sizeInBytes() {
        return this.sizeInBytes;
    }

    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public ByteSizeValue size() {
        return new ByteSizeValue(this.sizeInBytes);
    }

    public ByteSizeValue getSize() {
        return this.size();
    }

    public TimeValue throttleTime() {
        return TimeValue.timeValueNanos(this.throttleTimeInNanos);
    }

    public TimeValue getThrottleTime() {
        return this.throttleTime();
    }

    public static StoreStats readStoreStats(StreamInput in) throws IOException {
        StoreStats store = new StoreStats();
        store.readFrom(in);
        return store;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.sizeInBytes = in.readVLong();
        this.throttleTimeInNanos = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.sizeInBytes);
        out.writeVLong(this.throttleTimeInNanos);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.STORE);
        builder.byteSizeField(Fields.SIZE_IN_BYTES, Fields.SIZE, this.sizeInBytes);
        builder.timeValueField(Fields.THROTTLE_TIME_IN_MILLIS, Fields.THROTTLE_TIME, this.throttleTime());
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final XContentBuilderString STORE = new XContentBuilderString("store");
        static final XContentBuilderString SIZE = new XContentBuilderString("size");
        static final XContentBuilderString SIZE_IN_BYTES = new XContentBuilderString("size_in_bytes");
        static final XContentBuilderString THROTTLE_TIME = new XContentBuilderString("throttle_time");
        static final XContentBuilderString THROTTLE_TIME_IN_MILLIS = new XContentBuilderString("throttle_time_in_millis");

        Fields() {
        }
    }
}

