/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.process;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import org.elasticsearch.bootstrap.BootstrapInfo;
import org.elasticsearch.monitor.Probes;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.monitor.process.ProcessInfo;
import org.elasticsearch.monitor.process.ProcessStats;

public class ProcessProbe {
    private static final OperatingSystemMXBean osMxBean = ManagementFactory.getOperatingSystemMXBean();
    private static final Method getMaxFileDescriptorCountField = ProcessProbe.getUnixMethod("getMaxFileDescriptorCount");
    private static final Method getOpenFileDescriptorCountField = ProcessProbe.getUnixMethod("getOpenFileDescriptorCount");
    private static final Method getProcessCpuLoad = ProcessProbe.getMethod("getProcessCpuLoad");
    private static final Method getProcessCpuTime = ProcessProbe.getMethod("getProcessCpuTime");
    private static final Method getCommittedVirtualMemorySize = ProcessProbe.getMethod("getCommittedVirtualMemorySize");

    public static ProcessProbe getInstance() {
        return ProcessProbeHolder.INSTANCE;
    }

    private ProcessProbe() {
    }

    public long getMaxFileDescriptorCount() {
        if (getMaxFileDescriptorCountField == null) {
            return -1L;
        }
        try {
            return (Long)getMaxFileDescriptorCountField.invoke((Object)osMxBean, new Object[0]);
        }
        catch (Throwable t) {
            return -1L;
        }
    }

    public long getOpenFileDescriptorCount() {
        if (getOpenFileDescriptorCountField == null) {
            return -1L;
        }
        try {
            return (Long)getOpenFileDescriptorCountField.invoke((Object)osMxBean, new Object[0]);
        }
        catch (Throwable t) {
            return -1L;
        }
    }

    public short getProcessCpuPercent() {
        return Probes.getLoadAndScaleToPercent(getProcessCpuLoad, osMxBean);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getProcessCpuTotalTime() {
        if (getProcessCpuTime == null) {
        }
        try {
            long time = (Long)getProcessCpuTime.invoke((Object)osMxBean, new Object[0]);
            if (time >= 0L) {
                return time / 1000000L;
            }
        }
        finally {
            return -1L;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getTotalVirtualMemorySize() {
        if (getCommittedVirtualMemorySize == null) {
        }
        try {
            long virtual = (Long)getCommittedVirtualMemorySize.invoke((Object)osMxBean, new Object[0]);
            if (virtual >= 0L) {
                return virtual;
            }
        }
        finally {
            return -1L;
        }
    }

    public ProcessInfo processInfo() {
        return new ProcessInfo(JvmInfo.jvmInfo().pid(), BootstrapInfo.isMemoryLocked());
    }

    public ProcessStats processStats() {
        ProcessStats stats = new ProcessStats();
        stats.timestamp = System.currentTimeMillis();
        stats.openFileDescriptors = this.getOpenFileDescriptorCount();
        stats.maxFileDescriptors = this.getMaxFileDescriptorCount();
        ProcessStats.Cpu cpu = new ProcessStats.Cpu();
        cpu.percent = this.getProcessCpuPercent();
        cpu.total = this.getProcessCpuTotalTime();
        stats.cpu = cpu;
        ProcessStats.Mem mem = new ProcessStats.Mem();
        mem.totalVirtual = this.getTotalVirtualMemorySize();
        stats.mem = mem;
        return stats;
    }

    private static Method getMethod(String methodName) {
        try {
            return Class.forName("com.sun.management.OperatingSystemMXBean").getMethod(methodName, new Class[0]);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static Method getUnixMethod(String methodName) {
        try {
            return Class.forName("com.sun.management.UnixOperatingSystemMXBean").getMethod(methodName, new Class[0]);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static class ProcessProbeHolder {
        private static final ProcessProbe INSTANCE = new ProcessProbe();

        private ProcessProbeHolder() {
        }
    }
}

