/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.AuthenticationEvent;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.Mozilla;
import org.eclipse.swt.browser.PromptDialog;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.mozilla.XPCOM;
import org.eclipse.swt.internal.mozilla.XPCOMObject;
import org.eclipse.swt.internal.mozilla.nsEmbedString;
import org.eclipse.swt.internal.mozilla.nsIAuthInformation;
import org.eclipse.swt.internal.mozilla.nsIChannel;
import org.eclipse.swt.internal.mozilla.nsID;
import org.eclipse.swt.internal.mozilla.nsIURI;
import org.eclipse.swt.widgets.Shell;

class PromptAuth2 {
    XPCOMObject supports;
    XPCOMObject promptAuth;
    int refCount = 0;
    int parent;

    PromptAuth2() {
        this.createCOMInterfaces();
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    void createCOMInterfaces() {
        this.supports = new XPCOMObject(new int[]{2, 0, 0}){

            @Override
            public int method0(int[] nArray) {
                return PromptAuth2.this.QueryInterface(nArray[0], nArray[1]);
            }

            @Override
            public int method1(int[] nArray) {
                return PromptAuth2.this.AddRef();
            }

            @Override
            public int method2(int[] nArray) {
                return PromptAuth2.this.Release();
            }
        };
        this.promptAuth = new XPCOMObject(new int[]{2, 0, 0, 4, 6}){

            @Override
            public int method0(int[] nArray) {
                return PromptAuth2.this.QueryInterface(nArray[0], nArray[1]);
            }

            @Override
            public int method1(int[] nArray) {
                return PromptAuth2.this.AddRef();
            }

            @Override
            public int method2(int[] nArray) {
                return PromptAuth2.this.Release();
            }

            @Override
            public int method3(int[] nArray) {
                return PromptAuth2.this.PromptAuth(nArray[0], nArray[1], nArray[2], nArray[3]);
            }

            @Override
            public int method4(int[] nArray) {
                return PromptAuth2.this.AsyncPromptAuth(nArray[0], nArray[1], nArray[2], nArray[3], nArray[4], nArray[5]);
            }
        };
    }

    void disposeCOMInterfaces() {
        if (this.supports != null) {
            this.supports.dispose();
            this.supports = null;
        }
        if (this.promptAuth != null) {
            this.promptAuth.dispose();
            this.promptAuth = null;
        }
    }

    int getAddress() {
        return this.promptAuth.getAddress();
    }

    int QueryInterface(int n, int n2) {
        if (n == 0 || n2 == 0) {
            return -2147467262;
        }
        nsID nsID2 = new nsID();
        XPCOM.memmove(nsID2, n, 16);
        if (nsID2.Equals(XPCOM.NS_ISUPPORTS_IID)) {
            XPCOM.memmove(n2, new int[]{this.supports.getAddress()}, C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (nsID2.Equals(XPCOM.NS_IAUTHPROMPT2_IID)) {
            XPCOM.memmove(n2, new int[]{this.promptAuth.getAddress()}, C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        XPCOM.memmove(n2, new int[]{0}, C.PTR_SIZEOF);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    Browser getBrowser() {
        if (this.parent == 0) {
            return null;
        }
        return Mozilla.getBrowser(this.parent);
    }

    void setParent(int n) {
        this.parent = n;
    }

    int PromptAuth(int n, int n2, int n3, int n4) {
        int n5;
        nsIURI nsIURI2;
        String[] stringArray;
        Mozilla mozilla;
        nsIAuthInformation nsIAuthInformation2 = new nsIAuthInformation(n3);
        Browser browser = this.getBrowser();
        if (browser != null) {
            mozilla = (Mozilla)browser.webBrowser;
            if (mozilla.authCount++ < 3) {
                for (int i = 0; i < mozilla.authenticationListeners.length; ++i) {
                    stringArray = new AuthenticationEvent(browser);
                    stringArray.location = mozilla.lastNavigateURL;
                    mozilla.authenticationListeners[i].authenticate((AuthenticationEvent)stringArray);
                    if (!stringArray.doit) {
                        XPCOM.memmove(n4, new boolean[]{false});
                        return 0;
                    }
                    if (stringArray.user == null || stringArray.password == null) continue;
                    nsEmbedString nsEmbedString2 = new nsEmbedString(stringArray.user);
                    int n6 = nsIAuthInformation2.SetUsername(nsEmbedString2.getAddress());
                    if (n6 != 0) {
                        SWT.error(n6);
                    }
                    nsEmbedString2.dispose();
                    nsEmbedString2 = new nsEmbedString(stringArray.password);
                    n6 = nsIAuthInformation2.SetPassword(nsEmbedString2.getAddress());
                    if (n6 != 0) {
                        SWT.error(n6);
                    }
                    nsEmbedString2.dispose();
                    XPCOM.memmove(n4, new boolean[]{true});
                    return 0;
                }
            }
        }
        mozilla = null;
        boolean[] blArray = new boolean[1];
        stringArray = new String[1];
        String[] stringArray2 = new String[1];
        String string = SWT.getMessage("SWT_Authentication_Required");
        nsEmbedString nsEmbedString3 = new nsEmbedString();
        int n7 = nsIAuthInformation2.GetUsername(nsEmbedString3.getAddress());
        if (n7 != 0) {
            SWT.error(n7);
        }
        stringArray[0] = nsEmbedString3.toString();
        nsEmbedString3.dispose();
        nsEmbedString3 = new nsEmbedString();
        n7 = nsIAuthInformation2.GetPassword(nsEmbedString3.getAddress());
        if (n7 != 0) {
            SWT.error(n7);
        }
        stringArray2[0] = nsEmbedString3.toString();
        nsEmbedString3.dispose();
        nsEmbedString3 = new nsEmbedString();
        n7 = nsIAuthInformation2.GetRealm(nsEmbedString3.getAddress());
        if (n7 != 0) {
            SWT.error(n7);
        }
        String string2 = nsEmbedString3.toString();
        nsEmbedString3.dispose();
        nsIChannel nsIChannel2 = new nsIChannel(n);
        int[] nArray = new int[1];
        n7 = nsIChannel2.GetURI(nArray);
        if (n7 != 0) {
            SWT.error(n7);
        }
        if (nArray[0] == 0) {
            Mozilla.error(-2147467262);
        }
        if ((n7 = (nsIURI2 = new nsIURI(nArray[0])).GetHost(n5 = XPCOM.nsEmbedCString_new())) != 0) {
            SWT.error(n7);
        }
        int n8 = XPCOM.nsEmbedCString_Length(n5);
        int n9 = XPCOM.nsEmbedCString_get(n5);
        byte[] byArray = new byte[n8];
        XPCOM.memmove(byArray, n9, n8);
        String string3 = new String(byArray);
        XPCOM.nsEmbedCString_delete(n5);
        nsIURI2.Release();
        String string4 = string2.length() > 0 && string3.length() > 0 ? Compatibility.getMessage("SWT_Enter_Username_and_Password", new String[]{string2, string3}) : "";
        Shell shell = browser == null ? new Shell() : browser.getShell();
        PromptDialog promptDialog = new PromptDialog(shell);
        boolean[] blArray2 = new boolean[1];
        promptDialog.promptUsernameAndPassword(string, string4, (String)((Object)mozilla), stringArray, stringArray2, blArray, blArray2);
        XPCOM.memmove(n4, blArray2);
        if (blArray2[0]) {
            nsEmbedString nsEmbedString4 = new nsEmbedString(stringArray[0]);
            n7 = nsIAuthInformation2.SetUsername(nsEmbedString4.getAddress());
            if (n7 != 0) {
                SWT.error(n7);
            }
            nsEmbedString4.dispose();
            nsEmbedString4 = new nsEmbedString(stringArray2[0]);
            n7 = nsIAuthInformation2.SetPassword(nsEmbedString4.getAddress());
            if (n7 != 0) {
                SWT.error(n7);
            }
            nsEmbedString4.dispose();
        }
        return 0;
    }

    int AsyncPromptAuth(int n, int n2, int n3, int n4, int n5, int n6) {
        return -2147467263;
    }
}

