/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.prefix;

import com.spatial4j.core.shape.Point;
import org.apache.lucene.spatial.prefix.tree.Cell;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.spatial.util.ShapeFieldCacheProvider;
import org.apache.lucene.util.BytesRef;

public class PointPrefixTreeFieldCacheProvider
extends ShapeFieldCacheProvider<Point> {
    private final SpatialPrefixTree grid;
    private Cell scanCell;

    public PointPrefixTreeFieldCacheProvider(SpatialPrefixTree grid, String shapeField, int defaultSize) {
        super(shapeField, defaultSize);
        this.grid = grid;
    }

    @Override
    protected Point readShape(BytesRef term) {
        this.scanCell = this.grid.readCell(term, this.scanCell);
        if (this.scanCell.getLevel() == this.grid.getMaxLevels()) {
            return this.scanCell.getShape().getCenter();
        }
        return null;
    }
}

