/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.commonjs.module.provider;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.List;
import org.mozilla.javascript.commonjs.module.provider.DefaultUrlConnectionExpiryCalculator;
import org.mozilla.javascript.commonjs.module.provider.ModuleSource;
import org.mozilla.javascript.commonjs.module.provider.ModuleSourceProviderBase;
import org.mozilla.javascript.commonjs.module.provider.ParsedContentType;
import org.mozilla.javascript.commonjs.module.provider.UrlConnectionExpiryCalculator;
import org.mozilla.javascript.commonjs.module.provider.UrlConnectionSecurityDomainProvider;

public class UrlModuleSourceProvider
extends ModuleSourceProviderBase {
    private static final long serialVersionUID = 1L;
    private final Iterable<URI> privilegedUris;
    private final Iterable<URI> fallbackUris;
    private final UrlConnectionSecurityDomainProvider urlConnectionSecurityDomainProvider;
    private final UrlConnectionExpiryCalculator urlConnectionExpiryCalculator;

    public UrlModuleSourceProvider(Iterable<URI> iterable, Iterable<URI> iterable2) {
        this(iterable, iterable2, new DefaultUrlConnectionExpiryCalculator(), null);
    }

    public UrlModuleSourceProvider(Iterable<URI> iterable, Iterable<URI> iterable2, UrlConnectionExpiryCalculator urlConnectionExpiryCalculator, UrlConnectionSecurityDomainProvider urlConnectionSecurityDomainProvider) {
        this.privilegedUris = iterable;
        this.fallbackUris = iterable2;
        this.urlConnectionExpiryCalculator = urlConnectionExpiryCalculator;
        this.urlConnectionSecurityDomainProvider = urlConnectionSecurityDomainProvider;
    }

    @Override
    protected ModuleSource loadFromPrivilegedLocations(String string, Object object) throws IOException, URISyntaxException {
        return this.loadFromPathList(string, object, this.privilegedUris);
    }

    @Override
    protected ModuleSource loadFromFallbackLocations(String string, Object object) throws IOException, URISyntaxException {
        return this.loadFromPathList(string, object, this.fallbackUris);
    }

    private ModuleSource loadFromPathList(String string, Object object, Iterable<URI> iterable) throws IOException, URISyntaxException {
        if (iterable == null) {
            return null;
        }
        for (URI uRI : iterable) {
            ModuleSource moduleSource = this.loadFromUri(uRI.resolve(string), uRI, object);
            if (moduleSource == null) continue;
            return moduleSource;
        }
        return null;
    }

    @Override
    protected ModuleSource loadFromUri(URI uRI, URI uRI2, Object object) throws IOException, URISyntaxException {
        URI uRI3 = new URI(uRI + ".js");
        ModuleSource moduleSource = this.loadFromActualUri(uRI3, uRI2, object);
        return moduleSource != null ? moduleSource : this.loadFromActualUri(uRI, uRI2, object);
    }

    protected ModuleSource loadFromActualUri(URI uRI, URI uRI2, Object object) throws IOException {
        URLValidator uRLValidator;
        URL uRL = new URL(uRI2 == null ? null : uRI2.toURL(), uRI.toString());
        long l = System.currentTimeMillis();
        URLConnection uRLConnection = this.openUrlConnection(uRL);
        URLValidator uRLValidator2 = object instanceof URLValidator ? ((uRLValidator = (URLValidator)object).appliesTo(uRI) ? uRLValidator : null) : null;
        if (uRLValidator2 != null) {
            uRLValidator2.applyConditionals(uRLConnection);
        }
        try {
            uRLConnection.connect();
            if (uRLValidator2 != null && uRLValidator2.updateValidator(uRLConnection, l, this.urlConnectionExpiryCalculator)) {
                this.close(uRLConnection);
                return NOT_MODIFIED;
            }
            return new ModuleSource(UrlModuleSourceProvider.getReader(uRLConnection), this.getSecurityDomain(uRLConnection), uRI, uRI2, new URLValidator(uRI, uRLConnection, l, this.urlConnectionExpiryCalculator));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (RuntimeException runtimeException) {
            this.close(uRLConnection);
            throw runtimeException;
        }
        catch (IOException iOException) {
            this.close(uRLConnection);
            throw iOException;
        }
    }

    private static Reader getReader(URLConnection uRLConnection) throws IOException {
        return new InputStreamReader(uRLConnection.getInputStream(), UrlModuleSourceProvider.getCharacterEncoding(uRLConnection));
    }

    private static String getCharacterEncoding(URLConnection uRLConnection) {
        ParsedContentType parsedContentType = new ParsedContentType(uRLConnection.getContentType());
        String string = parsedContentType.getEncoding();
        if (string != null) {
            return string;
        }
        String string2 = parsedContentType.getContentType();
        if (string2 != null && string2.startsWith("text/")) {
            return "8859_1";
        }
        return "utf-8";
    }

    private Object getSecurityDomain(URLConnection uRLConnection) {
        return this.urlConnectionSecurityDomainProvider == null ? null : this.urlConnectionSecurityDomainProvider.getSecurityDomain(uRLConnection);
    }

    private void close(URLConnection uRLConnection) {
        try {
            uRLConnection.getInputStream().close();
        }
        catch (IOException iOException) {
            this.onFailedClosingUrlConnection(uRLConnection, iOException);
        }
    }

    protected void onFailedClosingUrlConnection(URLConnection uRLConnection, IOException iOException) {
    }

    protected URLConnection openUrlConnection(URL uRL) throws IOException {
        return uRL.openConnection();
    }

    @Override
    protected boolean entityNeedsRevalidation(Object object) {
        return !(object instanceof URLValidator) || ((URLValidator)object).entityNeedsRevalidation();
    }

    private static class URLValidator
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final URI uri;
        private final long lastModified;
        private final String entityTags;
        private long expiry;

        public URLValidator(URI uRI, URLConnection uRLConnection, long l, UrlConnectionExpiryCalculator urlConnectionExpiryCalculator) {
            this.uri = uRI;
            this.lastModified = uRLConnection.getLastModified();
            this.entityTags = this.getEntityTags(uRLConnection);
            this.expiry = this.calculateExpiry(uRLConnection, l, urlConnectionExpiryCalculator);
        }

        boolean updateValidator(URLConnection uRLConnection, long l, UrlConnectionExpiryCalculator urlConnectionExpiryCalculator) throws IOException {
            boolean bl = this.isResourceChanged(uRLConnection);
            if (!bl) {
                this.expiry = this.calculateExpiry(uRLConnection, l, urlConnectionExpiryCalculator);
            }
            return bl;
        }

        private boolean isResourceChanged(URLConnection uRLConnection) throws IOException {
            if (uRLConnection instanceof HttpURLConnection) {
                return ((HttpURLConnection)uRLConnection).getResponseCode() == 304;
            }
            return this.lastModified == uRLConnection.getLastModified();
        }

        private long calculateExpiry(URLConnection uRLConnection, long l, UrlConnectionExpiryCalculator urlConnectionExpiryCalculator) {
            long l2;
            if ("no-cache".equals(uRLConnection.getHeaderField("Pragma"))) {
                return 0L;
            }
            String string = uRLConnection.getHeaderField("Cache-Control");
            if (string != null) {
                if (string.indexOf("no-cache") != -1) {
                    return 0L;
                }
                int n = this.getMaxAge(string);
                if (-1 != n) {
                    long l3 = System.currentTimeMillis();
                    long l4 = Math.max(0L, l3 - uRLConnection.getDate());
                    long l5 = Math.max(l4, (long)uRLConnection.getHeaderFieldInt("Age", 0) * 1000L);
                    long l6 = l3 - l;
                    long l7 = l5 + l6;
                    long l8 = l3 - l7;
                    return (long)n * 1000L + l8;
                }
            }
            if ((l2 = uRLConnection.getHeaderFieldDate("Expires", -1L)) != -1L) {
                return l2;
            }
            return urlConnectionExpiryCalculator == null ? 0L : urlConnectionExpiryCalculator.calculateExpiry(uRLConnection);
        }

        private int getMaxAge(String string) {
            int n = string.indexOf("max-age");
            if (n == -1) {
                return -1;
            }
            int n2 = string.indexOf(61, n + 7);
            if (n2 == -1) {
                return -1;
            }
            int n3 = string.indexOf(44, n2 + 1);
            String string2 = n3 == -1 ? string.substring(n2 + 1) : string.substring(n2 + 1, n3);
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }

        private String getEntityTags(URLConnection uRLConnection) {
            List<String> list = uRLConnection.getHeaderFields().get("ETag");
            if (list == null || list.isEmpty()) {
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder();
            Iterator<String> iterator = list.iterator();
            stringBuilder.append(iterator.next());
            while (iterator.hasNext()) {
                stringBuilder.append(", ").append(iterator.next());
            }
            return stringBuilder.toString();
        }

        boolean appliesTo(URI uRI) {
            return this.uri.equals(uRI);
        }

        void applyConditionals(URLConnection uRLConnection) {
            if (this.lastModified != 0L) {
                uRLConnection.setIfModifiedSince(this.lastModified);
            }
            if (this.entityTags != null && this.entityTags.length() > 0) {
                uRLConnection.addRequestProperty("If-None-Match", this.entityTags);
            }
        }

        boolean entityNeedsRevalidation() {
            return System.currentTimeMillis() > this.expiry;
        }
    }
}

