#
# Author:: Matheus Francisco Barra Mina (<mfbmina@gmail.com>)
# © Copyright IBM Corporation 2015.
#
# LICENSE: MIT (http://opensource.org/licenses/MIT)
#
module Fog
  module Compute
    class Softlayer
      class Mock
        # Gets all Virtual Guest buy options
        # @return [Excon::Response]
        def get_virtual_guest_create_options
          response = Excon::Response.new
          response.body = virtual_guest_options
          response.status = 200
          response
        end
      end

      class Real
        def get_virtual_guest_create_options
          request(:virtual_guest, "getCreateObjectOptions", :http_method => :GET)
        end
      end
    end
  end
end

module Fog
  module Compute
    class Softlayer
      class Mock
        def virtual_guest_options
          {
            "blockDevices"=>
              [
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>"0",
                      "recurringFee"=>"0",
                      "item"=>
                        {
                          "description"=>"25 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"0",
                            "diskImage"=>
                              {
                                "capacity"=>25
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".014",
                      "recurringFee"=>"10.29",
                      "item"=>
                        {
                          "description"=>"100 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"0",
                            "diskImage"=>
                              {
                                "capacity"=>100
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".006",
                      "recurringFee"=>"4.57",
                      "item"=>
                        {
                          "description"=>"10 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"2",
                            "diskImage"=>
                              {
                                "capacity"=>10
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".008",
                      "recurringFee"=>"5.71",
                      "item"=>
                        {
                          "description"=>"20 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"2",
                            "diskImage"=>
                              {
                                "capacity"=>20
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".009",
                      "recurringFee"=>"6.5",
                      "item"=>
                        {
                          "description"=>"25 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"2",
                            "diskImage"=>
                              {
                                "capacity"=>25
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".01",
                      "recurringFee"=>"6.86",
                      "item"=>
                        {
                          "description"=>"30 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"2",
                            "diskImage"=>
                              {
                                "capacity"=>30
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".011",
                      "recurringFee"=>"8",
                      "item"=>
                        {
                          "description"=>"40 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"2",
                            "diskImage"=>
                              {
                                "capacity"=>40
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".012",
                      "recurringFee"=>"9.14",
                      "item"=>
                        {
                          "description"=>"50 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"2",
                            "diskImage"=>
                              {
                                "capacity"=>50
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".013",
                      "recurringFee"=>"9.71",
                      "item"=>
                        {
                          "description"=>"75 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"2",
                            "diskImage"=>
                              {
                                "capacity"=>75
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".014",
                      "recurringFee"=>"10.29",
                      "item"=>
                        {
                          "description"=>"100 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"2",
                            "diskImage"=>
                              {
                                "capacity"=>100
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".015",
                      "recurringFee"=>"10.86",
                      "item"=>
                        {
                          "description"=>"125 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"2",
                            "diskImage"=>
                              {
                                "capacity"=>125
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".016",
                      "recurringFee"=>"11.43",
                      "item"=>
                        {
                          "description"=>"150 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"2",
                            "diskImage"=>
                              {
                                "capacity"=>150
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".017",
                      "recurringFee"=>"12",
                      "item"=>
                        {
                          "description"=>"175 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"2",
                            "diskImage"=>
                              {
                                "capacity"=>175
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".018",
                      "recurringFee"=>"12.57",
                      "item"=>
                        {
                          "description"=>"200 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"2",
                            "diskImage"=>
                              {
                                "capacity"=>200
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".02",
                      "recurringFee"=>"14.29",
                      "item"=>
                        {
                          "description"=>"250 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"2",
                            "diskImage"=>
                              {
                                "capacity"=>250
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".025",
                      "recurringFee"=>"18.57",
                      "item"=>
                        {
                          "description"=>"300 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"2",
                            "diskImage"=>
                              {
                                "capacity"=>300
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".031",
                      "recurringFee"=>"22.86",
                      "item"=>
                        {
                          "description"=>"350 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"2",
                            "diskImage"=>
                              {
                                "capacity"=>350
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".035",
                      "recurringFee"=>"25.71",
                      "item"=>
                        {
                          "description"=>"400 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"2",
                            "diskImage"=>
                              {
                                "capacity"=>400
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".039",
                      "recurringFee"=>"28.57",
                      "item"=>
                        {
                          "description"=>"500 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"2",
                            "diskImage"=>
                              {
                                "capacity"=>500
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".059",
                      "recurringFee"=>"42.86",
                      "item"=>
                        {
                          "description"=>"750 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"2",
                            "diskImage"=>
                              {
                                "capacity"=>750
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".078",
                      "recurringFee"=>"57.14",
                      "item"=>
                        {
                          "description"=>"1.00 TB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"2",
                            "diskImage"=>
                              {
                                "capacity"=>1000
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".117",
                      "recurringFee"=>"85.71",
                      "item"=>
                        {
                          "description"=>"1.50 TB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"2",
                            "diskImage"=>
                              {
                                "capacity"=>1500
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".157",
                      "recurringFee"=>"114.29",
                      "item"=>
                        {
                          "description"=>"2.00 TB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"2",
                            "diskImage"=>
                              {
                                "capacity"=>2000
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".006",
                      "recurringFee"=>"4.57",
                      "item"=>
                        {
                          "description"=>"10 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"3",
                            "diskImage"=>
                              {
                                "capacity"=>10
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".008",
                      "recurringFee"=>"5.71",
                      "item"=>
                        {
                          "description"=>"20 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"3",
                            "diskImage"=>
                              {
                                "capacity"=>20
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".009",
                      "recurringFee"=>"6.5",
                      "item"=>
                        {
                          "description"=>"25 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"3",
                            "diskImage"=>
                              {
                                "capacity"=>25
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".01",
                      "recurringFee"=>"6.86",
                      "item"=>
                        {
                          "description"=>"30 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"3",
                            "diskImage"=>
                              {
                                "capacity"=>30
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".011",
                      "recurringFee"=>"8",
                      "item"=>
                        {
                          "description"=>"40 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"3",
                            "diskImage"=>
                              {
                                "capacity"=>40
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".012",
                      "recurringFee"=>"9.14",
                      "item"=>
                        {
                          "description"=>"50 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"3",
                            "diskImage"=>
                              {
                                "capacity"=>50
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".013",
                      "recurringFee"=>"9.71",
                      "item"=>
                        {
                          "description"=>"75 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"3",
                            "diskImage"=>
                              {
                                "capacity"=>75
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".014",
                      "recurringFee"=>"10.29",
                      "item"=>
                        {
                          "description"=>"100 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"3",
                            "diskImage"=>
                              {
                                "capacity"=>100
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".015",
                      "recurringFee"=>"10.86",
                      "item"=>
                        {
                          "description"=>"125 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"3",
                            "diskImage"=>
                              {
                                "capacity"=>125
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".016",
                      "recurringFee"=>"11.43",
                      "item"=>
                        {
                          "description"=>"150 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"3",
                            "diskImage"=>
                              {
                                "capacity"=>150
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".017",
                      "recurringFee"=>"12",
                      "item"=>
                        {
                          "description"=>"175 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"3",
                            "diskImage"=>
                              {
                                "capacity"=>175
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".018",
                      "recurringFee"=>"12.57",
                      "item"=>
                        {
                          "description"=>"200 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"3",
                            "diskImage"=>
                              {
                                "capacity"=>200
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".02",
                      "recurringFee"=>"14.29",
                      "item"=>
                        {
                          "description"=>"250 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"3",
                            "diskImage"=>
                              {
                                "capacity"=>250
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".025",
                      "recurringFee"=>"18.57",
                      "item"=>
                        {
                          "description"=>"300 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"3",
                            "diskImage"=>
                              {
                                "capacity"=>300
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".031",
                      "recurringFee"=>"22.86",
                      "item"=>
                        {
                          "description"=>"350 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"3",
                            "diskImage"=>
                              {
                                "capacity"=>350
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".035",
                      "recurringFee"=>"25.71",
                      "item"=>
                        {
                          "description"=>"400 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"3",
                            "diskImage"=>
                              {
                                "capacity"=>400
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".039",
                      "recurringFee"=>"28.57",
                      "item"=>
                        {
                          "description"=>"500 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"3",
                            "diskImage"=>
                              {
                                "capacity"=>500
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".059",
                      "recurringFee"=>"42.86",
                      "item"=>
                        {
                          "description"=>"750 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"3",
                            "diskImage"=>
                              {
                                "capacity"=>750
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".078",
                      "recurringFee"=>"57.14",
                      "item"=>
                        {
                          "description"=>"1.00 TB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"3",
                            "diskImage"=>
                              {
                                "capacity"=>1000
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".117",
                      "recurringFee"=>"85.71",
                      "item"=>
                        {
                          "description"=>"1.50 TB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"3",
                            "diskImage"=>
                              {
                                "capacity"=>1500
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".157",
                      "recurringFee"=>"114.29",
                      "item"=>
                        {
                          "description"=>"2.00 TB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"3",
                            "diskImage"=>
                              {
                                "capacity"=>2000
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".006",
                      "recurringFee"=>"4.57",
                      "item"=>
                        {
                          "description"=>"10 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"4",
                            "diskImage"=>
                              {
                                "capacity"=>10
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".008",
                      "recurringFee"=>"5.71",
                      "item"=>
                        {
                          "description"=>"20 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"4",
                            "diskImage"=>
                              {
                                "capacity"=>20
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".009",
                      "recurringFee"=>"6.5",
                      "item"=>
                        {
                          "description"=>"25 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"4",
                            "diskImage"=>
                              {
                                "capacity"=>25
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".01",
                      "recurringFee"=>"6.86",
                      "item"=>
                        {
                          "description"=>"30 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"4",
                            "diskImage"=>
                              {
                                "capacity"=>30
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".011",
                      "recurringFee"=>"8",
                      "item"=>
                        {
                          "description"=>"40 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"4",
                            "diskImage"=>
                              {
                                "capacity"=>40
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".012",
                      "recurringFee"=>"9.14",
                      "item"=>
                        {
                          "description"=>"50 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"4",
                            "diskImage"=>
                              {
                                "capacity"=>50
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".013",
                      "recurringFee"=>"9.71",
                      "item"=>
                        {
                          "description"=>"75 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"4",
                            "diskImage"=>
                              {
                                "capacity"=>75
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".014",
                      "recurringFee"=>"10.29",
                      "item"=>
                        {
                          "description"=>"100 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"4",
                            "diskImage"=>
                              {
                                "capacity"=>100
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".015",
                      "recurringFee"=>"10.86",
                      "item"=>
                        {
                          "description"=>"125 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"4",
                            "diskImage"=>
                              {
                                "capacity"=>125
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".016",
                      "recurringFee"=>"11.43",
                      "item"=>
                        {
                          "description"=>"150 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"4",
                            "diskImage"=>
                              {
                                "capacity"=>150
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".017",
                      "recurringFee"=>"12",
                      "item"=>
                        {
                          "description"=>"175 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"4",
                            "diskImage"=>
                              {
                                "capacity"=>175
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".018",
                      "recurringFee"=>"12.57",
                      "item"=>
                        {
                          "description"=>"200 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"4",
                            "diskImage"=>
                              {
                                "capacity"=>200
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".02",
                      "recurringFee"=>"14.29",
                      "item"=>
                        {
                          "description"=>"250 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"4",
                            "diskImage"=>
                              {
                                "capacity"=>250
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".025",
                      "recurringFee"=>"18.57",
                      "item"=>
                        {
                          "description"=>"300 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"4",
                            "diskImage"=>
                              {
                                "capacity"=>300
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".031",
                      "recurringFee"=>"22.86",
                      "item"=>
                        {
                          "description"=>"350 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"4",
                            "diskImage"=>
                              {
                                "capacity"=>350
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".035",
                      "recurringFee"=>"25.71",
                      "item"=>
                        {
                          "description"=>"400 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"4",
                            "diskImage"=>
                              {
                                "capacity"=>400
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".039",
                      "recurringFee"=>"28.57",
                      "item"=>
                        {
                          "description"=>"500 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"4",
                            "diskImage"=>
                              {
                                "capacity"=>500
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".059",
                      "recurringFee"=>"42.86",
                      "item"=>
                        {
                          "description"=>"750 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"4",
                            "diskImage"=>
                              {
                                "capacity"=>750
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".078",
                      "recurringFee"=>"57.14",
                      "item"=>
                        {
                          "description"=>"1.00 TB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"4",
                            "diskImage"=>
                              {
                                "capacity"=>1000
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".117",
                      "recurringFee"=>"85.71",
                      "item"=>
                        {
                          "description"=>"1.50 TB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"4",
                            "diskImage"=>
                              {
                                "capacity"=>1500
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".157",
                      "recurringFee"=>"114.29",
                      "item"=>
                        {
                          "description"=>"2.00 TB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"4",
                            "diskImage"=>
                              {
                                "capacity"=>2000
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".006",
                      "recurringFee"=>"4.57",
                      "item"=>
                        {
                          "description"=>"10 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"5",
                            "diskImage"=>
                              {
                                "capacity"=>10
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".008",
                      "recurringFee"=>"5.71",
                      "item"=>
                        {
                          "description"=>"20 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"5",
                            "diskImage"=>
                              {
                                "capacity"=>20
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".009",
                      "recurringFee"=>"6.5",
                      "item"=>
                        {
                          "description"=>"25 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"5",
                            "diskImage"=>
                              {
                                "capacity"=>25
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".01",
                      "recurringFee"=>"6.86",
                      "item"=>
                        {
                          "description"=>"30 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"5",
                            "diskImage"=>
                              {
                                "capacity"=>30
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".011",
                      "recurringFee"=>"8",
                      "item"=>
                        {
                          "description"=>"40 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"5",
                            "diskImage"=>
                              {
                                "capacity"=>40
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".012",
                      "recurringFee"=>"9.14",
                      "item"=>
                        {
                          "description"=>"50 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"5",
                            "diskImage"=>
                              {
                                "capacity"=>50
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".013",
                      "recurringFee"=>"9.71",
                      "item"=>
                        {
                          "description"=>"75 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"5",
                            "diskImage"=>
                              {
                                "capacity"=>75
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".014",
                      "recurringFee"=>"10.29",
                      "item"=>
                        {
                          "description"=>"100 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"5",
                            "diskImage"=>
                              {
                                "capacity"=>100
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".015",
                      "recurringFee"=>"10.86",
                      "item"=>
                        {
                          "description"=>"125 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"5",
                            "diskImage"=>
                              {
                                "capacity"=>125
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".016",
                      "recurringFee"=>"11.43",
                      "item"=>
                        {
                          "description"=>"150 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"5",
                            "diskImage"=>
                              {
                                "capacity"=>150
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".017",
                      "recurringFee"=>"12",
                      "item"=>
                        {
                          "description"=>"175 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"5",
                            "diskImage"=>
                              {
                                "capacity"=>175
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".018",
                      "recurringFee"=>"12.57",
                      "item"=>
                        {
                          "description"=>"200 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"5",
                            "diskImage"=>
                              {
                                "capacity"=>200
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".02",
                      "recurringFee"=>"14.29",
                      "item"=>
                        {
                          "description"=>"250 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"5",
                            "diskImage"=>
                              {
                                "capacity"=>250
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".025",
                      "recurringFee"=>"18.57",
                      "item"=>
                        {
                          "description"=>"300 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"5",
                            "diskImage"=>
                              {
                                "capacity"=>300
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".031",
                      "recurringFee"=>"22.86",
                      "item"=>
                        {
                          "description"=>"350 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"5",
                            "diskImage"=>
                              {
                                "capacity"=>350
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".035",
                      "recurringFee"=>"25.71",
                      "item"=>
                        {
                          "description"=>"400 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"5",
                            "diskImage"=>
                              {
                                "capacity"=>400
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".039",
                      "recurringFee"=>"28.57",
                      "item"=>
                        {
                          "description"=>"500 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"5",
                            "diskImage"=>
                              {
                                "capacity"=>500
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".059",
                      "recurringFee"=>"42.86",
                      "item"=>
                        {
                          "description"=>"750 GB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"5",
                            "diskImage"=>
                              {
                                "capacity"=>750
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".078",
                      "recurringFee"=>"57.14",
                      "item"=>
                        {
                          "description"=>"1.00 TB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"5",
                            "diskImage"=>
                              {
                                "capacity"=>1000
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".117",
                      "recurringFee"=>"85.71",
                      "item"=>
                        {
                          "description"=>"1.50 TB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"5",
                            "diskImage"=>
                              {
                                "capacity"=>1500
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".157",
                      "recurringFee"=>"114.29",
                      "item"=>
                        {
                          "description"=>"2.00 TB (SAN)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"5",
                            "diskImage"=>
                              {
                                "capacity"=>2000
                              }
                          }
                        ],
                      "localDiskFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>"0",
                      "recurringFee"=>"0",
                      "item"=>
                        {
                          "description"=>"25 GB (LOCAL)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"0",
                            "diskImage"=>
                              {
                                "capacity"=>25
                              }
                          }
                        ],
                      "localDiskFlag"=>true
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".005",
                      "recurringFee"=>"4",
                      "item"=>
                        {
                          "description"=>"100 GB (LOCAL)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"0",
                            "diskImage"=>
                              {
                                "capacity"=>100
                              }
                          }
                        ],
                      "localDiskFlag"=>true
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".002",
                      "recurringFee"=>"1",
                      "item"=>
                        {
                          "description"=>"25 GB (LOCAL)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"2",
                            "diskImage"=>
                              {
                                "capacity"=>25
                              }
                          }
                        ],
                      "localDiskFlag"=>true
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".005",
                      "recurringFee"=>"4",
                      "item"=>
                        {
                          "description"=>"100 GB (LOCAL)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"2",
                            "diskImage"=>
                              {
                                "capacity"=>100
                              }
                          }
                        ],
                      "localDiskFlag"=>true
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".008",
                      "recurringFee"=>"6",
                      "item"=>
                        {
                          "description"=>"150 GB (LOCAL)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"2",
                            "diskImage"=>
                              {
                                "capacity"=>150
                              }
                          }
                        ],
                      "localDiskFlag"=>true
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".011",
                      "recurringFee"=>"8",
                      "item"=>
                        {
                          "description"=>"200 GB (LOCAL)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"2",
                            "diskImage"=>
                              {
                                "capacity"=>200
                              }
                          }
                        ],
                      "localDiskFlag"=>true
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".016",
                      "recurringFee"=>"12",
                      "item"=>
                        {
                          "description"=>"300 GB (LOCAL)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "blockDevices"=>
                        [
                          {
                            "device"=>"2",
                            "diskImage"=>
                              {
                                "capacity"=>300
                              }
                          }
                        ],
                      "localDiskFlag"=>true
                    }
                }
              ],
            "datacenters"=>
              [
                {
                  "template"=>
                    {
                      "datacenter"=>
                        {
                          "name"=>"wdc01"
                        }
                    }
                },
                {
                  "template"=>
                    {
                      "datacenter"=>
                        {
                          "name"=>"sjc01"
                        }
                    }
                },
                {
                  "template"=>
                    {
                      "datacenter"=>
                        {
                          "name"=>"sea01"
                        }
                    }
                },
                {
                  "template"=>
                    {
                      "datacenter"=>
                        {
                          "name"=>"dal01"
                        }
                    }
                },
                {
                  "template"=>
                    {
                      "datacenter"=>
                        {
                          "name"=>"dal05"
                        }
                    }
                },
                {
                  "template"=>
                    {
                      "datacenter"=>
                        {
                          "name"=>"dal06"
                        }
                    }
                },
                {
                  "template"=>
                    {
                      "datacenter"=>
                        {
                          "name"=>"dal09"
                        }
                    }
                },
                {
                  "template"=>
                    {
                      "datacenter"=>
                        {
                          "name"=>"hou02"
                        }
                    }
                },
                {
                  "template"=>
                    {
                      "datacenter"=>
                        {
                          "name"=>"sng01"
                        }
                    }
                },
                {
                  "template"=>
                    {
                      "datacenter"=>
                        {
                          "name"=>"lon02"
                        }
                    }
                },
                {
                  "template"=>
                    {
                      "datacenter"=>
                        {
                          "name"=>"ams01"
                        }
                    }
                },
                {
                  "template"=>
                    {
                      "datacenter"=>
                        {
                          "name"=>"hkg02"
                        }
                    }
                },
                {
                  "template"=>
                    {
                      "datacenter"=>
                        {
                          "name"=>"tor01"
                        }
                    }
                },
                {
                  "template"=>
                    {
                      "datacenter"=>
                        {
                          "name"=>"mel01"
                        }
                    }
                },
                {
                  "template"=>
                    {
                      "datacenter"=>
                        {
                          "name"=>"par01"
                        }
                    }
                },
                {
                  "template"=>
                    {
                      "datacenter"=>
                        {
                          "name"=>"mex01"
                        }
                    }
                },
                {
                  "template"=>
                    {
                      "datacenter"=>
                        {
                          "name"=>"tok02"
                        }
                    }
                },
                {
                  "template"=>
                    {
                      "datacenter"=>
                        {
                          "name"=>"fra02"
                        }
                    }
                }
              ],
            "memory"=>
              [
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".019",
                      "recurringFee"=>"12.6",
                      "item"=>
                        {
                          "description"=>"1 GB"
                        }
                    },
                  "template"=>
                    {
                      "maxMemory"=>1024
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".038",
                      "recurringFee"=>"25.2",
                      "item"=>
                        {
                          "description"=>"2 GB"
                        }
                    },
                  "template"=>
                    {
                      "maxMemory"=>2048
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".077",
                      "recurringFee"=>"50.4",
                      "item"=>
                        {
                          "description"=>"4 GB"
                        }
                    },
                  "template"=>
                    {
                      "maxMemory"=>4096
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".11",
                      "recurringFee"=>"72",
                      "item"=>
                        {
                          "description"=>"6 GB"
                        }
                    },
                  "template"=>
                    {
                      "maxMemory"=>6144
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".142",
                      "recurringFee"=>"93.6",
                      "item"=>
                        {
                          "description"=>"8 GB"
                        }
                    },
                  "template"=>
                    {
                      "maxMemory"=>8192
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".197",
                      "recurringFee"=>"129.6",
                      "item"=>
                        {
                          "description"=>"12 GB"
                        }
                    },
                  "template"=>
                    {
                      "maxMemory"=>12288
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".252",
                      "recurringFee"=>"165.6",
                      "item"=>
                        {
                          "description"=>"16 GB"
                        }
                    },
                  "template"=>
                    {
                      "maxMemory"=>16384
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".427",
                      "recurringFee"=>"280.8",
                      "item"=>
                        {
                          "description"=>"32 GB"
                        }
                    },
                  "template"=>
                    {
                      "maxMemory"=>32768
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".559",
                      "recurringFee"=>"367.2",
                      "item"=>
                        {
                          "description"=>"48 GB"
                        }
                    },
                  "template"=>
                    {
                      "maxMemory"=>49152
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".69",
                      "recurringFee"=>"453.6",
                      "item"=>
                        {
                          "description"=>"64 GB"
                        }
                    },
                  "template"=>
                    {
                      "maxMemory"=>65536
                    }
                }
              ],
            "networkComponents"=>
              [
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>"0",
                      "recurringFee"=>"0",
                      "item"=>
                        {
                          "description"=>"10 Mbps Public & Private Network Uplinks"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "networkComponents"=>
                        [
                          {
                            "maxSpeed"=>10
                          }
                        ],
                      "privateNetworkOnlyFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>"0",
                      "recurringFee"=>"0",
                      "item"=>
                        {
                          "description"=>"100 Mbps Public & Private Network Uplinks"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "networkComponents"=>
                        [
                          {
                            "maxSpeed"=>100
                          }
                        ],
                      "privateNetworkOnlyFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".04",
                      "recurringFee"=>"20",
                      "item"=>
                        {
                          "description"=>"1 Gbps Public & Private Network Uplinks"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "networkComponents"=>
                        [
                          {
                            "maxSpeed"=>1000
                          }
                        ],
                      "privateNetworkOnlyFlag"=>false
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>"0",
                      "recurringFee"=>"0",
                      "item"=>
                        {
                          "description"=>"10 Mbps Private Network Uplink"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "networkComponents"=>
                        [
                          {
                            "maxSpeed"=>10
                          }
                        ],
                      "privateNetworkOnlyFlag"=>true
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>"0",
                      "recurringFee"=>"0",
                      "item"=>
                        {
                          "description"=>"100 Mbps Private Network Uplink"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "networkComponents"=>
                        [
                          {
                            "maxSpeed"=>100
                          }
                        ],
                      "privateNetworkOnlyFlag"=>true
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".02",
                      "recurringFee"=>"10",
                      "item"=>
                        {
                          "description"=>"1 Gbps Private Network Uplink"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "networkComponents"=>
                        [
                          {
                            "maxSpeed"=>1000
                          }
                        ],
                      "privateNetworkOnlyFlag"=>true
                    }
                }
              ],
            "operatingSystems"=>
              [
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>"0",
                      "recurringFee"=>"0",
                      "item"=>
                        {
                          "description"=>"CentOS - Latest"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"CENTOS_LATEST"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>"0",
                      "recurringFee"=>"0",
                      "item"=>
                        {
                          "description"=>"CentOS - Latest (64 bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"CENTOS_LATEST_64"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>"0",
                      "recurringFee"=>"0",
                      "item"=>
                        {
                          "description"=>"CentOS - Latest (32 bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"CENTOS_LATEST_32"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>"0",
                      "recurringFee"=>"0",
                      "item"=>
                        {
                          "description"=>"CentOS 7.x - Minimal Install (64 bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"CENTOS_7_64"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>"0",
                      "recurringFee"=>"0",
                      "item"=>
                        {
                          "description"=>"CentOS 6.x - Minimal Install (64 bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"CENTOS_6_64"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>"0",
                      "recurringFee"=>"0",
                      "item"=>
                        {
                          "description"=>"CentOS 6.x - Minimal Install (32 bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"CENTOS_6_32"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>"0",
                      "recurringFee"=>"0",
                      "item"=>
                        {
                          "description"=>"CentOS 5.x - Minimal Install (64 bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"CENTOS_5_64"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>"0",
                      "recurringFee"=>"0",
                      "item"=>
                        {
                          "description"=>"CentOS 5.x - Minimal Install (32 bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"CENTOS_5_32"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "recurringFee"=>"12",
                      "item"=>
                        {
                          "description"=>"CloudLinux - Latest"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"CLOUDLINUX_LATEST"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "recurringFee"=>"12",
                      "item"=>
                        {
                          "description"=>"CloudLinux - Latest (64 bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"CLOUDLINUX_LATEST_64"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "recurringFee"=>"12",
                      "item"=>
                        {
                          "description"=>"CloudLinux - Latest (32 bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"CLOUDLINUX_LATEST_32"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "recurringFee"=>"12",
                      "item"=>
                        {
                          "description"=>"CloudLinux 6.x (64 bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"CLOUDLINUX_6_64"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "recurringFee"=>"12",
                      "item"=>
                        {
                          "description"=>"CloudLinux 6.x (32 bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"CLOUDLINUX_6_32"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "recurringFee"=>"12",
                      "item"=>
                        {
                          "description"=>"CloudLinux 5.x (64 bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"CLOUDLINUX_5_64"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "recurringFee"=>"12",
                      "item"=>
                        {
                          "description"=>"CloudLinux 5.x (32 bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"CLOUDLINUX_5_32"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>"0",
                      "recurringFee"=>"0",
                      "item"=>
                        {
                          "description"=>"Debian - Latest"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"DEBIAN_LATEST"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>"0",
                      "recurringFee"=>"0",
                      "item"=>
                        {
                          "description"=>"Debian - Latest (64 bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"DEBIAN_LATEST_64"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>"0",
                      "recurringFee"=>"0",
                      "item"=>
                        {
                          "description"=>"Debian - Latest (32 bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"DEBIAN_LATEST_32"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>"0",
                      "recurringFee"=>"0",
                      "item"=>
                        {
                          "description"=>"Debian GNU/Linux 7.x Wheezy/Stable - Minimal Install (64 bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"DEBIAN_7_64"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>"0",
                      "recurringFee"=>"0",
                      "item"=>
                        {
                          "description"=>"Debian GNU/Linux 7.x Wheezy/Stable - Minimal Install (32 bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"DEBIAN_7_32"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>"0",
                      "recurringFee"=>"0",
                      "item"=>
                        {
                          "description"=>"Debian GNU/Linux 6.x Squeeze/Stable - Minimal Install (64 bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"DEBIAN_6_64"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>"0",
                      "recurringFee"=>"0",
                      "item"=>
                        {
                          "description"=>"Debian GNU/Linux 6.x Squeeze/Stable - Minimal Install (32 bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"DEBIAN_6_32"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".08",
                      "recurringFee"=>"45",
                      "item"=>
                        {
                          "description"=>"Redhat EL - Latest"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"REDHAT_LATEST"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".08",
                      "recurringFee"=>"45",
                      "item"=>
                        {
                          "description"=>"Redhat EL - Latest (64 bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"REDHAT_LATEST_64"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".08",
                      "recurringFee"=>"45",
                      "item"=>
                        {
                          "description"=>"Redhat EL - Latest (32 bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"REDHAT_LATEST_32"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".08",
                      "recurringFee"=>"45",
                      "item"=>
                        {
                          "description"=>"Red Hat Enterprise Linux 6.x - Minimal Install (64 bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"REDHAT_6_64"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".08",
                      "recurringFee"=>"45",
                      "item"=>
                        {
                          "description"=>"Red Hat Enterprise Linux 6.x - Minimal Install (32 bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"REDHAT_6_32"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".08",
                      "recurringFee"=>"45",
                      "item"=>
                        {
                          "description"=>"Red Hat Enterprise Linux 5.x - Minimal Install (64 bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"REDHAT_5_64"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".08",
                      "recurringFee"=>"45",
                      "item"=>
                        {
                          "description"=>"Red Hat Enterprise Linux 5.x - Minimal Install (32 bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"REDHAT_5_32"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>"0",
                      "recurringFee"=>"0",
                      "item"=>
                        {
                          "description"=>"Ubuntu - Latest"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"UBUNTU_LATEST"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>"0",
                      "recurringFee"=>"0",
                      "item"=>
                        {
                          "description"=>"Ubuntu - Latest (64 bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"UBUNTU_LATEST_64"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>"0",
                      "recurringFee"=>"0",
                      "item"=>
                        {
                          "description"=>"Ubuntu - Latest (32 bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"UBUNTU_LATEST_32"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>"0",
                      "recurringFee"=>"0",
                      "item"=>
                        {
                          "description"=>"Ubuntu Linux 14.04 LTS Trusty Tahr - Minimal Install (64 bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"UBUNTU_14_64"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>"0",
                      "recurringFee"=>"0",
                      "item"=>
                        {
                          "description"=>"Ubuntu Linux 14.04 LTS Trusty Tahr - Minimal Install (32 bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"UBUNTU_14_32"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>"0",
                      "recurringFee"=>"0",
                      "item"=>
                        {
                          "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin - Minimal Install (64 bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"UBUNTU_12_64"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>"0",
                      "recurringFee"=>"0",
                      "item"=>
                        {
                          "description"=>"Ubuntu Linux 12.04 LTS Precise Pangolin - Minimal Install (32 bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"UBUNTU_12_32"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>"0",
                      "recurringFee"=>"0",
                      "item"=>
                        {
                          "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx - Minimal Install (64 bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"UBUNTU_10_64"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>"0",
                      "recurringFee"=>"0",
                      "item"=>
                        {
                          "description"=>"Ubuntu Linux 10.04 LTS Lucid Lynx - Minimal Install (32 bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"UBUNTU_10_32"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>"0",
                      "recurringFee"=>"0",
                      "item"=>
                        {
                          "description"=>"Vyatta Vyatta Community Edition for VSI - Latest"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"VYATTACE_LATEST"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>"0",
                      "recurringFee"=>"0",
                      "item"=>
                        {
                          "description"=>"Vyatta Vyatta Community Edition for VSI - Latest (64 bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"VYATTACE_LATEST_64"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>"0",
                      "recurringFee"=>"0",
                      "item"=>
                        {
                          "description"=>"Vyatta 6.6 Community Edition (64 bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"VYATTACE_6.6_64"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>"0",
                      "recurringFee"=>"0",
                      "item"=>
                        {
                          "description"=>"Vyatta 6.5 Community Edition (64 bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"VYATTACE_6.5_64"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".024",
                      "recurringFee"=>"17",
                      "item"=>
                        {
                          "description"=>"Windows - Latest"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"WIN_LATEST"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".024",
                      "recurringFee"=>"17",
                      "item"=>
                        {
                          "description"=>"Windows - Latest (64 bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"WIN_LATEST_64"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".024",
                      "recurringFee"=>"17",
                      "item"=>
                        {
                          "description"=>"Windows - Latest (32 bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"WIN_LATEST_32"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".024",
                      "recurringFee"=>"17",
                      "item"=>
                        {
                          "description"=>"Windows Server 2012 Standard Edition (64 bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"WIN_2012-STD_64"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".18",
                      "recurringFee"=>"125",
                      "item"=>
                        {
                          "description"=>"Windows Server 2012 Datacenter Edition (64bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"WIN_2012-DC_64"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".024",
                      "recurringFee"=>"17",
                      "item"=>
                        {
                          "description"=>"Windows Server 2008 Standard Edition SP2 (64bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"WIN_2008-STD-SP2_64"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".024",
                      "recurringFee"=>"17",
                      "item"=>
                        {
                          "description"=>"Windows Server 2008 Standard Edition SP2 (32bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"WIN_2008-STD-SP2_32"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".024",
                      "recurringFee"=>"17",
                      "item"=>
                        {
                          "description"=>"Windows Server 2008 Standard SP1 with R2 (64 bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"WIN_2008-STD-R2-SP1_64"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".024",
                      "recurringFee"=>"17",
                      "item"=>
                        {
                          "description"=>"Windows Server 2008 R2 Standard Edition (64bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"WIN_2008-STD-R2_64"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".092",
                      "recurringFee"=>"64",
                      "item"=>
                        {
                          "description"=>"Windows Server 2008 Enterprise Edition SP2 (64bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"WIN_2008-ENT-SP2_64"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".092",
                      "recurringFee"=>"64",
                      "item"=>
                        {
                          "description"=>"Windows Server 2008 Enterprise Edition SP2 (32bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"WIN_2008-ENT-SP2_32"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".092",
                      "recurringFee"=>"64",
                      "item"=>
                        {
                          "description"=>"Windows Server 2008 R2 Enterprise Edition (64bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"WIN_2008-ENT-R2_64"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".18",
                      "recurringFee"=>"125",
                      "item"=>
                        {
                          "description"=>"Windows Server 2008 Datacenter Edition SP2 (64bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"WIN_2008-DC-SP2_64"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".18",
                      "recurringFee"=>"125",
                      "item"=>
                        {
                          "description"=>"Windows Server 2008 R2 Datacenter Edition (64bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"WIN_2008-DC-R2_64"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".024",
                      "recurringFee"=>"17",
                      "item"=>
                        {
                          "description"=>"Windows Server 2003 Standard SP2 with R2 (64 bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"WIN_2003-STD-SP2-5_64"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".024",
                      "recurringFee"=>"17",
                      "item"=>
                        {
                          "description"=>"Windows Server 2003 Standard SP2 with R2 (32 bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"WIN_2003-STD-SP2-5_32"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".092",
                      "recurringFee"=>"64",
                      "item"=>
                        {
                          "description"=>"Windows Server 2003 Enterprise SP2 with R2 (64 bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"WIN_2003-ENT-SP2-5_64"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".092",
                      "recurringFee"=>"64",
                      "item"=>
                        {
                          "description"=>"Windows Server 2003 Enterprise SP2 with R2 (32 bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"WIN_2003-ENT-SP2-5_32"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".18",
                      "recurringFee"=>"125",
                      "item"=>
                        {
                          "description"=>"Windows Server 2003 Datacenter SP2 with R2 (64 bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"WIN_2003-DC-SP2-1_64"
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".18",
                      "recurringFee"=>"125",
                      "item"=>
                        {
                          "description"=>"Windows Server 2003 Datacenter SP2 with R2 (32 bit)"
                        }
                    },
                  "template"=>
                    {
                      "id"=>nil,
                      "operatingSystemReferenceCode"=>"WIN_2003-DC-SP2-1_32"
                    }
                }
              ],
            "processors"=>
              [
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".021",
                      "recurringFee"=>"15",
                      "item"=>
                        {
                          "description"=>"1 x 2.0 GHz Core"
                        }
                    },
                  "template"=>
                    {
                      "startCpus"=>1
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".041",
                      "recurringFee"=>"30",
                      "item"=>
                        {
                          "description"=>"2 x 2.0 GHz Cores"
                        }
                    },
                  "template"=>
                    {
                      "startCpus"=>2
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".082",
                      "recurringFee"=>"60",
                      "item"=>
                        {
                          "description"=>"4 x 2.0 GHz Cores"
                        }
                    },
                  "template"=>
                    {
                      "startCpus"=>4
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".164",
                      "recurringFee"=>"120",
                      "item"=>
                        {
                          "description"=>"8 x 2.0 GHz Cores"
                        }
                    },
                  "template"=>
                    {
                      "startCpus"=>8
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".247",
                      "recurringFee"=>"180",
                      "item"=>
                        {
                          "description"=>"12 x 2.0 GHz Cores"
                        }
                    },
                  "template"=>
                    {
                      "startCpus"=>12
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".329",
                      "recurringFee"=>"240",
                      "item"=>
                        {
                          "description"=>"16 x 2.0 GHz Cores"
                        }
                    },
                  "template"=>
                    {
                      "startCpus"=>16
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".2",
                      "recurringFee"=>"139",
                      "item"=>
                        {
                          "description"=>"Private 1 x 2.0 GHz Core"
                        }
                    },
                  "template"=>
                    {
                      "dedicatedAccountHostOnlyFlag"=>true,
                      "startCpus"=>1
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".223",
                      "recurringFee"=>"155",
                      "item"=>
                        {
                          "description"=>"Private 2 x 2.0 GHz Cores"
                        }
                    },
                  "template"=>
                    {
                      "dedicatedAccountHostOnlyFlag"=>true,
                      "startCpus"=>2
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".243",
                      "recurringFee"=>"169",
                      "item"=>
                        {
                          "description"=>"Private 4 x 2.0 GHz Cores"
                        }
                    },
                  "template"=>
                    {
                      "dedicatedAccountHostOnlyFlag"=>true,
                      "startCpus"=>4
                    }
                },
                {
                  "itemPrice"=>
                    {
                      "hourlyRecurringFee"=>".301",
                      "recurringFee"=>"209",
                      "item"=>
                        {
                          "description"=>"Private 8 x 2.0 GHz Cores"
                        }
                    },
                  "template"=>
                    {
                      "dedicatedAccountHostOnlyFlag"=>true,
                      "startCpus"=>8
                    }
                }
              ]
          }
        end
      end
    end
  end
end
