/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.resolver;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.SelfResolvingDependency;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.UnresolvedDependencyResult;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.plugins.ide.internal.resolver.IdeDependencyResolver;
import org.gradle.plugins.ide.internal.resolver.model.IdeExtendedRepoFileDependency;
import org.gradle.plugins.ide.internal.resolver.model.IdeLocalFileDependency;
import org.gradle.plugins.ide.internal.resolver.model.IdeProjectDependency;
import org.gradle.plugins.ide.internal.resolver.model.UnresolvedIdeRepoFileDependency;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultIdeDependencyResolver
implements IdeDependencyResolver {
    @Override
    public List<IdeProjectDependency> getIdeProjectDependencies(Configuration configuration, Project project) {
        ResolutionResult result = this.getIncomingResolutionResult(configuration);
        Set projectComponents = CollectionUtils.filter((Set)result.getAllComponents(), (Spec)new Spec<ResolvedComponentResult>(){

            public boolean isSatisfiedBy(ResolvedComponentResult element) {
                return element.getId() instanceof ProjectComponentIdentifier;
            }
        });
        ArrayList<IdeProjectDependency> ideProjectDependencies = new ArrayList<IdeProjectDependency>();
        for (ResolvedComponentResult projectComponent : projectComponents) {
            String resolvedProjectPath = ((ProjectComponentIdentifier)projectComponent.getId()).getProjectPath();
            if (project.getPath().equals(resolvedProjectPath)) continue;
            Project resolvedProject = project.findProject(resolvedProjectPath);
            if (resolvedProject == null) {
                ideProjectDependencies.add(new IdeProjectDependency(configuration.getName(), resolvedProjectPath));
                continue;
            }
            ideProjectDependencies.add(new IdeProjectDependency(configuration.getName(), resolvedProject));
        }
        return ideProjectDependencies;
    }

    @Override
    public List<UnresolvedIdeRepoFileDependency> getUnresolvedIdeRepoFileDependencies(Configuration configuration) {
        ResolutionResult result = this.getIncomingResolutionResult(configuration);
        List<UnresolvedDependencyResult> unresolvedDependencies = this.findAllUnresolvedDependencyResults(result.getRoot().getDependencies());
        ArrayList<UnresolvedIdeRepoFileDependency> unresolvedIdeRepoFileDependencies = new ArrayList<UnresolvedIdeRepoFileDependency>();
        for (UnresolvedDependencyResult unresolvedDependencyResult : unresolvedDependencies) {
            Throwable failure = unresolvedDependencyResult.getFailure();
            ComponentSelector componentSelector = unresolvedDependencyResult.getAttempted();
            String displayName = componentSelector.getDisplayName();
            File file = new File(this.unresolvedFileName(componentSelector));
            unresolvedIdeRepoFileDependencies.add(new UnresolvedIdeRepoFileDependency(configuration.getName(), file, failure, displayName));
        }
        return unresolvedIdeRepoFileDependencies;
    }

    private String unresolvedFileName(ComponentSelector componentSelector) {
        return "unresolved dependency - " + componentSelector.getDisplayName().replaceAll(":", " ");
    }

    @Override
    public List<IdeExtendedRepoFileDependency> getIdeRepoFileDependencies(Configuration configuration) {
        ResolutionResult result = this.getIncomingResolutionResult(configuration);
        Set resolvedRepoFileComponents = CollectionUtils.filter((Set)result.getAllComponents(), (Spec)new Spec<ResolvedComponentResult>(){

            public boolean isSatisfiedBy(ResolvedComponentResult element) {
                return element.getId() instanceof ModuleComponentIdentifier;
            }
        });
        Set<ModuleVersionIdentifier> mappedResolvedDependencies = this.mapResolvedDependencies(resolvedRepoFileComponents);
        Set<ResolvedArtifact> artifacts = this.getExternalArtifacts(configuration);
        ArrayList<IdeExtendedRepoFileDependency> externalDependencies = new ArrayList<IdeExtendedRepoFileDependency>();
        for (ResolvedArtifact artifact : artifacts) {
            if (!mappedResolvedDependencies.contains(artifact.getModuleVersion().getId())) continue;
            IdeExtendedRepoFileDependency ideRepoFileDependency = new IdeExtendedRepoFileDependency(configuration.getName(), artifact.getFile());
            ideRepoFileDependency.setId(artifact.getModuleVersion().getId());
            externalDependencies.add(ideRepoFileDependency);
        }
        return externalDependencies;
    }

    private Set<ModuleVersionIdentifier> mapResolvedDependencies(Set<ResolvedComponentResult> components) {
        LinkedHashSet<ModuleVersionIdentifier> mappedResolvedDependencies = new LinkedHashSet<ModuleVersionIdentifier>();
        for (ResolvedComponentResult component : components) {
            mappedResolvedDependencies.add(component.getModuleVersion());
        }
        return mappedResolvedDependencies;
    }

    @Override
    public List<IdeLocalFileDependency> getIdeLocalFileDependencies(Configuration configuration) {
        ArrayList<SelfResolvingDependency> externalDependencies = new ArrayList<SelfResolvingDependency>();
        this.findAllExternalDependencies(externalDependencies, new ArrayList<Dependency>(), configuration);
        ArrayList<IdeLocalFileDependency> ideLocalFileDependencies = new ArrayList<IdeLocalFileDependency>();
        for (SelfResolvingDependency externalDependency : externalDependencies) {
            Set resolvedFiles = externalDependency.resolve();
            for (File resolvedFile : resolvedFiles) {
                IdeLocalFileDependency ideLocalFileDependency = new IdeLocalFileDependency(configuration.getName(), resolvedFile);
                ideLocalFileDependencies.add(ideLocalFileDependency);
            }
        }
        return ideLocalFileDependencies;
    }

    private List<SelfResolvingDependency> findAllExternalDependencies(List<SelfResolvingDependency> externalDependencies, List<Dependency> visited, Configuration configuration) {
        for (Dependency dependency : configuration.getAllDependencies()) {
            if (visited.contains(dependency)) continue;
            visited.add(dependency);
            if (dependency instanceof ProjectDependency) {
                this.findAllExternalDependencies(externalDependencies, visited, ((ProjectDependency)dependency).getProjectConfiguration());
                continue;
            }
            if (!(dependency instanceof SelfResolvingDependency)) continue;
            externalDependencies.add((SelfResolvingDependency)dependency);
        }
        return externalDependencies;
    }

    private ResolutionResult getIncomingResolutionResult(Configuration configuration) {
        return configuration.getIncoming().getResolutionResult();
    }

    private List<UnresolvedDependencyResult> findAllUnresolvedDependencyResults(Set<? extends DependencyResult> dependencies) {
        ArrayList<UnresolvedDependencyResult> unresolvedDependencyResults = new ArrayList<UnresolvedDependencyResult>();
        for (DependencyResult dependencyResult : dependencies) {
            if (!(dependencyResult instanceof UnresolvedDependencyResult)) continue;
            unresolvedDependencyResults.add((UnresolvedDependencyResult)dependencyResult);
        }
        return unresolvedDependencyResults;
    }

    private Set<ResolvedArtifact> getExternalArtifacts(Configuration configuration) {
        return configuration.getResolvedConfiguration().getLenientConfiguration().getArtifacts(Specs.SATISFIES_ALL);
    }
}

