/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.util.HashMap;
import java.util.Map;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.OutputFilesCollectionSnapshotter;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OutputFilesSnapshotSerializer
implements Serializer<OutputFilesCollectionSnapshotter.OutputFilesSnapshot> {
    private final Serializer<FileCollectionSnapshot> serializer;
    private final StringInterner stringInterner;

    public OutputFilesSnapshotSerializer(Serializer<FileCollectionSnapshot> serializer, StringInterner stringInterner) {
        this.serializer = serializer;
        this.stringInterner = stringInterner;
    }

    public OutputFilesCollectionSnapshotter.OutputFilesSnapshot read(Decoder decoder) throws Exception {
        HashMap<String, Boolean> roots = new HashMap<String, Boolean>();
        int rootFileIdsCount = decoder.readSmallInt();
        for (int i = 0; i < rootFileIdsCount; ++i) {
            String key = this.stringInterner.intern(decoder.readString());
            roots.put(key, decoder.readBoolean());
        }
        FileCollectionSnapshot snapshot = (FileCollectionSnapshot)this.serializer.read(decoder);
        return new OutputFilesCollectionSnapshotter.OutputFilesSnapshot(roots, snapshot);
    }

    public void write(Encoder encoder, OutputFilesCollectionSnapshotter.OutputFilesSnapshot value) throws Exception {
        int roots = value.roots.size();
        encoder.writeSmallInt(roots);
        for (Map.Entry<String, Boolean> entry : value.roots.entrySet()) {
            encoder.writeString((CharSequence)entry.getKey());
            encoder.writeBoolean(entry.getValue().booleanValue());
        }
        this.serializer.write(encoder, (Object)value.filesSnapshot);
    }
}

