/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitCommand
implements Callable<Git> {
    private File directory;
    private boolean bare;

    @Override
    public Git call() throws GitAPIException {
        try {
            File d;
            RepositoryBuilder builder = new RepositoryBuilder();
            if (this.bare) {
                builder.setBare();
            }
            builder.readEnvironment();
            if (this.directory != null) {
                d = this.directory;
                if (!this.bare) {
                    d = new File(d, ".git");
                }
                builder.setGitDir(d);
            } else if (builder.getGitDir() == null) {
                d = new File(".");
                if (d.getParentFile() != null) {
                    d = d.getParentFile();
                }
                if (!this.bare) {
                    d = new File(d, ".git");
                }
                builder.setGitDir(d);
            }
            Object repository = builder.build();
            if (!((Repository)repository).getObjectDatabase().exists()) {
                ((Repository)repository).create(this.bare);
            }
            return new Git((Repository)repository);
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }

    public InitCommand setDirectory(File directory) {
        this.directory = directory;
        return this;
    }

    public InitCommand setBare(boolean bare) {
        this.bare = bare;
        return this;
    }
}

