// =================== DO NOT EDIT THIS FILE ====================
// Generated by Modello 1.8.1,
// any modifications will be overwritten.
// ==============================================================

package org.apache.maven.model;

/**
 * This elements describes all that pertains to distribution for a
 * project. It is
 *         primarily used for deployment of artifacts and the site
 * produced by the build.
 * 
 * @version $Revision$ $Date$
 */
@SuppressWarnings( "all" )
public class DistributionManagement
    implements java.io.Serializable, java.lang.Cloneable, org.apache.maven.model.InputLocationTracker
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Information needed to deploy the artifacts generated by the
     * project to a
     *             remote repository.
     */
    private DeploymentRepository repository;

    /**
     * 
     *             
     *             Where to deploy snapshots of artifacts to. If
     * not given, it defaults to the
     *             <code>repository</code> element.
     *             
     *           
     */
    private DeploymentRepository snapshotRepository;

    /**
     * Information needed for deploying the web site of the project.
     */
    private Site site;

    /**
     * 
     *             
     *             The URL of the project's download page. If not
     * given users will be
     *             referred to the homepage given by
     * <code>url</code>.
     *             This is given to assist in locating artifacts
     * that are not in the repository due to
     *             licensing restrictions.
     *             
     *           
     */
    private String downloadUrl;

    /**
     * Relocation information of the artifact if it has been moved
     * to a new group ID
     *             and/or artifact ID.
     */
    private Relocation relocation;

    /**
     * 
     *             
     *             Gives the status of this artifact in the remote
     * repository.
     *             This must not be set in your local project, as
     * it is updated by
     *             tools placing it in the reposiory. Valid values
     * are: <code>none</code> (default),
     *             <code>converted</code> (repository manager
     * converted this from an Maven 1 POM),
     *             <code>partner</code>
     *             (directly synced from a partner Maven 2
     * repository), <code>deployed</code> (was deployed from a
     * Maven 2
     *             instance), <code>verified</code> (has been hand
     * verified as correct and final).
     *             
     *           
     */
    private String status;

    /**
     * Field locations.
     */
    private java.util.Map<Object, InputLocation> locations;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method clone.
     * 
     * @return DistributionManagement
     */
    public DistributionManagement clone()
    {
        try
        {
            DistributionManagement copy = (DistributionManagement) super.clone();

            if ( this.repository != null )
            {
                copy.repository = (DeploymentRepository) this.repository.clone();
            }

            if ( this.snapshotRepository != null )
            {
                copy.snapshotRepository = (DeploymentRepository) this.snapshotRepository.clone();
            }

            if ( this.site != null )
            {
                copy.site = (Site) this.site.clone();
            }

            if ( this.relocation != null )
            {
                copy.relocation = (Relocation) this.relocation.clone();
            }

            if ( copy.locations != null )
            {
                copy.locations = new java.util.LinkedHashMap( copy.locations );
            }

            return copy;
        }
        catch ( java.lang.Exception ex )
        {
            throw (java.lang.RuntimeException) new java.lang.UnsupportedOperationException( getClass().getName()
                + " does not support clone()" ).initCause( ex );
        }
    } //-- DistributionManagement clone()

    /**
     * Get the URL of the project's download page. If not given
     * users will be
     *             referred to the homepage given by
     * <code>url</code>.
     *             This is given to assist in locating artifacts
     * that are not in the repository due to
     *             licensing restrictions.
     * 
     * @return String
     */
    public String getDownloadUrl()
    {
        return this.downloadUrl;
    } //-- String getDownloadUrl()

    /**
     * 
     * 
     * @param key
     * @return InputLocation
     */
    public InputLocation getLocation( Object key )
    {
        return ( locations != null ) ? locations.get( key ) : null;
    } //-- InputLocation getLocation( Object )

    /**
     * Get relocation information of the artifact if it has been
     * moved to a new group ID
     *             and/or artifact ID.
     * 
     * @return Relocation
     */
    public Relocation getRelocation()
    {
        return this.relocation;
    } //-- Relocation getRelocation()

    /**
     * Get information needed to deploy the artifacts generated by
     * the project to a
     *             remote repository.
     * 
     * @return DeploymentRepository
     */
    public DeploymentRepository getRepository()
    {
        return this.repository;
    } //-- DeploymentRepository getRepository()

    /**
     * Get information needed for deploying the web site of the
     * project.
     * 
     * @return Site
     */
    public Site getSite()
    {
        return this.site;
    } //-- Site getSite()

    /**
     * Get where to deploy snapshots of artifacts to. If not given,
     * it defaults to the
     *             <code>repository</code> element.
     * 
     * @return DeploymentRepository
     */
    public DeploymentRepository getSnapshotRepository()
    {
        return this.snapshotRepository;
    } //-- DeploymentRepository getSnapshotRepository()

    /**
     * Get gives the status of this artifact in the remote
     * repository.
     *             This must not be set in your local project, as
     * it is updated by
     *             tools placing it in the reposiory. Valid values
     * are: <code>none</code> (default),
     *             <code>converted</code> (repository manager
     * converted this from an Maven 1 POM),
     *             <code>partner</code>
     *             (directly synced from a partner Maven 2
     * repository), <code>deployed</code> (was deployed from a
     * Maven 2
     *             instance), <code>verified</code> (has been hand
     * verified as correct and final).
     * 
     * @return String
     */
    public String getStatus()
    {
        return this.status;
    } //-- String getStatus()

    /**
     * Set the URL of the project's download page. If not given
     * users will be
     *             referred to the homepage given by
     * <code>url</code>.
     *             This is given to assist in locating artifacts
     * that are not in the repository due to
     *             licensing restrictions.
     * 
     * @param downloadUrl
     */
    public void setDownloadUrl( String downloadUrl )
    {
        this.downloadUrl = downloadUrl;
    } //-- void setDownloadUrl( String )

    /**
     * 
     * 
     * @param key
     * @param location
     */
    public void setLocation( Object key, InputLocation location )
    {
        if ( location != null )
        {
            if ( this.locations == null )
            {
                this.locations = new java.util.LinkedHashMap<Object, InputLocation>();
            }
            this.locations.put( key, location );
        }
    } //-- void setLocation( Object, InputLocation )

    /**
     * Set relocation information of the artifact if it has been
     * moved to a new group ID
     *             and/or artifact ID.
     * 
     * @param relocation
     */
    public void setRelocation( Relocation relocation )
    {
        this.relocation = relocation;
    } //-- void setRelocation( Relocation )

    /**
     * Set information needed to deploy the artifacts generated by
     * the project to a
     *             remote repository.
     * 
     * @param repository
     */
    public void setRepository( DeploymentRepository repository )
    {
        this.repository = repository;
    } //-- void setRepository( DeploymentRepository )

    /**
     * Set information needed for deploying the web site of the
     * project.
     * 
     * @param site
     */
    public void setSite( Site site )
    {
        this.site = site;
    } //-- void setSite( Site )

    /**
     * Set where to deploy snapshots of artifacts to. If not given,
     * it defaults to the
     *             <code>repository</code> element.
     * 
     * @param snapshotRepository
     */
    public void setSnapshotRepository( DeploymentRepository snapshotRepository )
    {
        this.snapshotRepository = snapshotRepository;
    } //-- void setSnapshotRepository( DeploymentRepository )

    /**
     * Set gives the status of this artifact in the remote
     * repository.
     *             This must not be set in your local project, as
     * it is updated by
     *             tools placing it in the reposiory. Valid values
     * are: <code>none</code> (default),
     *             <code>converted</code> (repository manager
     * converted this from an Maven 1 POM),
     *             <code>partner</code>
     *             (directly synced from a partner Maven 2
     * repository), <code>deployed</code> (was deployed from a
     * Maven 2
     *             instance), <code>verified</code> (has been hand
     * verified as correct and final).
     * 
     * @param status
     */
    public void setStatus( String status )
    {
        this.status = status;
    } //-- void setStatus( String )

}
