/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.PluginListParseException;
import org.openstreetmap.josm.plugins.PluginListParser;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.SAXException;

public class ReadRemotePluginInformationTask
extends PleaseWaitRunnable {
    private Collection<String> sites;
    private boolean canceled;
    private HttpClient connection;
    private List<PluginInformation> availablePlugins;
    private boolean displayErrMsg;

    protected final void init(Collection<String> collection, boolean bl) {
        this.sites = collection;
        if (collection == null) {
            this.sites = Collections.emptySet();
        }
        this.availablePlugins = new LinkedList<PluginInformation>();
        this.displayErrMsg = bl;
    }

    public ReadRemotePluginInformationTask(Collection<String> collection) {
        super(I18n.tr("Download plugin list...", new Object[0]), false);
        this.init(collection, true);
    }

    public ReadRemotePluginInformationTask(ProgressMonitor progressMonitor, Collection<String> collection, boolean bl) {
        super(I18n.tr("Download plugin list...", new Object[0]), progressMonitor == null ? NullProgressMonitor.INSTANCE : progressMonitor, false);
        this.init(collection, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancel() {
        this.canceled = true;
        ReadRemotePluginInformationTask readRemotePluginInformationTask = this;
        synchronized (readRemotePluginInformationTask) {
            if (this.connection != null) {
                this.connection.disconnect();
            }
        }
    }

    @Override
    protected void finish() {
    }

    protected File createSiteCacheFile(File file, String string) {
        String string2;
        try {
            string = string.replaceAll("%<(.*)>", "");
            URL uRL = new URL(string);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("site-").append(uRL.getHost()).append('-');
            if (uRL.getPort() != -1) {
                stringBuilder.append(uRL.getPort()).append('-');
            }
            String string3 = uRL.getPath();
            for (int i = 0; i < string3.length(); ++i) {
                char c = string3.charAt(i);
                if (Character.isLetterOrDigit(c)) {
                    stringBuilder.append(c);
                    continue;
                }
                stringBuilder.append('_');
            }
            stringBuilder.append(".txt");
            string2 = stringBuilder.toString();
        }
        catch (MalformedURLException malformedURLException) {
            string2 = "site-unknown.txt";
        }
        return new File(file, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String downloadPluginList(String string, ProgressMonitor progressMonitor) {
        String string2 = Utils.join(",", Main.pref.getCollection("plugins"));
        String string3 = string.replaceAll("%<(.*)>", "");
        string = string2 != null && !string2.isEmpty() ? string.replaceAll("%<(.*)>", "$1" + string2) : string3;
        String string4 = null;
        try {
            progressMonitor.beginTask("");
            progressMonitor.indeterminateSubTask(I18n.tr("Downloading plugin list from ''{0}''", string3));
            URL uRL = new URL(string);
            this.connection = HttpClient.create(uRL).useCache(false);
            HttpClient.Response response = this.connection.connect();
            string4 = response.fetchContent();
            if (response.getResponseCode() != 200) {
                throw new IOException(I18n.tr("Unsuccessful HTTP request", new Object[0]));
            }
            String string5 = string4;
            return string5;
        }
        catch (MalformedURLException malformedURLException) {
            if (this.canceled) {
                String string6 = null;
                return string6;
            }
            Main.error(malformedURLException);
            String string7 = null;
            return string7;
        }
        catch (IOException iOException) {
            if (this.canceled) {
                String string8 = null;
                return string8;
            }
            this.handleIOException(progressMonitor, iOException, string4);
            String string9 = null;
            return string9;
        }
        finally {
            ReadRemotePluginInformationTask readRemotePluginInformationTask = this;
            synchronized (readRemotePluginInformationTask) {
                if (this.connection != null) {
                    this.connection.disconnect();
                }
                this.connection = null;
            }
            progressMonitor.finishTask();
        }
    }

    private void handleIOException(ProgressMonitor progressMonitor, IOException iOException, String string) {
        String string2 = iOException.getMessage();
        if (string == null || string.isEmpty()) {
            Main.error(iOException.getClass().getSimpleName() + ": " + string2);
        } else {
            Main.error(string2 + " - Details:\n" + string);
        }
        if (this.displayErrMsg) {
            ReadRemotePluginInformationTask.displayErrorMessage(progressMonitor, string2, string, I18n.tr("Plugin list download error", new Object[0]), I18n.tr("JOSM failed to download plugin list:", new Object[0]));
        }
    }

    private static void displayErrorMessage(ProgressMonitor progressMonitor, String string, String string2, String string3, String string4) {
        GuiHelper.runInEDTAndWait(() -> {
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.add((Component)new JLabel(string4), GBC.eol().insets(0, 0, 0, 10));
            StringBuilder stringBuilder = new StringBuilder();
            for (String string5 : string.split("(?<=\\G.{200})")) {
                stringBuilder.append(string5).append('\n');
            }
            jPanel.add((Component)new JLabel("<html><body width=\"500\"><b>" + stringBuilder.toString().trim() + "</b></body></html>"), GBC.eol().insets(0, 0, 0, 10));
            if (string2 != null && !string2.isEmpty()) {
                jPanel.add((Component)new JLabel(I18n.tr("Details:", new Object[0])), GBC.eol().insets(0, 0, 0, 10));
                JosmTextArea josmTextArea = new JosmTextArea(string2);
                josmTextArea.setEditable(false);
                josmTextArea.setLineWrap(true);
                josmTextArea.setWrapStyleWord(true);
                JScrollPane jScrollPane = new JScrollPane(josmTextArea);
                jScrollPane.setPreferredSize(new Dimension(500, 300));
                jPanel.add((Component)jScrollPane, GBC.eol().fill());
            }
            JOptionPane.showMessageDialog(progressMonitor.getWindowParent(), jPanel, string3, 0);
        });
    }

    protected void cachePluginList(String string, String string2) {
        File file = Main.pref.getPluginsDirectory();
        if (!file.exists() && !file.mkdirs()) {
            Main.warn(I18n.tr("Failed to create plugin directory ''{0}''. Cannot cache plugin list from plugin site ''{1}''.", file.toString(), string));
        }
        File file2 = this.createSiteCacheFile(file, string);
        this.getProgressMonitor().subTask(I18n.tr("Writing plugin list to local cache ''{0}''", file2.toString()));
        try (PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), StandardCharsets.UTF_8));){
            printWriter.write(string2);
            printWriter.flush();
        }
        catch (IOException iOException) {
            Main.error(iOException);
        }
    }

    protected List<PluginInformation> filterDeprecatedPlugins(List<PluginInformation> list) {
        ArrayList<PluginInformation> arrayList = new ArrayList<PluginInformation>(list.size());
        HashSet<String> hashSet = new HashSet<String>();
        for (PluginHandler.DeprecatedPlugin object : PluginHandler.DEPRECATED_PLUGINS) {
            hashSet.add(object.name);
        }
        for (PluginInformation pluginInformation : list) {
            if (hashSet.contains(pluginInformation.name)) continue;
            arrayList.add(pluginInformation);
        }
        return arrayList;
    }

    protected void parsePluginListDocument(String string, String string2) {
        try {
            this.getProgressMonitor().subTask(I18n.tr("Parsing plugin list from site ''{0}''", string));
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes(StandardCharsets.UTF_8));
            List<PluginInformation> list = new PluginListParser().parse(byteArrayInputStream);
            this.availablePlugins.addAll(this.filterDeprecatedPlugins(list));
        }
        catch (PluginListParseException pluginListParseException) {
            Main.error(I18n.tr("Failed to parse plugin list document from site ''{0}''. Skipping site. Exception was: {1}", string, pluginListParseException.toString()));
            Main.error(pluginListParseException);
        }
    }

    @Override
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        if (this.sites == null) {
            return;
        }
        this.getProgressMonitor().setTicksCount(this.sites.size() * 3);
        LinkedList<File> linkedList = new LinkedList<File>();
        for (String object : PluginInformation.getPluginLocations()) {
            File[] fileArray = new File(object).listFiles((file, string) -> string.matches("^([0-9]+-)?site.*\\.txt$") || string.matches("^([0-9]+-)?site.*-icons\\.zip$"));
            if (fileArray == null || fileArray.length <= 0) continue;
            linkedList.addAll(Arrays.asList(fileArray));
        }
        File file2 = Main.pref.getPluginsDirectory();
        for (String string2 : this.sites) {
            String string3 = string2.replaceAll("%<(.*)>", "");
            this.getProgressMonitor().subTask(I18n.tr("Processing plugin list from site ''{0}''", string3));
            String string4 = this.downloadPluginList(string2, this.getProgressMonitor().createSubTaskMonitor(0, false));
            if (this.canceled) {
                return;
            }
            linkedList.remove(this.createSiteCacheFile(file2, string2));
            if (string4 == null) continue;
            this.getProgressMonitor().worked(1);
            this.cachePluginList(string2, string4);
            if (this.canceled) {
                return;
            }
            this.getProgressMonitor().worked(1);
            this.parsePluginListDocument(string2, string4);
            if (this.canceled) {
                return;
            }
            this.getProgressMonitor().worked(1);
            if (!this.canceled) continue;
            return;
        }
        for (File file3 : linkedList) {
            Utils.deleteFile(file3);
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public List<PluginInformation> getAvailablePlugins() {
        return this.availablePlugins;
    }
}

