/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.GraphicsEnvironment;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import org.openstreetmap.gui.jmapviewer.FeatureAdapter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.AbstractFileChooser;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Utils;

public final class I18n {
    private static volatile PluralMode pluralMode = PluralMode.MODE_NOTONE;
    private static volatile String loadedCode = "en";
    private static final String[] javaInternalMessageKeys = new String[]{"FileChooser.detailsViewActionLabelText", "FileChooser.detailsViewButtonAccessibleName", "FileChooser.detailsViewButtonToolTipText", "FileChooser.fileAttrHeaderText", "FileChooser.fileDateHeaderText", "FileChooser.fileNameHeaderText", "FileChooser.fileNameLabelText", "FileChooser.fileSizeHeaderText", "FileChooser.fileTypeHeaderText", "FileChooser.filesOfTypeLabelText", "FileChooser.homeFolderAccessibleName", "FileChooser.homeFolderToolTipText", "FileChooser.listViewActionLabelText", "FileChooser.listViewButtonAccessibleName", "FileChooser.listViewButtonToolTipText", "FileChooser.lookInLabelText", "FileChooser.newFolderAccessibleName", "FileChooser.newFolderActionLabelText", "FileChooser.newFolderToolTipText", "FileChooser.refreshActionLabelText", "FileChooser.saveInLabelText", "FileChooser.upFolderAccessibleName", "FileChooser.upFolderToolTipText", "FileChooser.viewMenuLabelText", "FileChooser.acceptAllFileFilterText", "FileChooser.cancelButtonText", "FileChooser.cancelButtonToolTipText", "FileChooser.deleteFileButtonText", "FileChooser.filesLabelText", "FileChooser.filterLabelText", "FileChooser.foldersLabelText", "FileChooser.newFolderButtonText", "FileChooser.newFolderDialogText", "FileChooser.openButtonText", "FileChooser.openButtonToolTipText", "FileChooser.openDialogTitleText", "FileChooser.pathLabelText", "FileChooser.renameFileButtonText", "FileChooser.renameFileDialogText", "FileChooser.renameFileErrorText", "FileChooser.renameFileErrorTitle", "FileChooser.saveButtonText", "FileChooser.saveButtonToolTipText", "FileChooser.saveDialogTitleText", "FileChooser.enterFileNameLabelText", "FileChooser.helpButtonText", "FileChooser.helpButtonToolTipText", "FileChooser.updateButtonText", "FileChooser.updateButtonToolTipText", "GTKColorChooserPanel.blueText", "GTKColorChooserPanel.colorNameText", "GTKColorChooserPanel.greenText", "GTKColorChooserPanel.hueText", "GTKColorChooserPanel.nameText", "GTKColorChooserPanel.redText", "GTKColorChooserPanel.saturationText", "GTKColorChooserPanel.valueText", "OptionPane.okButtonText", "OptionPane.yesButtonText", "OptionPane.noButtonText", "OptionPane.cancelButtonText"};
    private static volatile Map<String, String> strings;
    private static volatile Map<String, String[]> pstrings;
    private static Map<String, PluralMode> languages;

    private I18n() {
    }

    public static String tr(String string, Object ... objectArray) {
        if (string == null) {
            return null;
        }
        return MessageFormat.format(I18n.gettext(string, null), objectArray);
    }

    public static String trc(String string, String string2) {
        if (string == null) {
            return I18n.tr(string2, new Object[0]);
        }
        if (string2 == null) {
            return null;
        }
        return MessageFormat.format(I18n.gettext(string2, string), new Object[]{null});
    }

    public static String trcLazy(String string, String string2) {
        if (string == null) {
            return I18n.tr(string2, new Object[0]);
        }
        if (string2 == null) {
            return null;
        }
        return MessageFormat.format(I18n.gettextLazy(string2, string), new Object[]{null});
    }

    public static String marktr(String string) {
        return string;
    }

    public static String marktrc(String string, String string2) {
        return string2;
    }

    public static String trn(String string, String string2, long l, Object ... objectArray) {
        return MessageFormat.format(I18n.gettextn(string, string2, null, l), objectArray);
    }

    public static String trnc(String string, String string2, String string3, long l, Object ... objectArray) {
        return MessageFormat.format(I18n.gettextn(string2, string3, string, l), objectArray);
    }

    private static String gettext(String string, String string2, boolean bl) {
        String[] stringArray;
        int n;
        if (string2 == null && string.startsWith("_:") && (n = string.indexOf(10)) >= 0) {
            string2 = string.substring(2, n - 1);
            string = string.substring(n + 1);
        }
        if (strings != null && (stringArray = strings.get(string2 == null ? string : "_:" + string2 + '\n' + string)) != null) {
            return stringArray;
        }
        if (pstrings != null) {
            n = I18n.pluralEval(1L);
            stringArray = pstrings.get(string2 == null ? string : "_:" + string2 + '\n' + string);
            if (stringArray != null && stringArray.length > n) {
                return stringArray[n];
            }
        }
        return bl ? I18n.gettext(string, null) : string;
    }

    private static String gettext(String string, String string2) {
        return I18n.gettext(string, string2, false);
    }

    private static String gettextLazy(String string, String string2) {
        return I18n.gettext(string, string2, true);
    }

    private static String gettextn(String string, String string2, String string3, long l) {
        int n;
        if (string3 == null && string.startsWith("_:") && (n = string.indexOf(10)) >= 0) {
            string3 = string.substring(2, n - 1);
            string = string.substring(n + 1);
        }
        if (pstrings != null) {
            n = I18n.pluralEval(l);
            String[] stringArray = pstrings.get(string3 == null ? string : "_:" + string3 + '\n' + string);
            if (stringArray != null && stringArray.length > n) {
                return stringArray[n];
            }
        }
        return l == 1L ? string : string2;
    }

    public static String escape(String string) {
        if (string == null) {
            return null;
        }
        return string.replace("'", "''").replace("{", "'{'").replace("}", "'}'");
    }

    private static URL getTranslationFile(String string) {
        return Main.class.getResource("/data/" + string.replace('@', '-') + ".lang");
    }

    public static Locale[] getAvailableTranslations() {
        ArrayList<Locale> arrayList = new ArrayList<Locale>(languages.size());
        if (I18n.getTranslationFile("en") != null) {
            for (String string : languages.keySet()) {
                if (I18n.getTranslationFile(string) == null) continue;
                arrayList.add(LanguageInfo.getLocale(string));
            }
        }
        arrayList.add(Locale.ENGLISH);
        Locale[] localeArray = new Locale[arrayList.size()];
        localeArray = arrayList.toArray(localeArray);
        Arrays.sort(localeArray, Comparator.comparing(Locale::toString));
        return localeArray;
    }

    public static boolean hasCode(String string) {
        return languages.containsKey(string);
    }

    public static void init() {
        Utils.updateSystemProperty("java.locale.providers", "JRE,CLDR");
        languages.put("ast", PluralMode.MODE_NOTONE);
        languages.put("bg", PluralMode.MODE_NOTONE);
        languages.put("be", PluralMode.MODE_RU);
        languages.put("ca", PluralMode.MODE_NOTONE);
        languages.put("ca@valencia", PluralMode.MODE_NOTONE);
        languages.put("cs", PluralMode.MODE_CS);
        languages.put("da", PluralMode.MODE_NOTONE);
        languages.put("de", PluralMode.MODE_NOTONE);
        languages.put("el", PluralMode.MODE_NOTONE);
        languages.put("en_AU", PluralMode.MODE_NOTONE);
        languages.put("en_GB", PluralMode.MODE_NOTONE);
        languages.put("es", PluralMode.MODE_NOTONE);
        languages.put("et", PluralMode.MODE_NOTONE);
        languages.put("fi", PluralMode.MODE_NOTONE);
        languages.put("fr", PluralMode.MODE_GREATERONE);
        languages.put("gl", PluralMode.MODE_NOTONE);
        languages.put("hu", PluralMode.MODE_NOTONE);
        languages.put("id", PluralMode.MODE_NONE);
        languages.put("it", PluralMode.MODE_NOTONE);
        languages.put("ja", PluralMode.MODE_NONE);
        languages.put("km", PluralMode.MODE_NONE);
        languages.put("lt", PluralMode.MODE_LT);
        languages.put("nb", PluralMode.MODE_NOTONE);
        languages.put("nl", PluralMode.MODE_NOTONE);
        languages.put("pl", PluralMode.MODE_PL);
        languages.put("pt", PluralMode.MODE_NOTONE);
        languages.put("pt_BR", PluralMode.MODE_GREATERONE);
        languages.put("ru", PluralMode.MODE_RU);
        languages.put("sk", PluralMode.MODE_SK);
        languages.put("sv", PluralMode.MODE_NOTONE);
        languages.put("uk", PluralMode.MODE_RU);
        languages.put("vi", PluralMode.MODE_NONE);
        languages.put("zh_CN", PluralMode.MODE_NONE);
        languages.put("zh_TW", PluralMode.MODE_NONE);
        if (!I18n.load(LanguageInfo.getJOSMLocaleCode())) {
            Locale.setDefault(Locale.ENGLISH);
        }
    }

    public static void addTexts(File file) {
        block54: {
            if ("en".equals(loadedCode)) {
                return;
            }
            String string = "data/" + loadedCode + ".lang";
            try (FileInputStream fileInputStream = new FileInputStream(file);
                 JarInputStream jarInputStream = new JarInputStream(fileInputStream);){
                Object object;
                ZipEntry zipEntry;
                boolean bl = false;
                while (!bl && (zipEntry = jarInputStream.getNextEntry()) != null) {
                    object = zipEntry.getName();
                    if (!"data/en.lang".equals(object)) continue;
                    bl = true;
                }
                if (!bl) break block54;
                object = new FileInputStream(file);
                Throwable throwable = null;
                try (JarInputStream jarInputStream2 = new JarInputStream((InputStream)object);){
                    bl = false;
                    while (!bl && (zipEntry = jarInputStream2.getNextEntry()) != null) {
                        String string2 = zipEntry.getName();
                        if (!string2.equals(string)) continue;
                        bl = true;
                    }
                    if (bl) {
                        I18n.load(jarInputStream, jarInputStream2, true);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (object != null) {
                        if (throwable != null) {
                            try {
                                ((FileInputStream)object).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((FileInputStream)object).close();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                Main.trace(iOException);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean load(String string) {
        if ("en".equals(string) || "en_US".equals(string)) {
            strings = null;
            pstrings = null;
            loadedCode = "en";
            pluralMode = PluralMode.MODE_NOTONE;
            return true;
        }
        URL uRL = I18n.getTranslationFile("en");
        if (uRL == null) {
            return false;
        }
        URL uRL2 = I18n.getTranslationFile(string);
        if (uRL2 == null) return false;
        if (!languages.containsKey(string)) {
            return false;
        }
        try (InputStream inputStream = uRL.openStream();
             InputStream inputStream2 = uRL2.openStream();){
            if (!I18n.load(inputStream, inputStream2, false)) return false;
            pluralMode = languages.get(string);
            loadedCode = string;
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            Main.trace(iOException);
        }
        return false;
    }

    private static boolean load(InputStream inputStream, InputStream inputStream2, boolean bl) {
        Map<String, String[]> map;
        Map<String, String> map2;
        if (bl) {
            map2 = strings;
            map = pstrings;
        } else {
            map2 = new HashMap<String, String>();
            map = new HashMap<String, String[]>();
        }
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            BufferedInputStream bufferedInputStream2 = new BufferedInputStream(inputStream2);
            byte[] byArray = new byte[2];
            byte[] byArray2 = new byte[2];
            boolean bl2 = false;
            byte[] byArray3 = new byte[4096];
            while (true) {
                Object object;
                int n;
                int n2;
                if (bl2) {
                    n2 = ((InputStream)bufferedInputStream).read();
                    n = ((InputStream)bufferedInputStream2).read();
                    if (n == 254) {
                        n = 0;
                    }
                    if (n2 == -1 && n != -1 || n2 != -1 && n == -1) {
                        return false;
                    }
                    if (n2 != -1) {
                        int n3;
                        int n4;
                        String[] stringArray = new String[n2];
                        for (int i = 0; i < n2; ++i) {
                            n4 = ((InputStream)bufferedInputStream).read(byArray);
                            if (n4 != 2) {
                                return false;
                            }
                            n4 = (byArray[0] < 0 ? 256 + byArray[0] : byArray[0]) * 256 + (byArray[1] < 0 ? 256 + byArray[1] : byArray[1]);
                            if (n4 > byArray3.length) {
                                byArray3 = new byte[n4];
                            }
                            if ((n3 = ((InputStream)bufferedInputStream).read(byArray3, 0, n4)) != n4) {
                                return false;
                            }
                            stringArray[i] = new String(byArray3, 0, n4, StandardCharsets.UTF_8);
                        }
                        object = new String[n];
                        for (n4 = 0; n4 < n; ++n4) {
                            int n5;
                            n3 = ((InputStream)bufferedInputStream2).read(byArray2);
                            if (n3 != 2) {
                                return false;
                            }
                            n3 = (byArray2[0] < 0 ? 256 + byArray2[0] : byArray2[0]) * 256 + (byArray2[1] < 0 ? 256 + byArray2[1] : byArray2[1]);
                            if (n3 > byArray3.length) {
                                byArray3 = new byte[n3];
                            }
                            if ((n5 = ((InputStream)bufferedInputStream2).read(byArray3, 0, n3)) != n3) {
                                return false;
                            }
                            object[n4] = new String(byArray3, 0, n3, StandardCharsets.UTF_8);
                        }
                        if (n <= 0 || map.containsKey(stringArray[0])) continue;
                        map.put(stringArray[0], (String[])object);
                        continue;
                    }
                } else {
                    n2 = ((InputStream)bufferedInputStream).read(byArray);
                    if (n2 != (n = ((InputStream)bufferedInputStream2).read(byArray2))) {
                        return false;
                    }
                    if (n2 != -1) {
                        int n6;
                        if (n2 != 2) {
                            return false;
                        }
                        n2 = (byArray[0] < 0 ? 256 + byArray[0] : byArray[0]) * 256 + (byArray[1] < 0 ? 256 + byArray[1] : byArray[1]);
                        n = (byArray2[0] < 0 ? 256 + byArray2[0] : byArray2[0]) * 256 + (byArray2[1] < 0 ? 256 + byArray2[1] : byArray2[1]);
                        if (n == 65534) {
                            n = 0;
                        }
                        if (n2 == 65535) {
                            bl2 = true;
                            if (n == 65535) continue;
                            return false;
                        }
                        if (n2 > byArray3.length) {
                            byArray3 = new byte[n2];
                        }
                        if (n > byArray3.length) {
                            byArray3 = new byte[n];
                        }
                        if ((n6 = ((InputStream)bufferedInputStream).read(byArray3, 0, n2)) != n2) {
                            return false;
                        }
                        object = new String(byArray3, 0, n2, StandardCharsets.UTF_8);
                        if (n == 0) continue;
                        n6 = ((InputStream)bufferedInputStream2).read(byArray3, 0, n);
                        if (n6 != n) {
                            return false;
                        }
                        String string = new String(byArray3, 0, n, StandardCharsets.UTF_8);
                        if (map2.containsKey(object)) continue;
                        map2.put((String)object, string);
                        continue;
                    }
                }
                break;
            }
        }
        catch (IOException iOException) {
            Main.trace(iOException);
            return false;
        }
        if (!map2.isEmpty()) {
            strings = map2;
            pstrings = map;
            return true;
        }
        return false;
    }

    public static void set(String string) {
        if (string != null) {
            Locale locale = LanguageInfo.getLocale(string);
            if (I18n.load(LanguageInfo.getJOSMLocaleCode(locale))) {
                Locale.setDefault(locale);
            } else if (!"en".equals(locale.getLanguage())) {
                Main.info(I18n.tr("Unable to find translation for the locale {0}. Reverting to {1}.", LanguageInfo.getDisplayName(locale), LanguageInfo.getDisplayName(Locale.getDefault())));
            } else {
                strings = null;
                pstrings = null;
            }
        }
    }

    public static void translateJavaInternalMessages() {
        Locale locale = Locale.getDefault();
        AbstractFileChooser.setDefaultLocale(locale);
        JFileChooser.setDefaultLocale(locale);
        JColorChooser.setDefaultLocale(locale);
        for (String string : javaInternalMessageKeys) {
            String string2 = UIManager.getString((Object)string, Locale.US);
            String string3 = UIManager.getString((Object)string, locale);
            if (string2 == null || !string2.equals(string3)) continue;
            UIManager.put(string, I18n.tr(string2, new Object[0]));
        }
    }

    private static int pluralEval(long l) {
        switch (pluralMode) {
            case MODE_NOTONE: {
                return l != 1L ? 1 : 0;
            }
            case MODE_NONE: {
                return 0;
            }
            case MODE_GREATERONE: {
                return l > 1L ? 1 : 0;
            }
            case MODE_CS: {
                return l == 1L ? 0 : (l >= 2L && l <= 4L ? 1 : 2);
            }
            case MODE_PL: {
                return l == 1L ? 0 : (l % 10L >= 2L && l % 10L <= 4L && (l % 100L < 10L || l % 100L >= 20L) ? 1 : 2);
            }
            case MODE_LT: {
                return l % 10L == 1L && l % 100L != 11L ? 0 : (l % 10L >= 2L && (l % 100L < 10L || l % 100L >= 20L) ? 1 : 2);
            }
            case MODE_RU: {
                return l % 10L == 1L && l % 100L != 11L ? 0 : (l % 10L >= 2L && l % 10L <= 4L && (l % 100L < 10L || l % 100L >= 20L) ? 1 : 2);
            }
            case MODE_SK: {
                return l == 1L ? 1 : (l >= 2L && l <= 4L ? 2 : 0);
            }
        }
        return 0;
    }

    public static FeatureAdapter.TranslationAdapter getTranslationAdapter() {
        return I18n::tr;
    }

    public static void setupLanguageFonts() {
        if ("km".equals(LanguageInfo.getJOSMLocaleCode())) {
            List<String> list = Arrays.asList(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
            for (String string : new String[]{"Khmer UI", "DaunPenh", "MoolBoran"}) {
                if (!list.contains(string)) continue;
                GuiHelper.setUIFont(string);
                break;
            }
        }
    }

    static {
        languages = new HashMap<String, PluralMode>();
    }

    private static enum PluralMode {
        MODE_NOTONE,
        MODE_NONE,
        MODE_GREATERONE,
        MODE_CS,
        MODE_PL,
        MODE_LT,
        MODE_RU,
        MODE_SK;

    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface QuirkyPluralString {
    }
}

