/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rope;

import com.oracle.truffle.api.CompilerDirectives;
import org.jcodings.Encoding;
import org.jruby.truffle.core.rope.CodeRange;
import org.jruby.truffle.core.rope.Rope;

public class SubstringRope
extends Rope {
    private final Rope child;
    private final int offset;

    public SubstringRope(Rope child, int offset, int byteLength, int characterLength, CodeRange codeRange) {
        this(child, child.getEncoding(), offset, byteLength, characterLength, codeRange);
    }

    private SubstringRope(Rope child, Encoding encoding, int offset, int byteLength, int characterLength, CodeRange codeRange) {
        super(encoding, codeRange, child.isSingleByteOptimizable(), byteLength, characterLength, child.depth() + 1, null);
        this.child = child;
        this.offset = offset;
    }

    @Override
    public Rope withEncoding(Encoding newEncoding, CodeRange newCodeRange) {
        if (newCodeRange != this.getCodeRange()) {
            CompilerDirectives.transferToInterpreter();
            throw new UnsupportedOperationException("Cannot fast-path updating encoding with different code range.");
        }
        return new SubstringRope(this.getChild(), newEncoding, this.getOffset(), this.byteLength(), this.characterLength(), newCodeRange);
    }

    @Override
    public byte getByteSlow(int index) {
        return this.child.getByteSlow(index + this.offset);
    }

    public Rope getChild() {
        return this.child;
    }

    public int getOffset() {
        return this.offset;
    }

    public String toString() {
        return this.child.toString().substring(this.offset, this.offset + this.byteLength());
    }
}

