/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.globals;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.globals.GlobalVariableStorage;

@NodeChild(value="value")
public abstract class WriteGlobalVariableNode
extends RubyNode {
    private final String name;

    @Specialization
    public Object write(Object value, @Cached(value="getStorage()") GlobalVariableStorage storage) {
        storage.value = value;
        return storage.value;
    }

    protected GlobalVariableStorage getStorage() {
        return this.getContext().getCoreLibrary().getGlobalVariables().getStorage(this.name);
    }

    public WriteGlobalVariableNode(RubyContext context, SourceSection sourceSection, String name) {
        super(context, sourceSection);
        this.name = name;
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        return this.coreStrings().ASSIGNMENT.createInstance();
    }
}

