/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cfg.WhenChecker;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.load.java.lazy.types.LazyJavaTypeResolverKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.AdditionalTypeChecker;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/WhenByPlatformEnumChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/AdditionalTypeChecker;", "()V", "checkType", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expressionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "expressionTypeWithSmartCast", "c", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "kotlin-compiler"})
public final class WhenByPlatformEnumChecker
implements AdditionalTypeChecker {
    @Override
    public void checkType(@NotNull KtExpression expression, @NotNull KotlinType expressionType, @NotNull KotlinType expressionTypeWithSmartCast, @NotNull ResolutionContext<?> c) {
        block8: {
            Object object;
            block10: {
                block9: {
                    Intrinsics.checkParameterIsNotNull(expression, "expression");
                    Intrinsics.checkParameterIsNotNull(expressionType, "expressionType");
                    Intrinsics.checkParameterIsNotNull(expressionTypeWithSmartCast, "expressionTypeWithSmartCast");
                    Intrinsics.checkParameterIsNotNull(c, "c");
                    if (!(expression instanceof KtWhenExpression) || ((KtWhenExpression)expression).getElseExpression() != null) break block8;
                    object = ((KtWhenExpression)expression).getSubjectExpression();
                    if (object == null) break block9;
                    KtExpression ktExpression = object;
                    KtExpression it = ktExpression;
                    object = c.trace.getType(it);
                    if (object != null) break block10;
                }
                return;
            }
            Object type2 = object;
            if (FlexibleTypesKt.isFlexible((KotlinType)type2) && TypeUtils.isNullableType(FlexibleTypesKt.flexibility((KotlinType)type2).getUpperBound()) && !LazyJavaTypeResolverKt.isMarkedNotNull(type2.getAnnotations())) {
                ClassDescriptor classDescriptor = WhenChecker.getClassDescriptorOfTypeIfEnum((KotlinType)type2);
                if (classDescriptor == null) {
                    return;
                }
                ClassDescriptor enumClassDescriptor = classDescriptor;
                BindingContext context = c.trace.getBindingContext();
                KtWhenExpression ktWhenExpression = (KtWhenExpression)expression;
                BindingContext bindingContext = context;
                Intrinsics.checkExpressionValueIsNotNull(bindingContext, "context");
                if (WhenChecker.getEnumMissingCases(ktWhenExpression, bindingContext, enumClassDescriptor).isEmpty()) {
                    KtWhenExpression ktWhenExpression2 = (KtWhenExpression)expression;
                    BindingContext bindingContext2 = context;
                    Intrinsics.checkExpressionValueIsNotNull(bindingContext2, "context");
                    if (!WhenChecker.INSTANCE.containsNullCase(ktWhenExpression2, bindingContext2)) {
                        BindingTrace bindingTrace = c.trace;
                        KtExpression ktExpression = ((KtWhenExpression)expression).getSubjectExpression();
                        if (ktExpression == null) {
                            Intrinsics.throwNpe();
                        }
                        bindingTrace.report(ErrorsJvm.WHEN_ENUM_CAN_BE_NULL_IN_JAVA.on((KtExpression)((PsiElement)ktExpression)));
                    }
                }
            }
        }
    }
}

