/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GenericTypeAwarePropertyDescriptor
extends PropertyDescriptor {
    private final Class<?> beanClass;
    private final Method readMethod;
    private final Method writeMethod;
    private final Class<?> propertyEditorClass;
    private volatile Set<Method> ambiguousWriteMethods;
    private Class<?> propertyType;
    private MethodParameter writeMethodParameter;

    public GenericTypeAwarePropertyDescriptor(Class<?> beanClass, String propertyName, Method readMethod, Method writeMethod, Class<?> propertyEditorClass) throws IntrospectionException {
        super(propertyName, null, null);
        Method candidate;
        this.beanClass = beanClass;
        this.propertyEditorClass = propertyEditorClass;
        Method readMethodToUse = BridgeMethodResolver.findBridgedMethod((Method)readMethod);
        Method writeMethodToUse = BridgeMethodResolver.findBridgedMethod((Method)writeMethod);
        if (writeMethodToUse == null && readMethodToUse != null && (candidate = ClassUtils.getMethodIfAvailable(this.beanClass, (String)("set" + StringUtils.capitalize((String)this.getName())), (Class[])null)) != null && candidate.getParameterTypes().length == 1) {
            writeMethodToUse = candidate;
        }
        this.readMethod = readMethodToUse;
        this.writeMethod = writeMethodToUse;
        if (this.writeMethod != null && this.readMethod == null) {
            HashSet<Method> ambiguousCandidates = new HashSet<Method>();
            for (Method method : beanClass.getMethods()) {
                if (!method.getName().equals(writeMethodToUse.getName()) || method.equals(writeMethodToUse) || method.isBridge()) continue;
                ambiguousCandidates.add(method);
            }
            if (!ambiguousCandidates.isEmpty()) {
                this.ambiguousWriteMethods = ambiguousCandidates;
            }
        }
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    @Override
    public Method getReadMethod() {
        return this.readMethod;
    }

    @Override
    public Method getWriteMethod() {
        return this.writeMethod;
    }

    public Method getWriteMethodForActualAccess() {
        Set<Method> ambiguousCandidates = this.ambiguousWriteMethods;
        if (ambiguousCandidates != null) {
            this.ambiguousWriteMethods = null;
            LogFactory.getLog(GenericTypeAwarePropertyDescriptor.class).warn((Object)("Invalid JavaBean property '" + this.getName() + "' being accessed! Ambiguous write methods found next to actually used [" + this.writeMethod + "]: " + ambiguousCandidates));
        }
        return this.writeMethod;
    }

    @Override
    public Class<?> getPropertyEditorClass() {
        return this.propertyEditorClass;
    }

    @Override
    public synchronized Class<?> getPropertyType() {
        if (this.propertyType == null) {
            MethodParameter writeMethodParam;
            this.propertyType = this.readMethod != null ? GenericTypeResolver.resolveReturnType((Method)this.readMethod, this.beanClass) : ((writeMethodParam = this.getWriteMethodParameter()) != null ? writeMethodParam.getParameterType() : super.getPropertyType());
        }
        return this.propertyType;
    }

    public synchronized MethodParameter getWriteMethodParameter() {
        if (this.writeMethod == null) {
            return null;
        }
        if (this.writeMethodParameter == null) {
            this.writeMethodParameter = new MethodParameter(this.writeMethod, 0);
            GenericTypeResolver.resolveParameterType((MethodParameter)this.writeMethodParameter, this.beanClass);
        }
        return this.writeMethodParameter;
    }
}

