/*
 * Decompiled with CFR 0.152.
 */
package com.sun.t2k;

public abstract class CharToGlyphMapper {
    public static final int HI_SURROGATE_START = 55296;
    public static final int HI_SURROGATE_END = 56319;
    public static final int LO_SURROGATE_START = 56320;
    public static final int LO_SURROGATE_END = 57343;
    public static final int MISSING_GLYPH = 0;
    public static final int INVISIBLE_GLYPH_ID = 65535;
    public static final int INVISIBLE_GLYPHS = 65534;
    public static final int MIN_LAYOUT_CHARCODE = 768;
    public static final int MAX_LAYOUT_CHARCODE = 8303;
    protected int missingGlyph = 0;

    public static boolean isComplexCharCode(int n) {
        if (n < 768 || n > 8303) {
            return false;
        }
        if (n <= 879) {
            return true;
        }
        if (n < 1424) {
            return false;
        }
        if (n <= 1791) {
            return true;
        }
        if (n < 2304) {
            return false;
        }
        if (n <= 3711) {
            return true;
        }
        if (n < 6016) {
            return false;
        }
        if (n <= 6143) {
            return true;
        }
        if (n < 8204) {
            return false;
        }
        if (n <= 8205) {
            return true;
        }
        if (n >= 8234 && n <= 8238) {
            return true;
        }
        return n >= 8298 && n <= 8303;
    }

    public int getMissingGlyphCode() {
        return this.missingGlyph;
    }

    public abstract int getNumGlyphs();

    public abstract int getGlyphCode(int var1);

    public int charToGlyph(char c) {
        return this.getGlyphCode(c);
    }

    public int charToGlyph(int n) {
        return this.getGlyphCode(n);
    }

    public void charsToGlyphs(int n, int[] nArray, int[] nArray2) {
        for (int i = 0; i < n; ++i) {
            nArray2[i] = this.getGlyphCode(nArray[i]);
        }
    }

    public void charsToGlyphs(int n, char[] cArray, int[] nArray) {
        for (int i = 0; i < n; ++i) {
            char c;
            int n2 = cArray[i];
            if (n2 >= 55296 && n2 <= 56319 && i < n - 1 && (c = cArray[i + 1]) >= '\udc00' && c <= '\udfff') {
                n2 = (n2 - 55296) * 1024 + c - 56320 + 65536;
                nArray[i] = this.getGlyphCode(n2);
                nArray[++i] = 65535;
                continue;
            }
            nArray[i] = this.getGlyphCode(n2);
        }
    }

    public boolean charsToGlyphsNS(int n, char[] cArray, int[] nArray) {
        for (int i = 0; i < n; ++i) {
            char c;
            int n2 = cArray[i];
            if (n2 >= 55296 && n2 <= 56319 && i < n - 1 && (c = cArray[i + 1]) >= '\udc00' && c <= '\udfff') {
                n2 = (n2 - 55296) * 1024 + c - 56320 + 65536;
                nArray[i + 1] = 65535;
            }
            nArray[i] = this.getGlyphCode(n2);
            if (n2 < 768) continue;
            if (CharToGlyphMapper.isComplexCharCode(n2)) {
                return true;
            }
            if (n2 < 65536) continue;
            ++i;
        }
        return false;
    }
}

