/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.model;

import java.util.TreeSet;
import org.zaproxy.zap.model.Tech;

public class TechSet {
    public static final TechSet AllTech = new TechSet(Tech.builtInTopLevelTech);
    private TreeSet<Tech> includeTech = new TreeSet();
    private TreeSet<Tech> excludeTech = new TreeSet();

    public TechSet() {
    }

    public TechSet(Tech[] techArray) {
        this(techArray, null);
    }

    public TechSet(Tech[] techArray, Tech[] techArray2) {
        if (techArray != null) {
            for (Tech tech : techArray) {
                this.include(tech);
            }
        }
        if (techArray2 != null) {
            for (Tech tech : techArray2) {
                this.exclude(tech);
            }
        }
    }

    public TechSet(TechSet techSet) {
        this.includeTech.addAll(techSet.includeTech);
        this.excludeTech.addAll(techSet.excludeTech);
    }

    public void include(Tech tech) {
        this.excludeTech.remove(tech);
        this.includeTech.add(tech);
    }

    public void exclude(Tech tech) {
        this.includeTech.remove(tech);
        this.excludeTech.add(tech);
    }

    public boolean includes(Tech tech) {
        if (tech == null) {
            return false;
        }
        if (this.excludeTech.contains(tech)) {
            return false;
        }
        if (this.includeTech.contains(tech)) {
            return true;
        }
        return this.includes(tech.getParent());
    }

    public TreeSet<Tech> getIncludeTech() {
        TreeSet<Tech> treeSet = new TreeSet<Tech>();
        treeSet.addAll(this.includeTech);
        return treeSet;
    }

    public TreeSet<Tech> getExcludeTech() {
        TreeSet<Tech> treeSet = new TreeSet<Tech>();
        treeSet.addAll(this.excludeTech);
        return treeSet;
    }

    public void print() {
        System.out.println("TechSet: " + this.hashCode());
        for (Tech tech : this.includeTech) {
            System.out.println("\tInclude: " + tech);
        }
        for (Tech tech : this.excludeTech) {
            System.out.println("\tExclude: " + tech);
        }
    }
}

