/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.util.LinkedList;
import sun.awt.X11.Native;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XEmbedHelper;
import sun.awt.X11.XEvent;
import sun.awt.X11.XEventDispatcher;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindow;
import sun.awt.X11.XlibUtil;
import sun.awt.X11.XlibWrapper;
import sun.util.logging.PlatformLogger;

public class XEmbedServerTester
implements XEventDispatcher {
    private static final PlatformLogger xembedLog = PlatformLogger.getLogger("sun.awt.X11.xembed.XEmbedServerTester");
    private final Object EVENT_LOCK = new Object();
    static final int SYSTEM_EVENT_MASK = 32768;
    int my_version;
    int server_version;
    XEmbedHelper xembed = new XEmbedHelper();
    boolean focused;
    int focusedKind;
    int focusedServerComponent;
    boolean reparent;
    long parent;
    boolean windowActive;
    boolean xembedActive;
    XBaseWindow window;
    volatile int eventWaited = -1;
    volatile int eventReceived = -1;
    int mapped;
    int accel_key;
    int accel_keysym;
    int accel_mods;
    static Rectangle initialBounds = new Rectangle(0, 0, 100, 100);
    Robot robot;
    Rectangle[] serverBounds;
    private static final int SERVER_BOUNDS = 0;
    private static final int OTHER_FRAME = 1;
    private static final int SERVER_FOCUS = 2;
    private static final int SERVER_MODAL = 3;
    private static final int MODAL_CLOSE = 4;
    LinkedList<Integer> events = new LinkedList();

    private XEmbedServerTester(Rectangle[] serverBounds, long parent) {
        this.parent = parent;
        this.focusedKind = -1;
        this.focusedServerComponent = -1;
        this.reparent = false;
        this.windowActive = false;
        this.xembedActive = false;
        this.my_version = 0;
        this.mapped = 1;
        this.serverBounds = serverBounds;
        if (serverBounds.length < 5) {
            throw new IllegalArgumentException("There must be at least five areas: server-activation, server-deactivation, server-focus, server-modal show, modal-close");
        }
        try {
            this.robot = new Robot();
            this.robot.setAutoDelay(100);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't create robot");
        }
        this.initAccel();
        xembedLog.finer("XEmbed client(tester), embedder window: " + Long.toHexString(parent));
    }

    public static XEmbedServerTester getTester(Rectangle[] serverBounds, long parent) {
        return new XEmbedServerTester(serverBounds, parent);
    }

    private void dumpReceivedEvents() {
        xembedLog.finer("Events received so far:");
        int pos = 0;
        for (Integer event : this.events) {
            xembedLog.finer(pos++ + ":" + XEmbedHelper.msgidToString(event));
        }
        xembedLog.finer("End of event dump");
    }

    public void test1_1() {
        int res = this.embedCompletely();
        this.waitWindowActivated(res);
        this.requestFocus();
        this.deactivateServer();
        res = this.activateServer(this.getEventPos());
        this.waitFocusGained(res);
        this.checkFocusGained(0);
    }

    public void test1_2() {
        int res = this.embedCompletely();
        this.waitWindowActivated(res);
        this.requestFocus();
        this.checkFocusGained(0);
    }

    public void test1_3() {
        this.embedCompletely();
        this.deactivateServer();
        this.requestFocusNoWait();
        this.checkNotFocused();
    }

    public void test1_4() {
        this.embedCompletely();
        this.deactivateServer();
        this.requestFocusNoWait();
        this.checkNotFocused();
        int res = this.getEventPos();
        this.activateServer(res);
        this.waitFocusGained(res);
        this.checkFocusGained(0);
    }

    public void test1_5() {
        int res = this.embedCompletely();
        this.waitWindowActivated(res);
        this.checkWindowActivated();
    }

    public void test1_6() {
        int res = this.embedCompletely();
        this.waitWindowActivated(res);
        this.requestFocus();
        res = this.deactivateServer();
        this.checkFocused();
    }

    public void test1_7() {
        int res = this.embedCompletely();
        this.waitWindowActivated(res);
        this.requestFocus();
        this.focusServer();
        this.checkFocusLost();
    }

    public void test2_5() {
        int res = this.embedCompletely();
        this.waitWindowActivated(res);
        this.requestFocus();
        this.focusServerNext();
        this.checkFocusedServerNext();
        this.checkFocusLost();
    }

    public void test2_6() {
        int res = this.embedCompletely();
        this.waitWindowActivated(res);
        this.requestFocus();
        this.focusServerPrev();
        this.checkFocusedServerPrev();
        this.checkFocusLost();
    }

    public void test3_1() {
        this.reparent = false;
        this.embedCompletely();
    }

    public void test3_3() {
        this.reparent = true;
        this.embedCompletely();
    }

    public void test3_4() {
        this.my_version = 10;
        this.embedCompletely();
        if (this.server_version != 0) {
            throw new RuntimeException("Version " + this.server_version + " is not minimal");
        }
    }

    public void test3_5() {
        this.embedCompletely();
        this.window.destroy();
        this.sleep(1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test3_6() {
        this.embedCompletely();
        this.sleep(1000);
        XToolkit.awtLock();
        try {
            XlibWrapper.XUnmapWindow(XToolkit.getDisplay(), this.window.getWindow());
            XlibWrapper.XReparentWindow(XToolkit.getDisplay(), this.window.getWindow(), XToolkit.getDefaultRootWindow(), 0, 0);
        }
        finally {
            XToolkit.awtUnlock();
        }
        int res = this.getEventPos();
        this.activateServerNoWait(res);
        this.sleep(1000);
        if (this.checkEventList(res, 1) != -1) {
            throw new RuntimeException("Focus was been given to the client after XEmbed has ended");
        }
    }

    public void test4_1() {
        this.mapped = 1;
        int res = this.getEventPos();
        this.embedCompletely();
        this.sleep(1000);
        this.checkMapped();
    }

    public void test4_2() {
        this.mapped = 0;
        this.embedCompletely();
        this.sleep(1000);
        int res = this.getEventPos();
        this.mapped = 1;
        this.updateEmbedInfo();
        this.sleep(1000);
        this.checkMapped();
    }

    public void test4_3() {
        int res = this.getEventPos();
        this.mapped = 1;
        this.embedCompletely();
        res = this.getEventPos();
        this.mapped = 0;
        this.updateEmbedInfo();
        this.sleep(1000);
        this.checkNotMapped();
    }

    public void test4_4() {
        this.mapped = 0;
        this.embedCompletely();
        this.sleep(1000);
        if (XlibUtil.getWindowMapState(this.window.getWindow()) != 0) {
            throw new RuntimeException("Client has been mapped");
        }
    }

    public void test6_1_1() {
        this.embedCompletely();
        this.registerAccelerator();
        this.focusServer();
        int res = this.pressAccelKey();
        this.waitForEvent(res, 14);
    }

    public void test6_1_2() {
        this.embedCompletely();
        this.registerAccelerator();
        this.focusServer();
        this.deactivateServer();
        int res = this.pressAccelKey();
        this.sleep(1000);
        if (this.checkEventList(res, 14) != -1) {
            throw new RuntimeException("Accelerator has been activated in inactive embedder");
        }
    }

    public void test6_1_3() {
        this.embedCompletely();
        this.registerAccelerator();
        this.focusServer();
        this.deactivateServer();
        this.unregisterAccelerator();
        int res = this.pressAccelKey();
        this.sleep(1000);
        if (this.checkEventList(res, 14) != -1) {
            throw new RuntimeException("Accelerator has been activated after unregistering");
        }
    }

    public void test6_1_4() {
        this.embedCompletely();
        this.registerAccelerator();
        this.requestFocus();
        int res = this.pressAccelKey();
        this.sleep(1000);
        if (this.checkEventList(res, 14) != -1) {
            throw new RuntimeException("Accelerator has been activated in focused client");
        }
    }

    public void test6_2_1() {
        this.embedCompletely();
        this.grabKey();
        this.focusServer();
        int res = this.pressAccelKey();
        this.waitSystemEvent(res, 2);
    }

    public void test6_2_2() {
        this.embedCompletely();
        this.grabKey();
        this.focusServer();
        this.deactivateServer();
        int res = this.pressAccelKey();
        this.sleep(1000);
        if (this.checkEventList(res, 32770) != -1) {
            throw new RuntimeException("Accelerator has been activated in inactive embedder");
        }
    }

    public void test6_2_3() {
        this.embedCompletely();
        this.grabKey();
        this.focusServer();
        this.deactivateServer();
        this.ungrabKey();
        int res = this.pressAccelKey();
        this.sleep(1000);
        if (this.checkEventList(res, 32770) != -1) {
            throw new RuntimeException("Accelerator has been activated after unregistering");
        }
    }

    public void test6_2_4() {
        this.embedCompletely();
        this.grabKey();
        this.requestFocus();
        int res = this.pressAccelKey();
        this.sleep(1000);
        int pos = this.checkEventList(res, 32770);
        if (pos != -1 && (pos = this.checkEventList(pos + 1, 32770)) != -1) {
            throw new RuntimeException("Accelerator has been activated in focused client");
        }
    }

    public void test7_1() {
        this.embedCompletely();
        int res = this.showModalDialog();
        this.waitForEvent(res, 10);
    }

    public void test7_2() {
        this.embedCompletely();
        int res = this.showModalDialog();
        this.waitForEvent(res, 10);
        res = this.hideModalDialog();
        this.waitForEvent(res, 11);
    }

    public void test9_1() {
        this.embedCompletely();
        this.requestFocus();
        int res = this.pressAccelKey();
        this.waitForEvent(res, 32770);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int embed() {
        int res = this.getEventPos();
        XToolkit.awtLock();
        try {
            XCreateWindowParams params = new XCreateWindowParams(new Object[]{"parent window", this.reparent ? XToolkit.getDefaultRootWindow() : this.parent, "bounds", initialBounds, "embedded", Boolean.TRUE, "visible", this.mapped == 1, "event mask", 720897L});
            this.window = new XBaseWindow(params);
            xembedLog.finer("Created tester window: " + this.window);
            XToolkit.addEventDispatcher(this.window.getWindow(), this);
            this.updateEmbedInfo();
            if (this.reparent) {
                xembedLog.finer("Reparenting to embedder");
                XlibWrapper.XReparentWindow(XToolkit.getDisplay(), this.window.getWindow(), this.parent, 0, 0);
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEmbedInfo() {
        long[] info = new long[]{this.my_version, this.mapped};
        long data = Native.card32ToData(info);
        try {
            XEmbedHelper.XEmbedInfo.setAtomData(this.window.getWindow(), data, info.length);
        }
        finally {
            XEmbedHelper.unsafe.freeMemory(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getEventPos() {
        Object object = this.EVENT_LOCK;
        synchronized (object) {
            return this.events.size();
        }
    }

    private int embedCompletely() {
        xembedLog.fine("Embedding completely");
        int res = this.getEventPos();
        this.embed();
        this.waitEmbeddedNotify(res);
        return res;
    }

    private int requestFocus() {
        xembedLog.fine("Requesting focus");
        int res = this.getEventPos();
        this.sendMessage(3);
        this.waitFocusGained(res);
        return res;
    }

    private int requestFocusNoWait() {
        xembedLog.fine("Requesting focus without wait");
        int res = this.getEventPos();
        this.sendMessage(3);
        return res;
    }

    private int activateServer(int prev) {
        int res = this.activateServerNoWait(prev);
        this.waitWindowActivated(res);
        return res;
    }

    private int activateServerNoWait(int prev) {
        xembedLog.fine("Activating server");
        int res = this.getEventPos();
        if (this.checkEventList(prev, 1) != -1) {
            xembedLog.fine("Activation already received");
            return res;
        }
        Point loc = this.serverBounds[0].getLocation();
        loc.x = (int)((double)loc.x + this.serverBounds[0].getWidth() / 2.0);
        loc.y += 5;
        this.robot.mouseMove(loc.x, loc.y);
        this.robot.mousePress(16);
        this.robot.mouseRelease(16);
        return res;
    }

    private int deactivateServer() {
        xembedLog.fine("Deactivating server");
        int res = this.getEventPos();
        Point loc = this.serverBounds[1].getLocation();
        loc.x = (int)((double)loc.x + this.serverBounds[1].getWidth() / 2.0);
        loc.y = (int)((double)loc.y + this.serverBounds[1].getHeight() / 2.0);
        this.robot.mouseMove(loc.x, loc.y);
        this.robot.mousePress(16);
        this.robot.delay(50);
        this.robot.mouseRelease(16);
        this.waitWindowDeactivated(res);
        return res;
    }

    private int focusServer() {
        xembedLog.fine("Focusing server");
        boolean weFocused = this.focused;
        int res = this.getEventPos();
        Point loc = this.serverBounds[2].getLocation();
        loc.x += 5;
        loc.y += 5;
        this.robot.mouseMove(loc.x, loc.y);
        this.robot.mousePress(16);
        this.robot.delay(50);
        this.robot.mouseRelease(16);
        if (weFocused) {
            this.waitFocusLost(res);
        }
        return res;
    }

    private int focusServerNext() {
        xembedLog.fine("Focusing next server component");
        int res = this.getEventPos();
        this.sendMessage(6);
        this.waitFocusLost(res);
        return res;
    }

    private int focusServerPrev() {
        xembedLog.fine("Focusing previous server component");
        int res = this.getEventPos();
        this.sendMessage(7);
        this.waitFocusLost(res);
        return res;
    }

    private void waitEmbeddedNotify(int pos) {
        this.waitForEvent(pos, 0);
    }

    private void waitFocusGained(int pos) {
        this.waitForEvent(pos, 4);
    }

    private void waitFocusLost(int pos) {
        this.waitForEvent(pos, 5);
    }

    private void waitWindowActivated(int pos) {
        this.waitForEvent(pos, 1);
    }

    private void waitWindowDeactivated(int pos) {
        this.waitForEvent(pos, 2);
    }

    private void waitSystemEvent(int position, int event) {
        this.waitForEvent(position, event | 0x8000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForEvent(int position, int event) {
        Object object = this.EVENT_LOCK;
        synchronized (object) {
            if (this.checkEventList(position, event) != -1) {
                xembedLog.finer("The event " + XEmbedHelper.msgidToString(event) + " has already been received");
                return;
            }
            if (this.eventReceived == event) {
                xembedLog.finer("Already received " + XEmbedHelper.msgidToString(event));
                return;
            }
            this.eventReceived = -1;
            this.eventWaited = event;
            xembedLog.finer("Waiting for " + XEmbedHelper.msgidToString(event) + " starting from " + position);
            try {
                this.EVENT_LOCK.wait(3000L);
            }
            catch (InterruptedException ie) {
                xembedLog.warning("Event wait interrupted", ie);
            }
            this.eventWaited = -1;
            if (this.checkEventList(position, event) == -1) {
                this.dumpReceivedEvents();
                throw new RuntimeException("Didn't receive event " + XEmbedHelper.msgidToString(event) + " but recevied " + XEmbedHelper.msgidToString(this.eventReceived));
            }
            xembedLog.finer("Successfully recevied " + XEmbedHelper.msgidToString(event));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int checkEventList(int position, int event) {
        if (position == -1) {
            return -1;
        }
        Object object = this.EVENT_LOCK;
        synchronized (object) {
            for (int i = position; i < this.events.size(); ++i) {
                if (this.events.get(i) != event) continue;
                return i;
            }
            return -1;
        }
    }

    private void checkFocusedServerNext() {
        if (this.focusedServerComponent != 0) {
            throw new RuntimeException("Wrong focused server component, should be 0, but it is " + this.focusedServerComponent);
        }
    }

    private void checkFocusedServerPrev() {
        if (this.focusedServerComponent != 2) {
            throw new RuntimeException("Wrong focused server component, should be 2, but it is " + this.focusedServerComponent);
        }
    }

    private void checkFocusGained(int kind) {
        if (!this.focused) {
            throw new RuntimeException("Didn't receive FOCUS_GAINED");
        }
        if (this.focusedKind != kind) {
            throw new RuntimeException("Kinds don't match, required: " + kind + ", current: " + this.focusedKind);
        }
    }

    private void checkNotFocused() {
        if (this.focused) {
            throw new RuntimeException("Focused");
        }
    }

    private void checkFocused() {
        if (!this.focused) {
            throw new RuntimeException("Not Focused");
        }
    }

    private void checkFocusLost() {
        this.checkNotFocused();
        if (this.focusedKind != 5) {
            throw new RuntimeException("Didn't receive FOCUS_LOST");
        }
    }

    private void checkWindowActivated() {
        if (!this.windowActive) {
            throw new RuntimeException("Window is not active");
        }
    }

    private void checkMapped() {
        if (XlibUtil.getWindowMapState(this.window.getWindow()) == 0) {
            throw new RuntimeException("Client is not mapped");
        }
    }

    private void checkNotMapped() {
        if (XlibUtil.getWindowMapState(this.window.getWindow()) != 0) {
            throw new RuntimeException("Client is mapped");
        }
    }

    private void sendMessage(int message) {
        this.xembed.sendMessage(this.parent, message);
    }

    private void sendMessage(int message, int detail, long data1, long data2) {
        this.xembed.sendMessage(this.parent, message, detail, data1, data2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatchEvent(XEvent ev) {
        if (ev.get_type() == 33) {
            XClientMessageEvent msg = ev.get_xclient();
            if (msg.get_message_type() == XEmbedHelper.XEmbed.getAtom()) {
                if (xembedLog.isLoggable(500)) {
                    xembedLog.fine("Embedded message: " + XEmbedHelper.msgidToString((int)msg.get_data(1)));
                }
                switch ((int)msg.get_data(1)) {
                    case 0: {
                        this.xembedActive = true;
                        this.server_version = (int)msg.get_data(3);
                        break;
                    }
                    case 1: {
                        this.windowActive = true;
                        break;
                    }
                    case 2: {
                        this.windowActive = false;
                        break;
                    }
                    case 4: {
                        this.focused = true;
                        this.focusedKind = (int)msg.get_data(2);
                        break;
                    }
                    case 5: {
                        this.focused = false;
                        this.focusedKind = 5;
                        this.focusedServerComponent = (int)msg.get_data(2);
                    }
                }
                Object object = this.EVENT_LOCK;
                synchronized (object) {
                    this.events.add((int)msg.get_data(1));
                    xembedLog.finer("Tester is waiting for " + XEmbedHelper.msgidToString(this.eventWaited));
                    if ((int)msg.get_data(1) == this.eventWaited) {
                        this.eventReceived = (int)msg.get_data(1);
                        xembedLog.finer("Notifying waiting object for event " + System.identityHashCode(this.EVENT_LOCK));
                        this.EVENT_LOCK.notifyAll();
                    }
                }
            }
        } else {
            Object object = this.EVENT_LOCK;
            synchronized (object) {
                int eventID = ev.get_type() | 0x8000;
                this.events.add(eventID);
                xembedLog.finer("Tester is waiting for " + XEmbedHelper.msgidToString(this.eventWaited) + ", but we received " + ev + "(" + XEmbedHelper.msgidToString(eventID) + ")");
                if (eventID == this.eventWaited) {
                    this.eventReceived = eventID;
                    xembedLog.finer("Notifying waiting object" + System.identityHashCode(this.EVENT_LOCK));
                    this.EVENT_LOCK.notifyAll();
                }
            }
        }
    }

    private void sleep(int amount) {
        try {
            Thread.sleep(amount);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void registerAccelerator() {
        this.sendMessage(12, 1, this.accel_keysym, this.accel_mods);
    }

    private void unregisterAccelerator() {
        this.sendMessage(13, 1, 0L, 0L);
    }

    private int pressAccelKey() {
        int res = this.getEventPos();
        this.robot.keyPress(this.accel_key);
        this.robot.keyRelease(this.accel_key);
        return res;
    }

    private void initAccel() {
        this.accel_key = 65;
        this.accel_keysym = XWindow.getKeySymForAWTKeyCode(this.accel_key);
        this.accel_mods = 0;
    }

    private void grabKey() {
        this.sendMessage(108, 0, this.accel_keysym, this.accel_mods);
    }

    private void ungrabKey() {
        this.sendMessage(109, 0, this.accel_keysym, this.accel_mods);
    }

    private int showModalDialog() {
        xembedLog.fine("Showing modal dialog");
        int res = this.getEventPos();
        Point loc = this.serverBounds[3].getLocation();
        loc.x += 5;
        loc.y += 5;
        this.robot.mouseMove(loc.x, loc.y);
        this.robot.mousePress(16);
        this.robot.delay(50);
        this.robot.mouseRelease(16);
        return res;
    }

    private int hideModalDialog() {
        xembedLog.fine("Hide modal dialog");
        int res = this.getEventPos();
        this.robot.keyPress(32);
        this.robot.keyRelease(32);
        return res;
    }
}

