/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.resolver.model;

import org.gradle.api.Project;
import org.gradle.plugins.ide.internal.resolver.model.IdeDependency;

public class IdeProjectDependency
extends IdeDependency {
    private final Project project;
    private final String projectPath;

    public IdeProjectDependency(String declaredConfiguration, Project project) {
        super(declaredConfiguration);
        this.project = project;
        this.projectPath = project.getPath();
    }

    public IdeProjectDependency(String declaredConfiguration, String projectPath) {
        super(declaredConfiguration);
        this.project = null;
        this.projectPath = projectPath;
    }

    public Project getProject() {
        return this.project;
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public String getModuleName() {
        if (this.projectPath.endsWith("::")) {
            return this.projectPath.substring(0, this.projectPath.length() - 2);
        }
        int index = this.projectPath.lastIndexOf(58);
        return this.projectPath.substring(index + 1);
    }
}

