/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.incremental;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.internal.changedetection.state.FileSnapshotter;
import org.gradle.cache.PersistentStateCache;
import org.gradle.language.nativeplatform.internal.IncludeDirectives;
import org.gradle.language.nativeplatform.internal.incremental.CompilationFileState;
import org.gradle.language.nativeplatform.internal.incremental.CompilationState;
import org.gradle.language.nativeplatform.internal.incremental.DefaultIncrementalCompilation;
import org.gradle.language.nativeplatform.internal.incremental.IncrementalCompilation;
import org.gradle.language.nativeplatform.internal.incremental.ResolvedInclude;
import org.gradle.language.nativeplatform.internal.incremental.SourceIncludesParser;
import org.gradle.language.nativeplatform.internal.incremental.SourceIncludesResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncrementalCompileProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(IncrementalCompileProcessor.class);
    private final PersistentStateCache<CompilationState> previousCompileStateCache;
    private final SourceIncludesParser sourceIncludesParser;
    private final SourceIncludesResolver sourceIncludesResolver;
    private final FileSnapshotter snapshotter;

    public IncrementalCompileProcessor(PersistentStateCache<CompilationState> previousCompileStateCache, SourceIncludesResolver sourceIncludesResolver, SourceIncludesParser sourceIncludesParser, FileSnapshotter snapshotter) {
        this.previousCompileStateCache = previousCompileStateCache;
        this.sourceIncludesResolver = sourceIncludesResolver;
        this.sourceIncludesParser = sourceIncludesParser;
        this.snapshotter = snapshotter;
    }

    public IncrementalCompilation processSourceFiles(Collection<File> sourceFiles) {
        CompilationState previousCompileState = (CompilationState)this.previousCompileStateCache.get();
        IncrementalCompileFiles result = new IncrementalCompileFiles(previousCompileState);
        for (File sourceFile : sourceFiles) {
            result.processSource(sourceFile);
        }
        return new DefaultIncrementalCompilation(result.current, result.getModifiedSources(), result.getRemovedSources(), result.getDiscoveredInputs());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IncrementalCompileFiles {
        private final CompilationState previous;
        private final CompilationState current = new CompilationState();
        private final Map<File, Boolean> processed = new HashMap<File, Boolean>();
        private final List<File> toRecompile = new ArrayList<File>();
        private final Set<File> discoveredInputs = Sets.newHashSet();

        public IncrementalCompileFiles(CompilationState previousCompileState) {
            this.previous = previousCompileState == null ? new CompilationState() : previousCompileState;
        }

        public void processSource(File sourceFile) {
            this.current.addSourceInput(sourceFile);
            if (this.checkChangedAndUpdateState(sourceFile) || !this.previous.getSourceInputs().contains(sourceFile)) {
                this.toRecompile.add(sourceFile);
            }
        }

        public boolean checkChangedAndUpdateState(File file) {
            boolean changed = false;
            if (this.processed.containsKey(file)) {
                return this.processed.get(file);
            }
            if (!file.exists()) {
                return true;
            }
            this.processed.put(file, false);
            CompilationFileState previousState = this.previous.getState(file);
            CompilationFileState newState = new CompilationFileState(IncrementalCompileProcessor.this.snapshotter.snapshot(file).getHash());
            if (!this.sameHash(previousState, newState)) {
                changed = true;
                newState.setIncludeDirectives(IncrementalCompileProcessor.this.sourceIncludesParser.parseIncludes(file));
            } else {
                newState.setIncludeDirectives(previousState.getIncludeDirectives());
            }
            SourceIncludesResolver.ResolvedSourceIncludes resolutionResult = this.resolveIncludes(file, newState.getIncludeDirectives());
            newState.setResolvedIncludes(resolutionResult.getResolvedIncludes());
            this.discoveredInputs.addAll(resolutionResult.getCheckedLocations());
            if (!this.sameResolved(previousState, newState)) {
                changed = true;
            }
            this.current.setState(file, newState);
            for (ResolvedInclude dep : newState.getResolvedIncludes()) {
                if (dep.isUnknown()) {
                    LOGGER.info("Cannot determine changed state of included '{}' in source file '{}'. Assuming changed.", (Object)dep.getInclude(), (Object)file.getName());
                    changed = true;
                    continue;
                }
                boolean depChanged = this.checkChangedAndUpdateState(dep.getFile());
                changed = changed || depChanged;
            }
            this.processed.put(file, changed);
            return changed;
        }

        private boolean sameHash(CompilationFileState previousState, CompilationFileState newState) {
            return previousState != null && newState.getHash().equals((Object)previousState.getHash());
        }

        private boolean sameResolved(CompilationFileState previousState, CompilationFileState newState) {
            return previousState != null && newState.getResolvedIncludes().equals(previousState.getResolvedIncludes());
        }

        private SourceIncludesResolver.ResolvedSourceIncludes resolveIncludes(File file, IncludeDirectives includeDirectives) {
            return IncrementalCompileProcessor.this.sourceIncludesResolver.resolveIncludes(file, includeDirectives);
        }

        public List<File> getModifiedSources() {
            return this.toRecompile;
        }

        public List<File> getRemovedSources() {
            ArrayList<File> removed = new ArrayList<File>();
            for (File previousSource : this.previous.getSourceInputs()) {
                if (this.current.getSourceInputs().contains(previousSource)) continue;
                removed.add(previousSource);
            }
            return removed;
        }

        public Set<File> getDiscoveredInputs() {
            return this.discoveredInputs;
        }
    }
}

